/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.DSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.DSAPKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;

public final class PKCS11SHA1withDSA
extends Signature {
    private MessageDigest dataSHA = MessageDigest.getInstance("SHA", "IBMPKCS11");
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private boolean isSinglePart;

    public PKCS11SHA1withDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        super("SHA/DSA");
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        int n = 18;
        if (!(privateKey instanceof DSAPKCS11PrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPKCS11PrivateKey dSAPKCS11PrivateKey = (DSAPKCS11PrivateKey)privateKey;
        this.isSign = true;
        this.session = dSAPKCS11PrivateKey.getSession();
        this.keyObject = dSAPKCS11PrivateKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 17) {
                bl = true;
                n = 17;
                this.isSinglePart = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == 18) {
                    bl = true;
                    n = 18;
                    this.isSinglePart = false;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new UnsupportedOperationException("The token does not support SHA1withDSA");
            }
        }
        this.session.signInit(n, null, this.keyObject);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        int n = 18;
        if (!(publicKey instanceof DSAPublicKey) && !(publicKey instanceof DSAPKCS11PublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPKCS11PublicKey dSAPKCS11PublicKey = (DSAPKCS11PublicKey)publicKey;
        this.isSign = false;
        this.session = dSAPKCS11PublicKey.getSession();
        this.keyObject = dSAPKCS11PublicKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 17) {
                bl = true;
                n = 17;
                this.isSinglePart = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == 18) {
                    bl = true;
                    n = 18;
                    this.isSinglePart = false;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new UnsupportedOperationException("The token does not support SHA1withDSA");
            }
        }
        this.session.verifyInit(n, null, this.keyObject);
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray;
        int n = 0;
        byte[] byArray2 = new byte[40];
        byte[] byArray3 = new byte[200];
        if (this.isSinglePart) {
            byArray = this.dataSHA.digest();
            n = this.session.sign(byArray, 0, byArray.length, byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, 0, n);
        } else {
            n = this.session.signFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, 0, n);
        }
        try {
            byArray = new byte[20];
            byte[] byArray4 = new byte[20];
            System.arraycopy(byArray2, 0, byArray, 0, 20);
            System.arraycopy(byArray2, 20, byArray4, 0, 20);
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(new BigInteger(1, byArray));
            derOutputStream.putInteger(new BigInteger(1, byArray4));
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        if (this.isSinglePart) {
            this.dataSHA.update(by);
        } else if (this.isSign) {
            this.session.signUpdate(byArray, 0, 1);
        } else {
            this.session.verifyUpdate(byArray, 0, 1);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.isSinglePart) {
            this.dataSHA.update(byArray, n, n2);
        } else if (this.isSign) {
            this.session.signUpdate(byArray, n, n2);
        } else {
            this.session.verifyUpdate(byArray, n, n2);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        byte[] byArray2 = new byte[40];
        try {
            object = new DerInputStream(byArray);
            DerValue[] derValueArray = object.getSequence(2);
            byte[] byArray3 = derValueArray[0].getInteger().toByteArray();
            byte[] byArray4 = derValueArray[1].getInteger().toByteArray();
            int n = byArray3.length;
            if (n > 20) {
                System.arraycopy(byArray3, n - 20, byArray2, 0, 20);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 20 - n, n);
            }
            n = byArray4.length;
            if (n > 20) {
                System.arraycopy(byArray4, n - 20, byArray2, 20, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray2, 40 - n, n);
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature :" + iOException);
        }
        if (this.isSinglePart) {
            object = this.dataSHA.digest();
            return this.session.verify((byte[])object, 0, ((DerInputStream)object).length, byArray2, 0, byArray2.length);
        }
        return this.session.verifyFinal(byArray2, 0, byArray2.length);
    }
}

