/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.RSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;

public final class PKCS11MD2withRSA
extends Signature {
    private MessageDigest dataMD2 = MessageDigest.getInstance("MD2", "IBMPKCS11");
    private String oid = "1.2.840.113549.2.2";
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private boolean isSinglePart;
    private byte[] returnSignature;

    public PKCS11MD2withRSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        super("MD2/RSA");
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        int n = 4;
        if (!(privateKey instanceof RSAPKCS11PrivateKey)) {
            throw new InvalidKeyException("not a RSA private key: " + privateKey);
        }
        RSAPKCS11PrivateKey rSAPKCS11PrivateKey = (RSAPKCS11PrivateKey)privateKey;
        this.isSign = true;
        this.session = rSAPKCS11PrivateKey.getSession();
        this.keyObject = rSAPKCS11PrivateKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 1) {
                bl = true;
                n = 1;
                this.isSinglePart = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == 4) {
                    bl = true;
                    n = 4;
                    this.isSinglePart = false;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new UnsupportedOperationException("The token does not support MD2withRSA");
            }
        }
        this.session.signInit(n, null, this.keyObject);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        int n = 4;
        if (!(publicKey instanceof RSAPublicKey) && !(publicKey instanceof RSAPKCS11PublicKey)) {
            throw new InvalidKeyException("not a RSA public key: " + publicKey);
        }
        RSAPKCS11PublicKey rSAPKCS11PublicKey = (RSAPKCS11PublicKey)publicKey;
        this.isSign = false;
        this.session = rSAPKCS11PublicKey.getSession();
        this.keyObject = rSAPKCS11PublicKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 1) {
                bl = true;
                n = 1;
                this.isSinglePart = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == 4) {
                    bl = true;
                    n = 4;
                    this.isSinglePart = false;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new UnsupportedOperationException("The token does not support MD2withRSA");
            }
        }
        this.session.verifyInit(n, null, this.keyObject);
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected byte[] engineSign() throws SignatureException {
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = new byte[256];
        if (this.isSinglePart) {
            Object object;
            byte[] byArray3 = this.dataMD2.digest();
            DerOutputStream derOutputStream = null;
            try {
                derOutputStream = new DerOutputStream();
                object = new DerOutputStream();
                AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
                algorithmId.encode(object);
                DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray3)};
                derOutputStream.putSequence(derValueArray);
            }
            catch (IOException iOException) {
                throw new SignatureException("error encoding signature");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SignatureException("error encoding signature");
            }
            object = derOutputStream.toByteArray();
            n = this.session.sign((byte[])object, 0, ((DerOutputStream)object).length, byArray2, 0);
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            return byArray;
        }
        n = this.session.signFinal(byArray2, 0);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        if (this.isSinglePart) {
            this.dataMD2.update(by);
        } else if (this.isSign) {
            this.session.signUpdate(byArray, 0, 1);
        } else {
            this.session.verifyUpdate(byArray, 0, 1);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.isSinglePart) {
            this.dataMD2.update(byArray, n, n2);
        } else if (this.isSign) {
            this.session.signUpdate(byArray, n, n2);
        } else {
            this.session.verifyUpdate(byArray, n, n2);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.isSinglePart) {
            Object object;
            byte[] byArray2 = this.dataMD2.digest();
            DerOutputStream derOutputStream = null;
            try {
                derOutputStream = new DerOutputStream();
                object = new DerOutputStream();
                AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
                algorithmId.encode(object);
                DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray2)};
                derOutputStream.putSequence(derValueArray);
            }
            catch (IOException iOException) {
                throw new SignatureException("error encoding signature");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SignatureException("error encoding signature");
            }
            object = derOutputStream.toByteArray();
            return this.session.verify((byte[])object, 0, ((DerOutputStream)object).length, byArray, 0, byArray.length);
        }
        return this.session.verifyFinal(byArray, 0, byArray.length);
    }
}

