/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.PKCS11DSAPublicKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;

final class DSAPKCS11PublicKey
extends X509Key
implements PKCS11DSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    private PKCS11Session[] allSessions = null;
    private String label = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private int slotID;

    public DSAPKCS11PublicKey(int n, PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2) throws InvalidKeyException {
        this.slotID = n;
        this.object = pKCS11Object;
        this.session = pKCS11Session;
        this.allSessions = pKCS11SessionArray;
        if (string != null) {
            this.label = string;
        }
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        }
        if (bl != null) {
            this.isEncrypt = new Boolean(bl);
        }
        if (bl2 != null) {
            this.isVerify = new Boolean(bl2);
        }
    }

    public DSAPKCS11PublicKey(int n, PKCS11Object pKCS11Object, PKCS11Session pKCS11Session, PKCS11Session[] pKCS11SessionArray, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this(n, pKCS11Object, pKCS11Session, pKCS11SessionArray, string, byArray, byArray2, bl, bl2);
        if (bigInteger != null) {
            this.prime = new BigInteger(bigInteger.toByteArray());
        }
        if (bigInteger2 != null) {
            this.subprime = new BigInteger(bigInteger2.toByteArray());
        }
        if (bigInteger3 != null) {
            this.base = new BigInteger(bigInteger3.toByteArray());
        }
        if (bigInteger4 != null) {
            this.value = new BigInteger(bigInteger4.toByteArray());
        }
        this.algid = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("coud not DER encode y: " + iOException.getMessage());
            }
        }
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public BigInteger getBase() {
        return this.base;
    }

    public Boolean getDerive() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Date getEndDate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getLocal() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getModifiable() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public PKCS11Session[] getOpenSessions() {
        return this.allSessions;
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public Boolean getPrivate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public Date getStartDate() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    public BigInteger getSubprime() {
        return this.subprime;
    }

    public Boolean getToken() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public BigInteger getValue() {
        return this.value;
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getVerifyRecover() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public Boolean getWrap() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.value = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid key value\n" + iOException.getMessage());
        }
    }

    public String toString() {
        String string = "IBMPKCS11";
        String string2 = String.valueOf(string) + " DSA Public Key: ";
        if (this.label != null) {
            string2 = String.valueOf(string2) + "\n label: " + this.label;
        }
        if (this.ID != null) {
            string2 = String.valueOf(string2) + "\n ID: " + new String(this.ID);
        }
        if (this.subject != null) {
            string2 = String.valueOf(string2) + "\n subject: " + new String(this.subject);
        }
        if (this.isEncrypt != null) {
            string2 = String.valueOf(string2) + "\n encrypt: " + this.isEncrypt;
        }
        if (this.isVerify != null) {
            string2 = String.valueOf(string2) + "\n verify: " + this.isVerify;
        }
        if (this.prime != null) {
            string2 = String.valueOf(string2) + "\n prime: " + this.prime.toString();
        }
        if (this.subprime != null) {
            string2 = String.valueOf(string2) + "\n subprime: " + this.subprime.toString();
        }
        if (this.base != null) {
            string2 = String.valueOf(string2) + "\n base: " + this.base.toString();
        }
        if (this.value != null) {
            string2 = String.valueOf(string2) + "\n value: " + this.value.toString();
        }
        return string2;
    }
}

