/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class ByteToCharISO2022
extends ByteToCharConverter {
    static final byte ISO_ESC = 27;
    static final byte ISO_SI = 15;
    static final byte ISO_SO = 14;
    static final byte ISO_SS2 = 78;
    static final byte ISO_SS3 = 79;
    static final byte MSB = -128;
    static final char REPLACE_CHAR = '\ufffd';
    static final char NO_CHAR = '\uffff';
    private int lvl;
    private int olddata;
    private int seqsize;
    private static final int DATA = 0;
    private static final int ONEDATA = 1;
    private static final int ESCAPE = 2;
    private static final int ESC_DBCS = 3;
    private static final int ESC_LEFT = 4;
    private static final int ESC_RIGHT = 5;
    private static final int ESC_UNKNOWN = 6;
    static final B2C_ISO2022 asciiConv = new B2C_ISO2022("ASCII", 1, false);
    static final B2C_ISO2022 iso1Conv = new B2C_ISO2022("ISO-8859-1", 1, true);
    static final B2C_ISO2022 defConv = new B2C_ISO2022();
    B2C_ISO2022 b2c;
    B2C_ISO2022[] b2cG = new B2C_ISO2022[4];
    B2C_ISO2022 baseConv = null;
    int state;
    int level;
    boolean eightbit = false;
    boolean iso1right = false;

    public void reset() {
        this.state = 0;
        this.olddata = 65535;
        this.level = 0;
        this.b2c = asciiConv;
        this.b2cG[0] = asciiConv;
        this.b2cG[1] = this.iso1right ? iso1Conv : defConv;
        this.b2cG[2] = defConv;
        this.b2cG[3] = defConv;
        this.byteOff = 0;
        this.charOff = 0;
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException {
        if (this.state != 0 || this.olddata != 65535) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    private void setException(int n, int n2) {
        if (this.byteOff - n >= n2) {
            this.badInputLength = n2;
            this.byteOff -= this.badInputLength;
        } else {
            this.badInputLength = 0;
        }
        this.state = 0;
        this.olddata = 65535;
    }

    public final int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws ConversionBufferFullException, MalformedInputException, UnknownCharacterException {
        this.charOff = n3;
        this.byteOff = n;
        while (this.byteOff < n2) {
            byte by = byArray[this.byteOff++];
            int n5 = 65535;
            if (!this.eightbit && (by & 0xFFFFFF80) != 0) {
                if (this.state == 0 || this.state == 1) {
                    this.seqsize = this.olddata == 65535 ? 1 : 2;
                }
                this.setException(n, this.seqsize);
                throw new MalformedInputException();
            }
            block0 : switch (this.state) {
                case 0: 
                case 1: {
                    if (by < 32) {
                        if (this.state == 1 || this.olddata != 65535) {
                            this.setException(n, 1);
                            throw new MalformedInputException();
                        }
                        if (by == 27) {
                            this.state = 2;
                            this.seqsize = 1;
                            break;
                        }
                        if (!this.eightbit) {
                            if (by == 15) {
                                this.b2c = this.b2cG[0];
                                this.level = 0;
                                break;
                            }
                            if (by == 14) {
                                this.b2c = this.b2cG[1];
                                this.level = 1;
                                break;
                            }
                        }
                    }
                    if (this.eightbit && this.state == 0 && (by >> 7 & 1) != this.level) {
                        if (this.olddata != 65535) {
                            this.setException(n, 1);
                            throw new MalformedInputException();
                        }
                        if ((by & 0xFFFFFF80) != 0) {
                            this.b2c = this.b2cG[1];
                            this.level = 1;
                        } else {
                            this.b2c = this.b2cG[0];
                            this.level = 0;
                        }
                    }
                    if ((n5 = (int)this.b2c.getUnicode(this.olddata, by)) != 65535) {
                        if (n5 == 65533) {
                            if (this.subMode) {
                                n5 = this.subChars[0];
                            } else {
                                this.setException(n, this.b2c.datalen);
                                throw new UnknownCharacterException();
                            }
                        }
                        if (this.charOff >= n4) {
                            --this.byteOff;
                            throw new ConversionBufferFullException();
                        }
                        cArray[this.charOff++] = n5;
                        if (this.state == 1) {
                            this.state = 0;
                            this.b2c = this.b2cG[this.level];
                        }
                        this.olddata = 65535;
                        break;
                    }
                    this.olddata = this.b2c.oldData(this.olddata, by);
                    break;
                }
                case 2: {
                    ++this.seqsize;
                    switch (by) {
                        case 36: {
                            this.lvl = 0;
                            this.state = 3;
                            break block0;
                        }
                        case 40: {
                            this.lvl = 0;
                            this.state = 4;
                            break block0;
                        }
                        case 41: {
                            this.lvl = 1;
                            this.state = 4;
                            break block0;
                        }
                        case 45: {
                            this.lvl = 1;
                            this.state = 5;
                            break block0;
                        }
                        case 46: {
                            this.lvl = 2;
                            this.state = 5;
                            break block0;
                        }
                        case 47: {
                            this.lvl = 3;
                            this.state = 5;
                            break block0;
                        }
                        case 78: {
                            this.b2c = this.b2cG[2];
                            this.olddata = 65535;
                            this.state = 1;
                            break block0;
                        }
                        case 79: {
                            this.b2c = this.b2cG[3];
                            this.olddata = 65535;
                            this.state = 1;
                            break block0;
                        }
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 42: 
                        case 43: 
                        case 44: {
                            this.state = 6;
                            break block0;
                        }
                    }
                    this.olddata = 65535;
                    this.state = 0;
                    break;
                }
                case 6: {
                    ++this.seqsize;
                    if (by >= 32 && by <= 47) break;
                    this.olddata = 65535;
                    this.state = 0;
                    break;
                }
                case 3: {
                    ++this.seqsize;
                    if (by <= 47 && by >= 32) {
                        if (by < 40 || by > 43) break;
                        this.lvl = by - 40;
                        break;
                    }
                    switch (by) {
                        case 64: 
                        case 66: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("JIS0208", 2, null, false, this.baseConv);
                            break;
                        }
                        case 65: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("GB2312", 2, null, true, this.baseConv);
                            break;
                        }
                        case 67: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("KSC5601", 2, null, true, this.baseConv);
                            break;
                        }
                        case 68: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("JIS0212", 2, null, true, this.baseConv);
                            break;
                        }
                        case 71: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("EUC_TW", 2, null, true, this.baseConv);
                            break;
                        }
                        case 72: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("EUC_TW", 2, new byte[]{-114, -94}, true, this.baseConv);
                            break;
                        }
                        case 73: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("EUC_TW", 2, new byte[]{-114, -93}, true, this.baseConv);
                            break;
                        }
                        default: {
                            this.b2cG[this.lvl] = new B2C_ISO2022();
                        }
                    }
                    if (this.lvl == this.level) {
                        this.b2c = this.b2cG[this.lvl];
                    }
                    this.olddata = 65535;
                    this.state = 0;
                    break;
                }
                case 4: {
                    if (by == 66) {
                        this.b2cG[this.lvl] = new B2C_ISO2022("ASCII", 1, false);
                    } else if (by == 73) {
                        this.b2cG[this.lvl] = new B2C_ISO2022("JIS0201", 1, true);
                    } else if (by == 74) {
                        this.b2cG[this.lvl] = new B2C_ISO2022("JIS8", 1, false);
                    } else {
                        if (by >= 32 && by <= 47) {
                            ++this.seqsize;
                            break;
                        }
                        this.b2cG[this.lvl] = new B2C_ISO2022("ASCII", 1, false);
                    }
                    if (this.lvl == this.level) {
                        this.b2c = this.b2cG[this.lvl];
                    }
                    this.olddata = 65535;
                    this.state = 0;
                    break;
                }
                case 5: {
                    ++this.seqsize;
                    if (by >= 32 && by <= 47) break;
                    switch (by) {
                        case 65: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_1", 1, true);
                            break;
                        }
                        case 66: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_2", 1, true);
                            break;
                        }
                        case 67: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_3", 1, true);
                            break;
                        }
                        case 68: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_4", 1, true);
                            break;
                        }
                        case 70: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_7", 1, true);
                            break;
                        }
                        case 71: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_6", 1, true);
                            break;
                        }
                        case 72: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_8", 1, true);
                            break;
                        }
                        case 76: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_5", 1, true);
                            break;
                        }
                        case 77: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_9", 1, true);
                            break;
                        }
                        case 84: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("TIS620", 1, true);
                            break;
                        }
                        case 98: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_15", 1, true);
                            break;
                        }
                        default: {
                            this.b2cG[this.lvl] = new B2C_ISO2022("ISO8859_1", 1, true);
                        }
                    }
                    if (this.lvl == this.level) {
                        this.b2c = this.b2cG[this.lvl];
                    }
                    this.olddata = 65535;
                    this.state = 0;
                }
            }
        }
        return this.charOff - n3;
    }

    static class B2C_ISO2022 {
        ByteToCharConverter b2c;
        int type;
        String name;
        int datalen;
        int dflen;
        boolean msb;
        byte[] front;
        byte[] inByte;
        char[] outChar;
        private static final int ASCII = 0;
        private static final int DEFAULT = 1;
        private static final int JIS8 = 2;
        private static final int G1 = 3;

        B2C_ISO2022() {
            this.name = "DEFAULT";
            this.datalen = 1;
            this.type = 1;
        }

        B2C_ISO2022(String string, int n, boolean bl) {
            this(string, n, null, bl, null);
        }

        B2C_ISO2022(String string, int n, byte[] byArray, boolean bl, B2C_ISO2022 b2C_ISO2022) {
            this.name = string;
            this.datalen = n;
            this.dflen = n;
            this.front = byArray;
            if (byArray != null) {
                this.dflen += byArray.length;
            }
            this.msb = bl;
            if (string.equals("ASCII")) {
                this.type = 1;
            } else if (string.equals("JIS8")) {
                this.type = 2;
            } else {
                if (b2C_ISO2022 != null && b2C_ISO2022.b2c != null && string.equals(b2C_ISO2022.name)) {
                    this.b2c = b2C_ISO2022.b2c;
                } else {
                    try {
                        this.b2c = ByteToCharConverter.getConverter(string);
                    }
                    catch (Exception exception) {
                        this.type = 1;
                    }
                }
                this.type = 3;
                this.inByte = new byte[8];
            }
            this.outChar = new char[4];
        }

        char getUnicode(int n, int n2) {
            switch (this.type) {
                case 0: 
                case 1: {
                    return (char)n2;
                }
                case 2: {
                    if (n2 == 92) {
                        return '\u00a5';
                    }
                    if (n2 == 126) {
                        return '\u203e';
                    }
                    return (char)n2;
                }
                case 3: {
                    if (this.msb) {
                        n2 |= 0xFFFFFF80;
                        n |= 0x80;
                    } else {
                        n2 &= 0x7F;
                    }
                    if (this.datalen == 1) {
                        this.inByte[0] = (byte)n2;
                    } else {
                        if (n == 65535) {
                            return '\uffff';
                        }
                        if (this.front != null) {
                            for (int i = 0; i < this.front.length; ++i) {
                                this.inByte[i] = this.front[i];
                            }
                            this.inByte[i] = (byte)n;
                            this.inByte[i + 1] = (byte)n2;
                        } else {
                            this.inByte[0] = (byte)n;
                            this.inByte[1] = (byte)n2;
                        }
                    }
                    try {
                        this.b2c.convert(this.inByte, 0, this.dflen, this.outChar, 0, 4);
                    }
                    catch (Exception exception) {
                        this.outChar[0] = 65533;
                    }
                    return this.outChar[0];
                }
            }
            return '\ufffd';
        }

        int oldData(int n, int n2) {
            if (this.datalen < 2) {
                return 65535;
            }
            return n2 & 0x7F;
        }
    }
}

