/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class UTF8_Encoder
extends IBMCharsetEncoder {
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private final int flags;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit = "NO";

    protected UTF8_Encoder(Charset charset, int n) {
        super(charset, 2.0f, 3.0f);
        this.flags = n;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if ((this.flags & 6) != 0) {
            return true;
        }
        return !Surrogate.is(c);
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = cArray[n];
            if (c < '\u0080') {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c;
                ++n;
                continue;
            }
            if (c < '\u0800') {
                if (n4 - n3 < 2) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                ++n;
                continue;
            }
            if (!Surrogate.is(c) || (this.flags & 4) != 0) {
                if (n4 - n3 < 3) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                ++n;
                continue;
            }
            int n5 = this.sgp.parse(c, cArray, n, n2);
            if (n5 < 0) {
                coderResult = this.sgp.error();
                break;
            }
            if (n4 - n3 < 4) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            byArray[n3++] = (byte)(0xF0 | n5 >> 18 & 7);
            byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
            n += this.sgp.increment();
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)c);
                    ++n;
                    continue;
                }
                if (c < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)(0xC0 | c >> 6 & 0x1F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                    ++n;
                    continue;
                }
                if (!Surrogate.is(c)) {
                    if (byteBuffer.remaining() < 3) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)(0xE0 | c >> 12 & 0xF));
                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                    ++n;
                    continue;
                }
                int n2 = this.sgp.parse(c, charBuffer);
                if (n2 < 0) {
                    CoderResult coderResult = this.sgp.error();
                    return coderResult;
                }
                if (byteBuffer.remaining() < 4) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                byteBuffer.put((byte)(0xF0 | n2 >> 18 & 7));
                byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                byteBuffer.put((byte)(0x80 | n2 & 0x3F));
                n += this.sgp.increment();
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.toString())) {
            int n;
            int n2;
            int n3;
            int n4;
            if (charBuffer.hasArray() && !UseBuffer) {
                char[] cArray = charBuffer.array();
                n4 = charBuffer.arrayOffset() + charBuffer.position();
                n3 = charBuffer.arrayOffset() + charBuffer.limit();
                int n5 = 0;
                int n6 = byteBuffer.remaining();
                for (n2 = n4; n2 < n3; ++n2) {
                    char c = cArray[n2];
                    if (c < '\u0080') {
                        n = 1;
                    } else if (c < '\u0800') {
                        n = 2;
                    } else if (!Surrogate.is(c)) {
                        n = 3;
                    } else {
                        if (Surrogate.isHigh(c) ? n2 + 1 >= n3 || !Surrogate.isLow(cArray[n2 + 1]) : n2 == n4 || !Surrogate.isHigh(cArray[n2 - 1])) break;
                        n = 2;
                    }
                    if (n5 + n > n6) break;
                    n5 += n;
                }
                n = n2 - n4;
            } else {
                int n7 = charBuffer.position();
                n3 = 0;
                n2 = byteBuffer.remaining();
                while (charBuffer.hasRemaining()) {
                    n4 = charBuffer.get();
                    if (n4 < 128) {
                        n = 1;
                    } else if (n4 < 2048) {
                        n = 2;
                    } else if (!Surrogate.is(n4)) {
                        n = 3;
                    } else {
                        if (Surrogate.isHigh(n4) ? !charBuffer.hasRemaining() || !Surrogate.isLow(charBuffer.get(charBuffer.position())) : charBuffer.position() - 2 < n7 || !Surrogate.isHigh(charBuffer.get(charBuffer.position() - 2))) break;
                        n = 2;
                    }
                    if (n3 + n > n2) break;
                    n3 += n;
                }
                n = charBuffer.position() - n7;
                charBuffer.position(n7);
            }
            int n8 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.toString());
            charBuffer.limit(n8);
            n3 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n3 = charBuffer.position() + charBuffer2.position() - n3;
            charBuffer.position(n3);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

