/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.io.CharToByteJIS0208;
import sun.nio.cs.Surrogate;

class ISO2022JP_Encoder
extends CharsetEncoder {
    private static final int ASCII = 0;
    private static final int JIS0201 = 1;
    private static final int JIS0208 = 2;
    private static final int KATAKANA = 3;
    private static final byte ISO_ESC = 27;
    private static final char REPLACE_CHAR = '\ufffd';
    private static final char[] charMap = CharToByteJIS0208.charMap;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private int state;

    ISO2022JP_Encoder(Charset charset, String string) {
        super(charset, 4.0f, 8.0f);
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return byArray.length == 1 && byArray[0] >= 0 && byArray[0] <= 127;
    }

    private CoderResult setForReplacement(CoderResult coderResult, ByteBuffer byteBuffer) {
        if (this.state != 0) {
            if (byteBuffer.remaining() < 3) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)40);
            byteBuffer.put((byte)66);
            this.state = 0;
        }
        return coderResult;
    }

    public boolean canEncode(char c) {
        if (c < '\u0080' || c == '\u00a5' || c == '\u203e' || c >= '\uff61' && c <= '\uff9f') {
            return true;
        }
        return charMap[c] != '\u0000';
    }

    protected void implReset() {
        this.state = 0;
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.state != 0) {
            if (byteBuffer.remaining() < 3) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)40);
            byteBuffer.put((byte)66);
            this.state = 0;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult putByte(ByteBuffer byteBuffer, int n, byte by) {
        if (n != this.state) {
            if (byteBuffer.remaining() < 3) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)40);
            switch (n) {
                case 0: {
                    byteBuffer.put((byte)66);
                    break;
                }
                case 3: {
                    byteBuffer.put((byte)73);
                    break;
                }
                case 1: {
                    byteBuffer.put((byte)74);
                }
            }
            this.state = n;
        }
        if (!byteBuffer.hasRemaining()) {
            return CoderResult.OVERFLOW;
        }
        byteBuffer.put(by);
        return null;
    }

    private CoderResult putDouble(ByteBuffer byteBuffer, char c) {
        if (c == '\u0000') {
            return this.setForReplacement(CoderResult.unmappableForLength(1), byteBuffer);
        }
        if (this.state != 2) {
            if (byteBuffer.remaining() < 3) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)36);
            byteBuffer.put((byte)66);
            this.state = 2;
        }
        if (byteBuffer.remaining() < 2) {
            return CoderResult.OVERFLOW;
        }
        byteBuffer.put((byte)(c >> 8));
        byteBuffer.put((byte)c);
        return null;
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult = null;
        while (charBuffer.hasRemaining()) {
            int n = charBuffer.position();
            char c = charBuffer.get();
            if (Surrogate.is(c) && this.sgp.parse(c, charBuffer) < 0) {
                charBuffer.position(n);
                return this.setForReplacement(this.sgp.error(), byteBuffer);
            }
            coderResult = c <= '\u007f' ? this.putByte(byteBuffer, 0, (byte)c) : (c >= '\uff61' && c <= '\uff9f' ? this.putByte(byteBuffer, 3, (byte)(c - 65344)) : (c == '\u00a5' ? this.putByte(byteBuffer, 1, (byte)92) : (c == '\u203e' ? this.putByte(byteBuffer, 1, (byte)126) : this.putDouble(byteBuffer, charMap[c]))));
            if (coderResult == null) continue;
            charBuffer.position(n);
            return coderResult;
        }
        return CoderResult.UNDERFLOW;
    }
}

