/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class EUC_Decoder
extends IBMCharsetDecoder {
    private final String data;
    private final char[] singleMap;
    private final int convertType;

    protected EUC_Decoder(Charset charset, char[] cArray, String string, byte[] byArray) {
        super(charset, 1.0f, 1.0f);
        this.data = string;
        this.singleMap = cArray;
        this.convertType = byArray != null && byArray.length > 0 ? byArray[0] : 0;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 1;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
            int n6 = byArray[n] & 0xFF;
            char c = this.singleMap[n6];
            if (c < '\ufffd' && this.convertType == 0) {
                n5 = 1;
            } else {
                if (c == '\uffff') {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (n + 1 >= n2) break;
                int n7 = byArray[n + 1] & 0xFF;
                if (this.singleMap[n7] != '\ufffe') {
                    coderResult = CoderResult.malformedForLength(2);
                    break;
                }
                c = this.data.charAt((n6 - 161) * 94 + n7 - 161);
                n5 = 2;
            }
            if (c < '\u0002' && (char)n6 != c) {
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 1;
        try {
            while (byteBuffer.hasRemaining()) {
                int n3 = byteBuffer.get() & 0xFF;
                char c = this.singleMap[n3];
                if (c < '\ufffd' && this.convertType == 0) {
                    n2 = 1;
                } else {
                    if (c == '\uffff') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (!byteBuffer.hasRemaining()) break;
                    int n4 = byteBuffer.get() & 0xFF;
                    if (this.singleMap[n4] != '\ufffe') {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    c = this.data.charAt((n3 - 161) * 94 + n4 - 161);
                    n2 = 2;
                }
                if (c < '\u0002' && (char)n3 != c) {
                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n += n2;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

