/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class EUCTW_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final String data;
    private final int shift;
    private final int mask1;
    private final int mask2;
    private final boolean maplow;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    EUCTW_Encoder(Charset charset, short[] sArray, int n, String string, byte[] byArray, byte[] byArray2) {
        super(charset, 1.5f, 4.0f);
        this.index = sArray;
        this.data = string;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.maplow = byArray != null && byArray.length > 0 ? byArray[0] == 1 : false;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if (c < '\u007f') {
            return true;
        }
        return this.data.charAt(this.index[c >> this.shift] + (c & this.mask2)) > '\u0001';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            int n5;
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            if (this.maplow && c < '\u007f') {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c;
                continue;
            }
            int n6 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
            if (n6 < 160) {
                if (n6 < 2 && n6 != c) {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)n6;
                continue;
            }
            int n7 = n6 & 0x8080;
            if (n7 == 32896) {
                if (n4 - n3 < 2) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)(n6 >> 8);
                byArray[n3++] = (byte)n6;
                continue;
            }
            if (n7 == 32768) {
                n5 = 162;
            } else if (n7 == 128) {
                n5 = 163;
            } else if (n6 >= 8192) {
                n5 = 172;
            } else {
                n5 = 173;
                n6 += 8192;
            }
            if (n4 - n3 < 4) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            byArray[n3++] = -114;
            byArray[n3++] = (byte)n5;
            byArray[n3++] = (byte)((n6 |= 0x8080) >> 8);
            byArray[n3++] = (byte)n6;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (this.maplow && c < '\u007f') {
                    if (!byteBuffer.hasRemaining()) break;
                    byteBuffer.put((byte)c);
                } else {
                    int n2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                    if (n2 < 256) {
                        if (n2 < 2 && n2 != c) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)n2);
                        continue;
                    }
                    int n3 = n2 & 0x8080;
                    if (n3 == 32896) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                    } else {
                        int n4;
                        if (n3 == 32768) {
                            n4 = 162;
                        } else if (n3 == 128) {
                            n4 = 163;
                        } else if (n2 >= 8192) {
                            n4 = 172;
                        } else {
                            n4 = 173;
                            n2 += 8192;
                        }
                        n2 |= 0x8080;
                        if (byteBuffer.remaining() < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)-114);
                        byteBuffer.put((byte)n4);
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                    }
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

