/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spi;

import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.spi.IBMCMSProvider;
import com.ibm.spi.IBMKeyStoreSpi;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Vector;

public class IBMKeyStore
extends KeyStore {
    private IBMKeyStoreSpi keyStoreSpi;
    private Provider provider;
    private String type;

    protected IBMKeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        super(keyStoreSpi, provider, string);
        this.keyStoreSpi = (IBMKeyStoreSpi)((Object)keyStoreSpi);
        this.provider = provider;
        this.type = string;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        if (IBMCMSProvider.isSupportedType(string)) {
            return new IBMKeyStore(IBMCMSProvider.getSpi(string), Security.getProvider("IBMCMS"), string);
        }
        return KeyStore.getInstance(string);
    }

    public final boolean isDefaultKeyEntry(String string) throws KeyStoreException {
        if (!this.keyStoreSpi.isInitialized()) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineIsDefaultKeyEntry(string);
    }

    public final String getDefaultKeyEntry() throws KeyStoreException {
        if (!this.keyStoreSpi.isInitialized()) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        return this.keyStoreSpi.engineGetDefaultKeyEntry();
    }

    public final void setDefaultKeyEntry(String string) throws KeyStoreException {
        if (!this.keyStoreSpi.isInitialized()) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineSetDefaultKeyEntry(string);
    }

    public final boolean isSiteCertificateEntry(String string) throws KeyStoreException {
        if (!this.keyStoreSpi.isInitialized()) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        if (!this.type.equals("SSLight")) {
            throw new KeyStoreException("Unsupported type:" + this.type);
        }
        return this.keyStoreSpi.engineIsSiteCertificateEntry(string);
    }

    public final void setSiteCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (!this.keyStoreSpi.isInitialized()) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        if (!this.type.equals("SSLight")) {
            throw new KeyStoreException("Unsupported type:" + this.type);
        }
        this.keyStoreSpi.engineSetSiteCertificateEntry(string, certificate);
    }

    public void load(String string, String string2) throws IOException {
        try {
            this.load((InputStream)null, (char[])null);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        this.keyStoreSpi.engineLoad(string, string2);
    }

    public final void loadFromClass(InputStream inputStream, char[] cArray) throws IOException, CertificateException, NoSuchAlgorithmException {
        this.load((InputStream)null, (char[])null);
        this.keyStoreSpi.engineLoadFromClass(inputStream, cArray);
    }

    public final void storeAsClass(OutputStream outputStream, char[] cArray, String string) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        if (!this.keyStoreSpi.isInitialized()) {
            throw new KeyStoreException("Uninitialized keystore");
        }
        this.keyStoreSpi.engineStoreAsClass(outputStream, cArray, string);
    }

    public final void loadCMS(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.load((InputStream)null, (char[])null);
        this.keyStoreSpi.engineLoadCMS(inputStream, inputStream2, inputStream3, cArray);
    }

    public final void storeCMS(OutputStream outputStream, OutputStream outputStream2, OutputStream outputStream3, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineStoreCMS(outputStream, outputStream2, outputStream3, cArray);
    }

    public final void setExpireTime(long l) throws KeyStoreException, NoSuchAlgorithmException {
        this.keyStoreSpi.engineSetExpireTime(l);
    }

    public final boolean isCertReqEntry(String string) {
        return this.keyStoreSpi.engineIsCertReqEntry(string);
    }

    public final void setCertReqEntry(String string, CertificationRequest certificationRequest, Key key) throws KeyStoreException {
        this.keyStoreSpi.engineSetCertReqEntry(string, certificationRequest, key);
    }

    public final CertificationRequest getCertReqEntry(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertReqEntry(string);
    }

    public final boolean isTrusted(String string) {
        return this.keyStoreSpi.engineIsTrusted(string);
    }

    public final void setTrusted(String string, boolean bl) {
        this.keyStoreSpi.engineSetTrusted(string, bl);
    }

    public final void stashKeydbPwd(OutputStream outputStream) throws IOException, NoSuchAlgorithmException {
        this.keyStoreSpi.engineStashKeydbPwd(outputStream);
    }

    public final void createNewSelfSignedCertificate(int n, String string, int n2, DNItem dNItem, int n3, int n4, Vector vector) throws KeyStoreException {
        this.keyStoreSpi.engineCreateNewSelfSignedCertificate(n, string, n2, dNItem, n3, n4, vector);
    }
}

