/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.asn1.ASN1OID;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.tools.KeyCertGen;
import com.ibm.cfwk.tools.cr.pkcs10.CertificationRequest;
import com.ibm.cfwk.tools.cr.pkcs10.CertificationRequestInfo;
import com.ibm.cfwk.tools.cr.pkcs10.SubjectPublicKeyInfo;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseManager;
import com.ibm.gsk.ikeyman.cli.CLIRequestInfo;
import com.ibm.gsk.ikeyman.ikeycmd;
import com.ibm.util.BitString;
import com.ibm.util.x500name.RDNAttribute;
import com.ibm.util.x500name.X500Name;
import java.util.Vector;

public class CLIRequestManager
implements CLIConstants {
    public static void create(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.dn.getCommonName();
        String string4 = cLIRequestInfo.dn.getOrgUnit();
        String string5 = cLIRequestInfo.dn.getOrg();
        String string6 = cLIRequestInfo.dn.getLocality();
        String string7 = cLIRequestInfo.dn.getState();
        String string8 = cLIRequestInfo.dn.getZipCode();
        String string9 = cLIRequestInfo.dn.getCountry();
        String string10 = cLIRequestInfo.dn.getEmail();
        Vector vector = cLIRequestInfo.dn.getOptions();
        DNItem dNItem = new DNItem(string3, string4, string5, string6, string7, string8, string9, string10);
        int n2 = cLIRequestInfo.getKeySize();
        String string11 = cLIRequestInfo.getLabel();
        String string12 = cLIRequestInfo.getFileName();
        boolean bl = true;
        keyDatabase.getKeyDatabaseOperator().open();
        ikeycmd.debugMsg("calling createNewCertRequest with parms: \nlabel: " + string11 + "\nkeySize: " + n2 + "\ncertFileName: " + string12 + "\nisNewKeyPair : " + bl);
        ikeycmd.debugMsg("\n");
        keyDatabase.getKeyDatabaseOperator().createNewCertRequest(string11, n2, dNItem, string12, bl);
        ikeycmd.debugMsg("returned from createNewCertReq ok");
        ikeycmd.debugMsg("\n");
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void recreate(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.getLabel();
        String string4 = cLIRequestInfo.getFileName();
        keyDatabase.getKeyDatabaseOperator().open();
        keyDatabase.getKeyDatabaseOperator().extractCertificateRequest(string3, string4);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void list(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        keyDatabase.getKeyDatabaseOperator().open();
        Vector vector = keyDatabase.getReqKeyLabelList();
        if (vector == null || vector.size() == 0) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_LIST_MSG") + " " + string);
        int n2 = 0;
        while (n2 < vector.size()) {
            String string3 = (String)vector.elementAt(n2);
            System.out.println(string3);
            ++n2;
        }
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void moreDetails(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        String string = "  ";
        String string2 = "    ";
        String string3 = "      ";
        String string4 = "        ";
        cLIRequestInfo.init();
        String string5 = cLIRequestInfo.cliDb.getName();
        String string6 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIRequestManager: moreDetails()");
        ikeycmd.debugMsg("KeyDbFileName: " + string5);
        ikeycmd.debugMsg("keyDbPassword: " + string6);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string5, string6, l);
        String string7 = cLIRequestInfo.getLabel();
        KeyItem keyItem = null;
        keyDatabase.getKeyDatabaseOperator().open();
        keyItem = keyDatabase.getKeyDatabaseOperator().getKeyItemByLabel(string7);
        if (keyItem == null) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        System.out.println("\n\n");
        System.out.println(ikeycmd.getNLSResString("GUI_LABEL_KEY_LABEL_COLON") + " " + string7);
        System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_CERTREQ_INFO"));
        System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " 00");
        CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
        byte[] byArray = certificateRequestItem.getEncoded();
        CertificationRequest certificationRequest = null;
        try {
            certificationRequest = KeyCertGen.generateCertificationRequest((byte[])byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (certificationRequest != null) {
            String string8;
            Object object;
            Object object2;
            Object object3;
            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT"));
            CertificationRequestInfo certificationRequestInfo = certificationRequest.certificationRequestInfo;
            X500Name x500Name = certificationRequestInfo.subject;
            RDNAttribute[][] rDNAttributeArray = x500Name.attributes();
            if (rDNAttributeArray != null) {
                int n2 = 0;
                while (n2 < rDNAttributeArray.length) {
                    int n3 = 0;
                    while (n3 < rDNAttributeArray[n2].length) {
                        object3 = rDNAttributeArray[n2][n3].keyToASN1OID();
                        object2 = object3.toString();
                        object = rDNAttributeArray[n2][n3].valueToString();
                        string8 = CLIRequestManager.getAttributeName(object3);
                        System.out.println(string3 + string8);
                        System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object2);
                        System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + (String)object);
                        ++n3;
                    }
                    ++n2;
                }
            }
            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"));
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificationRequestInfo.subjectPublicKeyInfo;
            AlgId algId = subjectPublicKeyInfo.algorithm;
            object3 = null;
            object2 = subjectPublicKeyInfo.subjectPublicKey;
            object3 = CLIRequestManager.getByteArrayFrom(object2);
            if (algId != null) {
                object = algId.asn1oid();
                if (object != null && (string8 = object.toString()) != null && string8.length() > 0) {
                    System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string8);
                }
                switch (algId.parameterStatus()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                        break;
                    }
                    case 2: {
                        string8 = algId.toString();
                        System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string8);
                        break;
                    }
                }
            }
            if (object3 != null && ((ASN1OID)object3).length > 0) {
                object = CLIRequestManager.getHexDumpForMoreDetails((byte[])object3);
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY") + ":\n" + string3 + (String)object);
            }
            if ((object = certificationRequestInfo.attributes) != null) {
                // empty if block
            }
            string8 = certificationRequest.signatureAlgorithm;
            byte[] byArray2 = CLIRequestManager.getByteArrayFrom(certificationRequest.signature);
            System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_SIG_ALG"));
            if (string8 != null) {
                String string9;
                ASN1OID aSN1OID = string8.asn1oid();
                if (aSN1OID != null && (string9 = aSN1OID.toString()) != null && string9.length() > 0) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string9);
                }
                switch (string8.parameterStatus()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                        break;
                    }
                    case 2: {
                        string9 = string8.toString();
                        System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string9);
                        break;
                    }
                }
            }
            if (byArray2 != null) {
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SIG_VALUE") + ":\n" + string3 + CLIRequestManager.getHexDumpForMoreDetails(byArray2));
            }
            System.out.println("\n");
        }
        keyDatabase.getKeyDatabaseOperator().close();
    }

    private static String getAttributeName(ASN1OID aSN1OID) {
        String string = null;
        if (aSN1OID != null) {
            string = aSN1OID.equals((Object)X500Name.COMMON_NAME) ? ikeycmd.getNLSResString("GUI_LABEL_COMMON_NAME") : (aSN1OID.equals((Object)X500Name.SERIAL_NUMBER) ? ikeycmd.getNLSResString("GUI_LABEL_SERIALNO") : (aSN1OID.equals((Object)X500Name.COUNTRY) ? ikeycmd.getNLSResString("GUI_LABEL_COUNTRY") : (aSN1OID.equals((Object)X500Name.LOCATION) ? ikeycmd.getNLSResString("GUI_LABEL_LOCALITY") : (aSN1OID.equals((Object)X500Name.STATE) ? ikeycmd.getNLSResString("GUI_LABEL_STATE") : (aSN1OID.equals((Object)X500Name.STREET) ? ikeycmd.getNLSResString("GUI_LABEL_STREET") : (aSN1OID.equals((Object)X500Name.ORGANIZATION) ? ikeycmd.getNLSResString("GUI_LABEL_ORG") : (aSN1OID.equals((Object)X500Name.ORGANIZATIONAL_UNIT) ? ikeycmd.getNLSResString("GUI_LABEL_ORG_UNIT") : (aSN1OID.equals((Object)X500Name.TITLE) ? ikeycmd.getNLSResString("GUI_LABEL_TITLE2") : (aSN1OID.equals((Object)X500Name.ZIP) ? ikeycmd.getNLSResString("GUI_LABEL_ZIPCODE") : (aSN1OID.equals((Object)X500Name.EMAIL) ? ikeycmd.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : aSN1OID.toString()))))))))));
        }
        return string;
    }

    private static String getHexDumpForMoreDetails(byte[] byArray) {
        String string = new String("");
        String string2 = "      ";
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n" + string2;
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    private static byte[] getByteArrayFrom(BitString bitString) {
        int n;
        byte[] byArray = null;
        if (bitString != null && (n = bitString.length()) > 0) {
            int n2 = n / 8;
            if (n % 8 != 0) {
                ++n2;
            }
            byArray = new byte[n2];
            bitString.writeTo(byArray, 0, true);
        }
        return byArray;
    }

    public static void details(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        String string;
        String string2;
        cLIRequestInfo.init();
        String string3 = cLIRequestInfo.cliDb.getName();
        String string4 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string3);
        ikeycmd.debugMsg("keyDbPassword: " + string4);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string3, string4, l);
        String string5 = cLIRequestInfo.getLabel();
        KeyItem keyItem = null;
        keyDatabase.getKeyDatabaseOperator().open();
        keyItem = keyDatabase.getKeyDatabaseOperator().getKeyItemByLabel(string5);
        if (keyItem == null) {
            throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
        System.out.println("\n\n");
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_LABEL") + " " + string5);
        short s = certificateRequestItem.getKeySize();
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_KEYSIZE") + " " + s);
        DNItem dNItem = certificateRequestItem.getSubject();
        if (dNItem != null) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_SUBJECT") + " " + dNItem.toStringWithoutTag());
        }
        if ((string2 = certificateRequestItem.getFingerPrint()) != null) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_FINGER") + " " + string2);
        }
        if ((string = certificateRequestItem.getSigAlgorithmIdOID()) != null) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_SIG") + " " + string);
        }
        System.out.println("\n\n");
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void extract(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.getLabel();
        String string4 = cLIRequestInfo.getExtractTarget();
        ikeycmd.debugMsg("Calling extractCertificateRequest(" + string3 + ", " + string4 + ")\n");
        keyDatabase.getKeyDatabaseOperator().open();
        keyDatabase.getKeyDatabaseOperator().extractCertificateRequest(string3, string4);
        keyDatabase.getKeyDatabaseOperator().close();
    }

    public static void delete(CLIRequestInfo cLIRequestInfo) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("KeyDbFileName: " + string);
        ikeycmd.debugMsg("keyDbPassword: " + string2);
        ikeycmd.debugMsg("keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyDatabase keyDatabase = CLIDatabaseManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.getLabel();
        ikeycmd.debugMsg("Deleteing label " + string3 + "\n");
        keyDatabase.getKeyDatabaseOperator().open();
        keyDatabase.getKeyDatabaseOperator().deleteKeyByLabel(string3);
        keyDatabase.getKeyDatabaseOperator().close();
    }
}

