/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public class PKCS7CertDialog
extends JDialog
implements ActionListener {
    private KeyInfoPanel keyInfoPanel;
    private KMButton okButton;
    private DateFormat dateFmt;
    private String newLabel = null;
    private boolean reuse = false;
    private boolean propertyChanged = false;

    public PKCS7CertDialog(JFrame jFrame, String string) {
        this(jFrame, string, true, (CertificateItem)null);
    }

    public PKCS7CertDialog(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, bl, (CertificateItem)null);
    }

    public PKCS7CertDialog(JFrame jFrame, String string, CertificateItem certificateItem) {
        this(jFrame, string, true, certificateItem);
    }

    public PKCS7CertDialog(JFrame jFrame, String string, boolean bl, CertificateItem certificateItem) {
        super(jFrame, string, true);
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("In PKCS7CertDialog,start to create..");
        }
        this.reuse = bl;
        this.dateFmt = DateFormat.getDateInstance(1, this.getLocale());
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("In PKCS7CertDialog,dateFmt=" + this.dateFmt);
        }
        this.keyInfoPanel = new KeyInfoPanel(certificateItem);
        JPanel jPanel = new JPanel();
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        jPanel.add(this.okButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.keyInfoPanel, "Center");
        container.add((Component)jPanel, "South");
        this.addWindowListener(new DiagAdapter());
        if (!bl) {
            this.setDefaultCloseOperation(2);
        }
        this.pack();
        this.setResizable(false);
        this.keyInfoPanel.inputField.requestFocus();
    }

    public void reduceFontSize() {
        this.setResizable(true);
        this.reduceFontSize(this.keyInfoPanel);
        this.keyInfoPanel.validate();
        this.keyInfoPanel.repaint();
        this.pack();
        this.setResizable(false);
    }

    public void reduceFontSize(Container container) {
        Font font = container.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        container.setFont(font2);
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("In PKCS7CertDialog, comp:" + container + ", f=" + font + ", nf=" + font2);
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.reduceFontSize((Container)componentArray[n]);
            } else {
                font = componentArray[n].getFont();
                font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                componentArray[n].setFont(font2);
                if (Ikeyman.printDebugMsg) {
                    Ikeyman.debugMsg("DEBUG......comps:" + container + ", f=" + font + ", nf=" + font2);
                }
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (Ikeyman.printDebugMsg) {
            Ikeyman.debugMsg("DEBUG......actionPerformed, source=" + object + ", arg=" + string);
        }
        if (string.equals("OK")) {
            this.newLabel = this.keyInfoPanel.inputField.getText();
            if (this.newLabel.equals("")) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_LABEL_NULL"));
                this.keyInfoPanel.inputField.setText("");
                this.keyInfoPanel.inputField.requestFocus();
            } else {
                this.dispose();
            }
        }
    }

    public boolean isPropertyChanged() {
        return this.propertyChanged;
    }

    public void displayCertItem(CertificateItem certificateItem) {
        this.keyInfoPanel.populateLabelsWithCertItem(certificateItem);
        this.keyInfoPanel.validate();
        this.pack();
        this.okButton.requestFocus();
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public DateFormat getDateFormat() {
        return this.dateFmt;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFmt = dateFormat;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            PKCS7CertDialog.this.propertyChanged = false;
            ((Component)PKCS7CertDialog.this).setVisible(false);
        }
    }

    class CheckBoxItemListener
    implements ItemListener {
        CheckBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getItem();
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("CheckboxItemListener is called, obj=" + object);
            }
            PKCS7CertDialog.this.propertyChanged = !PKCS7CertDialog.this.propertyChanged;
        }
    }

    class KeyInfoPanel
    extends JPanel {
        JLabel titleLabel = new JLabel("Information for the currently selected key");
        JLabel keySizeLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_KEY_SIZE") + ":");
        JLabel certLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_PROPERTY"));
        JLabel versionLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VERSION"));
        JLabel serialNoLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_SERIALNO"));
        JLabel subjectLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_ISSUED_TO"));
        JLabel issuerLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_ISSUED_BY"));
        JLabel validityLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_VALIDITY"));
        JLabel sigNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_CERT_SIG_ALG"));
        JLabel keyLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_RENAME_KEY_LABEL"));
        JLabel keySizeValue = new JLabel("");
        JLabel versionValue = new JLabel("");
        JLabel serialNoValue = new JLabel("");
        JTextArea issuerValue = new JTextArea(4, 30);
        JTextArea subjectValue = new JTextArea(4, 30);
        JLabel validityValue = new JLabel("");
        JTextField inputField = new JTextField(30);
        JLabel sigNameValue = new JLabel("");

        public KeyInfoPanel() {
            this(null);
        }

        public KeyInfoPanel(CertificateItem certificateItem) {
            super(true);
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("In PKCS7CertDialog..KeyInfoPanel,");
            }
            if (certificateItem != null) {
                this.populateLabelsWithCertItem(certificateItem);
            }
            if (Ikeyman.printDebugMsg) {
                Ikeyman.debugMsg("In PKCS7CertDialog..KeyInfoPanel,call after populateLabelsWithCertItem");
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new SoftBevelBorder(1));
            jPanel.setBorder(compoundBorder);
            Font font = new Font(Ikeyman.defaultFont.getName(), 0, Ikeyman.defaultFont.getSize() + 2);
            this.titleLabel.setFont(font);
            this.titleLabel.setHorizontalAlignment(0);
            jPanel.add((Component)this.titleLabel, "Center");
            JSeparator jSeparator = new JSeparator();
            this.inputField.requestFocus();
            InfoPane infoPane = new InfoPane(certificateItem);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)infoPane, "Center");
            CompoundBorder compoundBorder2 = new CompoundBorder(new EtchedBorder(), new SoftBevelBorder(1));
            jPanel2.setBorder(compoundBorder2);
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            JSeparator jSeparator2 = new JSeparator();
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout(10, 20));
            jPanel3.add((Component)jSeparator, "North");
            jPanel3.add((Component)jScrollPane, "Center");
            jPanel3.add((Component)jSeparator2, "South");
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel3, "Center");
        }

        public void populateLabelsWithCertItem(CertificateItem certificateItem) {
            Object[] objectArray;
            Object object;
            Object object2;
            String string;
            if (certificateItem == null) {
                return;
            }
            if (certificateItem.getKeySize() != 0) {
                this.keySizeValue.setText("" + certificateItem.getKeySize());
            }
            if (certificateItem.getVersion() != 0) {
                this.versionValue.setText("X509 V" + certificateItem.getVersion());
            }
            if ((string = KMUtil.trimBlankSpace(certificateItem.getSerialNumber())) != null && string.length() % 2 == 0) {
                object2 = string.toUpperCase();
                object = ((String)object2).toCharArray();
                int n = ((char[])object).length / 2;
                objectArray = new char[n * 3 - 1];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[3 * n2] = object[2 * n2];
                    objectArray[3 * n2 + 1] = object[2 * n2 + 1];
                    if (n2 != n - 1) {
                        objectArray[3 * n2 + 2] = 58;
                    }
                    ++n2;
                }
                this.serialNoValue.setText(new String((char[])objectArray));
            } else {
                this.serialNoValue.setText("  ");
            }
            if (certificateItem.getIssuer().toStringWithoutTag() != null) {
                this.issuerValue.setText(certificateItem.getIssuer().toStringWithoutTag());
            }
            if (certificateItem.getSubject().toStringWithoutTag() != null) {
                this.subjectValue.setText(certificateItem.getSubject().toStringWithoutTag());
            }
            this.issuerValue.setEditable(false);
            this.subjectValue.setEditable(false);
            object2 = certificateItem.getValidNotBefore();
            object = certificateItem.getValidNotAfter();
            if (object != null) {
                String string2 = Ikeyman.getNLSResString("GUI_LABEL_CERT_VALIDITY_FORMAT");
                objectArray = new Object[]{PKCS7CertDialog.this.dateFmt.format((Date)object2), PKCS7CertDialog.this.dateFmt.format((Date)object)};
                String string3 = MessageFormat.format(string2, objectArray);
                this.validityValue.setText(string3);
                this.sigNameValue.setText(certificateItem.getSigAlgorithmIdOIDName() + "(" + certificateItem.getSigAlgorithmIdOID() + ")");
            }
        }

        class InfoPane
        extends JPanel {
            public InfoPane(CertificateItem certificateItem) {
                super(true);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.keySizeLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.keySizeLabel);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.keySizeValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.keySizeValue);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.certLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.certLabel);
                if (certificateItem != null) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.versionLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.versionLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.versionValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.versionValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.serialNoLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.serialNoLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.serialNoValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.serialNoValue);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.subjectLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.subjectLabel);
                gridBagConstraints.gridheight = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = new Insets(0, 25, 2, 5);
                gridBagLayout.setConstraints(KeyInfoPanel.this.subjectValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.subjectValue);
                if (certificateItem != null) {
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridheight = 1;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.issuerLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.issuerLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridheight = 2;
                    gridBagConstraints.insets = new Insets(0, 25, 2, 5);
                    gridBagLayout.setConstraints(KeyInfoPanel.this.issuerValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.issuerValue);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.validityLabel, gridBagConstraints);
                    this.add(KeyInfoPanel.this.validityLabel);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                    gridBagConstraints.gridwidth = 0;
                    gridBagLayout.setConstraints(KeyInfoPanel.this.validityValue, gridBagConstraints);
                    this.add(KeyInfoPanel.this.validityValue);
                }
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagConstraints.gridwidth = 1;
                gridBagLayout.setConstraints(KeyInfoPanel.this.sigNameLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.sigNameLabel);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 5, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.sigNameValue, gridBagConstraints);
                this.add(KeyInfoPanel.this.sigNameValue);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 15, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.keyLabel, gridBagConstraints);
                this.add(KeyInfoPanel.this.keyLabel);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(2, 25, 0, 5);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(KeyInfoPanel.this.inputField, gridBagConstraints);
                this.add(KeyInfoPanel.this.inputField);
            }
        }
    }
}

