/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LoadMonitor
extends Thread {
    public static int INITIAL_WIDTH = 400;
    public static int INITIAL_HEIGHT = 200;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private int currentProgressValue = 0;
    private boolean isStopped = false;
    private boolean isCompleted = false;
    private JFrame frame = new JFrame();
    private boolean isFrameShowing = false;

    public LoadMonitor(String string, String string2) {
        this.frame.addWindowListener(new LoadMonitorWindowAdapter());
        if (string != null) {
            this.frame.setTitle(string);
        }
        this.setIconImage(this.getClass(), "images/ikeyman.gif");
        JOptionPane.setRootFrame(this.frame);
        WideInsetsPanel wideInsetsPanel = new WideInsetsPanel();
        wideInsetsPanel.setLayout(new BoxLayout(wideInsetsPanel, 1));
        this.frame.getContentPane().add((Component)wideInsetsPanel, "Center");
        Dimension dimension = new Dimension(400, 20);
        this.progressLabel = new JLabel(string2);
        this.progressLabel.setAlignmentX(0.5f);
        this.progressLabel.setMaximumSize(dimension);
        this.progressLabel.setPreferredSize(dimension);
        wideInsetsPanel.add(this.progressLabel);
        wideInsetsPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        this.progressBar = new JProgressBar();
        this.progressLabel.setLabelFor(this.progressBar);
        this.progressBar.setAlignmentX(0.5f);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(30);
        this.progressBar.setValue(0);
        wideInsetsPanel.add(this.progressBar);
        if (string2 != null) {
            this.moveForward(null);
        }
        ((Component)this.frame).setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this.frame).setLocation(dimension2.width / 2 - INITIAL_WIDTH / 2, dimension2.height / 2 - INITIAL_HEIGHT / 2);
        ((Component)this.frame).setVisible(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.isFrameShowing = true;
    }

    public void setIconImage(Class clazz, String string) {
        try {
            Image image = KMAWTUtil.makeImage(clazz, string);
            MediaTracker mediaTracker = new MediaTracker(this.frame);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ((Frame)this.frame).setIconImage(image);
        }
        catch (AWTError aWTError) {
            aWTError.printStackTrace();
        }
    }

    public void run() {
        this.isStopped = false;
        String string = null;
        long l = 0L;
        while (!this.isFrameShowing) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                this.isFrameShowing = true;
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            this.isFrameShowing = true;
        }
        do {
            if ((string = KMSystem.getVerboseMsg()) != null) {
                this.moveForward(string);
                l = 1L;
            } else {
                ++l;
                l %= 100L;
            }
            try {
                Thread.sleep(l * 10L);
            }
            catch (InterruptedException interruptedException) {
                this.isStopped = true;
            }
        } while (!this.isStopped);
        this.complete();
        this.isCompleted = true;
    }

    public void stopLoop() {
        this.isStopped = true;
        KMSystem.setMsgQueueEnabled(false);
    }

    public void complete() {
        if (!this.isCompleted) {
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.frame.dispose();
        }
    }

    public synchronized void moveForward(String string) {
        if (string != null) {
            this.progressLabel.setText(string);
        }
        this.progressBar.setValue(++this.currentProgressValue);
    }

    class LoadMonitorWindowAdapter
    extends WindowAdapter {
        LoadMonitorWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Ikeyman.closeHelpFrame();
            Ikeyman.closeDebugDumpFile();
            System.exit(0);
        }
    }

    class WideInsetsPanel
    extends JPanel {
        public WideInsetsPanel() {
            super(true);
        }

        public Insets getInsets() {
            return new Insets(40, 30, 20, 30);
        }
    }
}

