/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.poa;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.poa.POACurrent;
import com.ibm.rmi.poa.POAImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public class POAManagerImpl
extends LocalObject
implements POAManager {
    private ORB orb;
    private State state = State.HOLDING;
    private Set poas = Collections.synchronizedSet(new HashSet());
    private int nInvocations = 0;
    private int nThreads = 0;
    private boolean beingDestroyed = false;
    private static Set poaManagers = Collections.synchronizedSet(new HashSet());
    private static final String[] _type_ids = new String[]{"IDL:omg.org/PortableServer/POAManager:1.0"};

    public POAManagerImpl(ORB oRB) {
        this.orb = oRB;
        poaManagers.add(this);
    }

    protected ORB getORB() {
        return this.orb;
    }

    public static void shutdown(ORB oRB, boolean bl) {
        Object[] objectArray = poaManagers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            POAManagerImpl pOAManagerImpl = (POAManagerImpl)((Object)objectArray[i]);
            if (pOAManagerImpl.getORB() != oRB) continue;
            try {
                pOAManagerImpl.deactivate(true, bl);
                continue;
            }
            catch (AdapterInactive adapterInactive) {
                if (!ORBRas.isTrcLogging) continue;
                ORBRas.orbTrcLogger.trace(4112L, (Object)pOAManagerImpl, "shutdown:111", adapterInactive.toString());
            }
        }
    }

    synchronized void addPOA(POA pOA) {
        if (this.state != State.INACTIVE) {
            this.poas.add(pOA);
        }
    }

    synchronized void removePOA(POA pOA) {
        this.poas.remove(pOA);
        try {
            this.discard_requests(false);
        }
        catch (AdapterInactive adapterInactive) {
            // empty catch block
        }
    }

    public synchronized void activate() throws AdapterInactive {
        if (this.state == State.INACTIVE) {
            throw new AdapterInactive();
        }
        this.state = State.ACTIVE;
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized State get_state() {
        return this.state;
    }

    public synchronized void hold_requests(boolean bl) throws AdapterInactive {
        if (this.state == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (bl && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER("wait_for_completion is TRUE and the current thread is in an invocation context dispatched from some POA belonging to the same ORB as this POA", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        this.state = State.HOLDING;
        ((Object)((Object)this)).notifyAll();
        if (bl) {
            ++this.nThreads;
            while (this.state == State.HOLDING && this.nInvocations > 0) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.nThreads;
        }
    }

    public synchronized void discard_requests(boolean bl) throws AdapterInactive {
        if (this.state == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (bl && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER("wait_for_completion is TRUE and the current thread is in an invocation context dispatched from some POA belonging to the same ORB as this POA", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        this.state = State.DISCARDING;
        ((Object)((Object)this)).notifyAll();
        if (bl) {
            ++this.nThreads;
            while (this.state == State.DISCARDING && this.nInvocations > 0) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.nThreads;
        }
    }

    public synchronized void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        if (this.state == State.INACTIVE && !this.beingDestroyed) {
            throw new AdapterInactive();
        }
        if (bl2 && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER("wait_for_completion is TRUE and the current thread is in an invocation context dispatched from some POA belonging to the same ORB as this POA", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        if (this.beingDestroyed) {
            if (bl2) {
                while (this.beingDestroyed) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return;
        }
        this.beingDestroyed = true;
        this.state = State.INACTIVE;
        ((Object)((Object)this)).notifyAll();
        if (bl2) {
            ++this.nThreads;
            while (this.nInvocations > 0) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.nThreads;
        }
        if (bl) {
            if (bl2) {
                this.etherealizePOAs();
                this.internalDeactivate();
            } else {
                Thread thread = new Thread(){

                    public void run() {
                        POAManagerImpl.this.etherealizePOAs();
                        POAManagerImpl.this.internalDeactivate();
                    }
                };
                thread.start();
            }
        } else {
            this.internalDeactivate();
        }
    }

    private synchronized void internalDeactivate() {
        poaManagers.remove((Object)this);
        this.poas.clear();
        this.beingDestroyed = false;
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void etherealizePOAs() {
        Set set = this.poas;
        synchronized (set) {
            Iterator iterator = this.poas.iterator();
            while (iterator.hasNext()) {
                POAImpl pOAImpl = (POAImpl)((Object)iterator.next());
                pOAImpl.etherealizeAll();
            }
        }
    }

    protected boolean isInInvocationContext() {
        POA[] pOAArray = null;
        POACurrent pOACurrent = null;
        POA pOA = null;
        try {
            pOACurrent = (POACurrent)this.orb.resolve_initial_references("POACurrent");
            pOA = (POA)this.orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName invalidName) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "isInInvocationContext:361", invalidName.toString());
            }
            return false;
        }
        try {
            pOAArray = pOACurrent.get_POA_stack();
        }
        catch (NoContext noContext) {
            return false;
        }
        for (int i = 0; i < pOAArray.length; ++i) {
            while (pOAArray[i].the_parent() != null) {
                pOAArray[i] = pOAArray[i].the_parent();
            }
            if (pOAArray[i] != pOA) continue;
            return true;
        }
        return false;
    }

    synchronized void enter() {
        while (this.state != State.ACTIVE) {
            switch (this.state.value()) {
                case 0: {
                    while (this.state == State.HOLDING) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
                case 2: {
                    throw new TRANSIENT(1330446337, CompletionStatus.COMPLETED_NO);
                }
                case 3: {
                    throw new OBJ_ADAPTER("This POA is in INACTIVE state", 1229126557, CompletionStatus.COMPLETED_NO);
                }
            }
        }
        ++this.nInvocations;
    }

    synchronized void exit() {
        --this.nInvocations;
        if (this.nThreads > 0 && this.nInvocations == 0) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public String[] _ids() {
        return (String[])_type_ids.clone();
    }
}

