/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba.DynamicAny;

import com.ibm.rmi.corba.AnyImpl;
import com.ibm.rmi.corba.DynamicAny.ComplexDynAnyImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynFixed;

public class DynFixedImpl
extends ComplexDynAnyImpl
implements DynFixed {
    private BigDecimal _value;
    private short _precision;
    private short _scale;

    protected DynFixedImpl(ORB oRB, TypeCode typeCode) {
        super(oRB, typeCode);
        try {
            this._precision = typeCode.fixed_digits();
            this._scale = typeCode.fixed_scale();
        }
        catch (BadKind badKind) {
            throw new BAD_PARAM("Wrong TypeCode type passed to DynFixedImpl constructor", 1229124116, CompletionStatus.COMPLETED_NO);
        }
        this._value = new BigDecimal("0").setScale(this._scale);
    }

    protected DynFixedImpl(ORB oRB, TypeCode typeCode, DynFixedImpl dynFixedImpl) {
        super(oRB, typeCode);
        if (dynFixedImpl != null) {
            try {
                this.set_value(dynFixedImpl.get_value());
            }
            catch (TypeMismatch typeMismatch) {
            }
            catch (InvalidValue invalidValue) {
                // empty catch block
            }
        } else {
            throw new BAD_PARAM("NULL_PARAM passed to DynFixedImpl constructor", 1229124116, CompletionStatus.COMPLETED_NO);
        }
        this._precision = dynFixedImpl._precision;
        this._scale = dynFixedImpl._scale;
    }

    public String get_value() {
        this.checkValid("DynFixedImpl.get_value()");
        return this._value.toString();
    }

    public boolean set_value(String string) throws TypeMismatch, InvalidValue {
        this.checkValid("DynFixedImpl.set_value()");
        if (string == null) {
            throw new InvalidValue("set_value() called with a null String argument");
        }
        String string2 = string.trim().toLowerCase();
        if (!Pattern.matches("^\\d*\\.?\\d*[d]?$", string2) || Pattern.matches("\\.[d]*$", string2)) {
            throw new TypeMismatch("set_value() passed an invalid fixed-point literal : " + string2);
        }
        if (string2.endsWith("d")) {
            string2 = string2.substring(0, string2.lastIndexOf("d"));
        }
        boolean bl = true;
        int n = string2.length();
        int n2 = string2.indexOf(46);
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        if (n2 > -1) {
            n3 = n - n2;
            --n4;
            if (n3 > this._scale) {
                n5 = n3 - this._scale;
                string2 = string2.substring(0, n - n5);
                n = string2.length();
                n4 -= n5;
                bl = false;
            }
        }
        if (n4 > this._precision) {
            throw new InvalidValue("set_value() argument exceeds precision of DynFixed");
        }
        this._value = new BigDecimal(string2);
        return bl;
    }

    public void assign(DynAny dynAny) throws TypeMismatch {
        this.checkValid("DynFixedImpl.assign()");
        if (dynAny == null) {
            throw new BAD_PARAM("NULL_PARAM assign()", 1229124116, CompletionStatus.COMPLETED_NO);
        }
        if (this == dynAny) {
            return;
        }
        if (!this._typeCode.equivalent(dynAny.type())) {
            throw new TypeMismatch("Wrong type of DynAny passed to assign()");
        }
        try {
            this.set_value(((DynFixed)dynAny).get_value());
        }
        catch (InvalidValue invalidValue) {
            // empty catch block
        }
    }

    public void from_any(Any any) throws TypeMismatch, InvalidValue {
        this.checkValid("DynFixedImpl.from_any()");
        if (any == null) {
            throw new BAD_PARAM("NULL_PARAM from_any()", 1229124116, CompletionStatus.COMPLETED_NO);
        }
        if (!this._typeCode.equivalent(any.type())) {
            throw new TypeMismatch("Wrong type of Any passed to from_any()");
        }
        this.set_value(any.extract_fixed().toString());
    }

    public Any to_any() {
        this.checkValid("DynFixedImpl.to_any()");
        AnyImpl anyImpl = new AnyImpl(this._orb);
        anyImpl.insert_fixed(this._value, this._typeCode);
        return anyImpl;
    }

    public boolean equal(DynAny dynAny) {
        this.checkValid("DynFixedImpl.equal()");
        if (dynAny == null) {
            throw new BAD_PARAM("NULL_PARAM equal()", 1229124116, CompletionStatus.COMPLETED_NO);
        }
        boolean bl = false;
        if (this._typeCode.equivalent(dynAny.type()) && this.get_value().equals(((DynFixed)dynAny).get_value())) {
            bl = true;
        }
        return bl;
    }

    public void destroy() {
        this.checkValid("DynFixedImpl.destroy()");
        if (this._parent == null) {
            this._valid = false;
        }
    }

    public DynAny copy() {
        this.checkValid("DynFixedImpl.copy()");
        return new DynFixedImpl(this._orb, this._typeCode, this);
    }

    void fromValue(java.lang.Object object, TypeCode typeCode) throws TypeMismatch {
        if (!this._typeCode.equivalent(typeCode)) {
            throw new TypeMismatch("Wrong type passed to fromValue()");
        }
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getDeclaredMethod("toString", new Class[0]);
            String string = (String)method.invoke(object, (java.lang.Object[])new Object[0]);
            this.set_value(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TypeMismatch("Wrong object type passed to fromValue()");
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InvalidValue invalidValue) {
            // empty catch block
        }
    }
}

