/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.PolicyNodeImpl;
import com.ibm.security.cert.PolicyTree;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.CertificatePolicyMap;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.PolicyMappingsExtension;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class PolicyChecker
extends PKIXCertPathChecker {
    private PolicyTree policyTree;
    private X509Certificate certificate;
    private boolean policyQualifiersRejected;
    private Set user_initial_policy_set;
    int inhibit_any_policy;
    private int explicit_policy;
    private int policy_mapping;
    private int currentCertIndex;
    private CertPath certPath;
    public static final ObjectIdentifier anyPolicy_OID;
    private int numberOfCertsInCertPath;
    static final String[] myExtensions;

    public PolicyChecker(CertPath certPath, boolean bl, Set set, int n, int n2, int n3) {
        this.certPath = certPath;
        this.policyQualifiersRejected = bl;
        this.user_initial_policy_set = set;
        this.explicit_policy = n;
        this.policy_mapping = n2;
        this.inhibit_any_policy = n3;
        this.policyTree = new PolicyTree();
        this.numberOfCertsInCertPath = this.certPath.getCertificates().size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        this.certificate = (X509Certificate)certificate;
        Vector vector = new Vector();
        CertificatePoliciesExtension certificatePoliciesExtension = (CertificatePoliciesExtension)CertPathUtil.getPolicyInformation(this.certificate, vector, this.policyQualifiersRejected);
        if (((Object)this.certificate.getIssuerDN()).equals(this.certificate.getSubjectDN())) {
            --this.currentCertIndex;
            --this.numberOfCertsInCertPath;
            return;
        }
        try {
            if (certificatePoliciesExtension == null || certificatePoliciesExtension.get("cert_policies") == null) {
                this.policyTree.setValid(false);
            } else {
                if (this.policyQualifiersRejected && certificatePoliciesExtension.isCritical()) {
                    throw new CertPathValidatorException("Reject the certificate", null, this.certPath, this.currentCertIndex);
                }
                if (this.policyTree.isValid()) {
                    this.checkPolicies(this.certificate, certificatePoliciesExtension, this.policyTree);
                }
            }
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Internal error occurs while checking certificate policies extension", (Throwable)iOException, this.certPath, this.currentCertIndex);
        }
        if (this.explicit_policy <= 0 && !this.policyTree.isValid()) {
            throw new CertPathValidatorException("Fail to pass policy check.", null, this.certPath, this.currentCertIndex);
        }
        if (this.currentCertIndex > 0) {
            int n;
            int[] nArray;
            PolicyMappingsExtension policyMappingsExtension = null;
            Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.PolicyMappings", this.certificate);
            if (objectArray[1] != null) {
                try {
                    policyMappingsExtension = new PolicyMappingsExtension((Boolean)objectArray[0], objectArray[1]);
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("An internal error has occurred.", (Throwable)iOException, this.certPath, this.currentCertIndex);
                }
            }
            if (policyMappingsExtension != null) {
                this.checkPolicyMappings(this.certificate, policyMappingsExtension, this.policyTree);
            }
            if (this.explicit_policy != 0) {
                --this.explicit_policy;
            }
            if (this.policy_mapping != 0) {
                --this.policy_mapping;
            }
            if (this.inhibit_any_policy != 0) {
                --this.inhibit_any_policy;
            }
            if ((nArray = CertPathUtil.getPolicyConstraints(this.certificate)) != null) {
                if (nArray[0] < this.explicit_policy) {
                    this.explicit_policy = nArray[0];
                }
                if (nArray[1] < this.policy_mapping) {
                    this.policy_mapping = nArray[1];
                }
            }
            if ((n = CertPathUtil.getInhibitAnyPolicy(this.certificate)) < this.inhibit_any_policy) {
                this.inhibit_any_policy = n;
            }
        }
        CertPathUtil.removeExtensions(collection, myExtensions);
        if (this.currentCertIndex == 0) {
            this.policyTree = this.wrapUp(this.certificate);
        }
        --this.currentCertIndex;
    }

    private void checkPolicies(X509Certificate x509Certificate, CertificatePoliciesExtension certificatePoliciesExtension, PolicyTree policyTree) throws CertPathValidatorException {
        ObjectIdentifier objectIdentifier;
        Object object;
        int n;
        Vector vector;
        ObjectIdentifier objectIdentifier2;
        PolicyInformation policyInformation;
        int n2;
        boolean bl = certificatePoliciesExtension.isCritical();
        Vector vector2 = null;
        try {
            vector2 = (Vector)certificatePoliciesExtension.get("cert_policies");
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Fail to pass policy check", (Throwable)iOException, this.certPath, this.currentCertIndex);
        }
        ArrayList arrayList = null;
        arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex - 1);
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            PolicyNodeImpl policyNodeImpl;
            int n3;
            policyInformation = (PolicyInformation)vector2.elementAt(n2);
            objectIdentifier2 = null;
            try {
                objectIdentifier2 = policyInformation.getPolicyIdentifier();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)iOException, this.certPath, this.currentCertIndex);
            }
            if (objectIdentifier2.equals(anyPolicy_OID)) continue;
            vector = policyInformation.getPolicyQualifiers();
            if (vector == null) {
                vector = new Vector();
            }
            n = 0;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                object = (PolicyNodeImpl)arrayList.get(n3);
                if (!((PolicyNodeImpl)object).match(objectIdentifier2)) continue;
                n = 1;
                objectIdentifier = new HashSet();
                objectIdentifier.add(objectIdentifier2.toString());
                policyNodeImpl = new PolicyNodeImpl(objectIdentifier2, new HashSet(vector), bl, (Set)objectIdentifier, (PolicyNode)object);
                ((PolicyNodeImpl)object).addChild(policyNodeImpl);
                policyTree.addNode(policyNodeImpl);
            }
            if (n != 0) continue;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                object = (PolicyNodeImpl)arrayList.get(n3);
                if (!((PolicyNodeImpl)object).getValidPolicy().equals(anyPolicy_OID.toString())) continue;
                objectIdentifier = new HashSet();
                objectIdentifier.add(objectIdentifier2.toString());
                policyNodeImpl = new PolicyNodeImpl(objectIdentifier2, new HashSet(vector), bl, (Set)objectIdentifier, (PolicyNode)object);
                ((PolicyNodeImpl)object).addChild(policyNodeImpl);
                policyTree.addNode(policyNodeImpl);
            }
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            policyInformation = (PolicyInformation)vector2.elementAt(n2);
            objectIdentifier2 = null;
            try {
                objectIdentifier2 = policyInformation.getPolicyIdentifier();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)iOException, this.certPath, this.currentCertIndex);
            }
            if (!objectIdentifier2.equals(anyPolicy_OID) || CertPathUtil.getInhibitAnyPolicy(x509Certificate) <= 0) continue;
            vector = policyInformation.getPolicyQualifiers();
            if (vector == null) {
                vector = new Vector();
            }
            for (n = 0; n < arrayList.size(); ++n) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)arrayList.get(n);
                object = policyNodeImpl.getExpectedPolicies().iterator();
                while (object.hasNext()) {
                    PolicyNodeImpl policyNodeImpl2;
                    objectIdentifier = null;
                    try {
                        objectIdentifier = new ObjectIdentifier((String)object.next());
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    boolean bl2 = false;
                    Object object2 = policyNodeImpl.getChildren();
                    while (object2.hasNext()) {
                        policyNodeImpl2 = (PolicyNodeImpl)object2.next();
                        if (!policyNodeImpl2.match(objectIdentifier)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    object2 = new HashSet();
                    object2.add(objectIdentifier.toString());
                    policyNodeImpl2 = new PolicyNodeImpl(objectIdentifier, new HashSet(vector), bl, (Set)object2, policyNodeImpl);
                    policyNodeImpl.addChild(policyNodeImpl2);
                    policyTree.addNode(policyNodeImpl2);
                }
            }
        }
        ArrayList arrayList2 = null;
        for (int i = this.numberOfCertsInCertPath - this.currentCertIndex - 1; i > 0; --i) {
            arrayList2 = policyTree.getNodes(i);
            int n4 = arrayList2.size();
            for (int j = 0; j < n4; ++j) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)arrayList2.get(j);
                Iterator iterator = policyNodeImpl.getChildren();
                if (iterator.hasNext()) continue;
                object = (PolicyNodeImpl)((PolicyNodeImpl)arrayList2.get(j)).getParent();
                if (object != null) {
                    ((PolicyNodeImpl)object).removeChild(policyNodeImpl);
                    policyTree.remove(policyNodeImpl);
                    --j;
                    --n4;
                    continue;
                }
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
            }
        }
        if (policyTree.getNodes(1) == null) {
            policyTree.setValid(false);
        }
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported.", null, this.certPath, this.currentCertIndex);
        }
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32");
        return hashSet;
    }

    public Object clone() {
        return super.clone();
    }

    public PolicyTree getPolicyTree() {
        return this.policyTree;
    }

    private void checkPolicyMappings(X509Certificate x509Certificate, PolicyMappingsExtension policyMappingsExtension, PolicyTree policyTree) throws CertPathValidatorException {
        Vector vector = null;
        try {
            vector = (Vector)policyMappingsExtension.get("map");
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("An internal error has occurred.", (Throwable)iOException, this.certPath, this.currentCertIndex);
        }
        block6: for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Iterator iterator;
            Object object2;
            int n;
            ArrayList arrayList;
            CertificatePolicyMap certificatePolicyMap = (CertificatePolicyMap)vector.get(i);
            ObjectIdentifier objectIdentifier = certificatePolicyMap.getIssuerIdentifier().getIdentifier();
            ObjectIdentifier objectIdentifier2 = certificatePolicyMap.getSubjectIdentifier().getIdentifier();
            if (objectIdentifier.equals(anyPolicy_OID) || objectIdentifier2.equals(anyPolicy_OID)) {
                throw new CertPathValidatorException("Error in policy mapping extension", null, this.certPath, this.currentCertIndex);
            }
            if (this.policy_mapping > 0) {
                PolicyNodeImpl policyNodeImpl;
                int n2;
                arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex);
                n = 0;
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    policyNodeImpl = (PolicyNodeImpl)arrayList.get(n2);
                    if (!policyNodeImpl.getValidPolicy().equals(objectIdentifier.toString())) continue;
                    n = 1;
                    object2 = new HashSet<String>();
                    ((HashSet)object2).add(objectIdentifier2.toString());
                    policyNodeImpl.setExpectedPolicySet((Set)object2);
                }
                if (n != 0) continue;
                arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex - 1);
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    policyNodeImpl = (PolicyNodeImpl)arrayList.get(n2);
                    if (!policyNodeImpl.getValidPolicy().equals(anyPolicy_OID)) continue;
                    object2 = new Vector();
                    iterator = (CertificatePoliciesExtension)CertPathUtil.getPolicyInformation(x509Certificate, object2, this.policyQualifiersRejected);
                    object = null;
                    try {
                        object = (Vector)iterator.get("cert_policies");
                    }
                    catch (IOException iOException) {
                        throw new CertPathValidatorException("An internal error has occurred.", (Throwable)iOException, this.certPath, this.currentCertIndex);
                    }
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        PolicyInformation policyInformation = (PolicyInformation)((Vector)object).get(j);
                        try {
                            if (!policyInformation.getPolicyIdentifier().equals(anyPolicy_OID)) continue;
                            HashSet<String> hashSet = new HashSet<String>();
                            hashSet.add(certificatePolicyMap.getSubjectIdentifier().getIdentifier().toString());
                            PolicyNodeImpl policyNodeImpl2 = new PolicyNodeImpl(objectIdentifier, new HashSet(policyInformation.getPolicyQualifiers()), policyMappingsExtension.isCritical(), hashSet, policyNodeImpl);
                            policyNodeImpl.addChild(policyNodeImpl2);
                            policyTree.addNode(policyNodeImpl2);
                            continue block6;
                        }
                        catch (IOException iOException) {
                            throw new CertPathValidatorException("An internal error has occured.", (Throwable)iOException, this.certPath, this.currentCertIndex);
                        }
                    }
                    continue block6;
                }
                continue;
            }
            if (this.policy_mapping != 0) continue;
            arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex);
            for (n = 0; n < arrayList.size(); ++n) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)arrayList.get(n);
                if (!policyNodeImpl.getValidPolicy().equals(objectIdentifier.toString())) continue;
                ((PolicyNodeImpl)policyNodeImpl.getParent()).removeChild(policyNodeImpl);
                policyTree.remove(policyNodeImpl);
            }
            for (n = this.numberOfCertsInCertPath - this.currentCertIndex - 1; n > 0; --n) {
                arrayList = policyTree.getNodes(n);
                int n3 = arrayList.size();
                for (int j = 0; j < n3; ++j) {
                    object2 = (PolicyNodeImpl)arrayList.get(j);
                    iterator = ((PolicyNodeImpl)object2).getChildren();
                    if (iterator.hasNext()) continue;
                    object = (PolicyNodeImpl)((PolicyNodeImpl)arrayList.get(j)).getParent();
                    if (object != null) {
                        ((PolicyNodeImpl)object).removeChild((PolicyNode)object2);
                        policyTree.remove((PolicyNode)object2);
                        --j;
                        --n3;
                        continue;
                    }
                    throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                }
            }
        }
    }

    private PolicyTree wrapUp(X509Certificate x509Certificate) throws CertPathValidatorException {
        int[] nArray;
        if (!((Object)this.certificate.getIssuerDN()).equals(this.certificate.getSubjectDN()) && this.explicit_policy != 0) {
            --this.explicit_policy;
        }
        if ((nArray = CertPathUtil.getPolicyConstraints(this.certificate)) != null && nArray[0] == 0) {
            this.explicit_policy = 0;
        }
        if (this.policyTree.isValid()) {
            Object object;
            if (this.user_initial_policy_set.size() == 1 && this.user_initial_policy_set.contains(anyPolicy_OID.toString())) {
                return this.policyTree;
            }
            ArrayList<PolicyNodeImpl> arrayList = new ArrayList<PolicyNodeImpl>();
            PolicyNodeImpl policyNodeImpl = null;
            ArrayList arrayList2 = null;
            for (int i = this.policyTree.getDepth(); i > 0; --i) {
                arrayList2 = this.policyTree.getNodes(i);
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    policyNodeImpl = (PolicyNodeImpl)object.next();
                    if (!policyNodeImpl.getParent().getValidPolicy().equals(anyPolicy_OID.toString())) continue;
                    arrayList.add(policyNodeImpl);
                }
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                policyNodeImpl = (PolicyNodeImpl)iterator.next();
                object = policyNodeImpl.getValidPolicy();
                if (this.user_initial_policy_set.contains(object) || ((String)object).equals(anyPolicy_OID.toString())) continue;
                Iterator iterator2 = policyNodeImpl.getChildren();
                while (iterator2.hasNext()) {
                    PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)iterator2.next();
                    this.deleteChild(this.policyTree, policyNodeImpl2);
                }
                ((PolicyNodeImpl)policyNodeImpl.getParent()).removeChild(policyNodeImpl);
                this.policyTree.remove(policyNodeImpl);
            }
            object = null;
            for (int i = this.numberOfCertsInCertPath - 1; i > 0; --i) {
                object = this.policyTree.getNodes(i);
                if (object == null) continue;
                int n = ((ArrayList)object).size();
                for (int j = 0; j < n; ++j) {
                    PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)((ArrayList)object).get(j);
                    Iterator iterator3 = policyNodeImpl3.getChildren();
                    if (iterator3.hasNext()) continue;
                    PolicyNodeImpl policyNodeImpl4 = (PolicyNodeImpl)((PolicyNodeImpl)((ArrayList)object).get(j)).getParent();
                    if (policyNodeImpl4 != null) {
                        policyNodeImpl4.removeChild(policyNodeImpl3);
                        this.policyTree.remove(policyNodeImpl3);
                        --j;
                        --n;
                        continue;
                    }
                    throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                }
            }
            if (this.policyTree.getNodes(1) == null) {
                this.policyTree.setValid(false);
            }
        }
        if (!this.policyTree.isValid() && this.explicit_policy <= 0) {
            throw new CertPathValidatorException("Fail to pass certification path processing", null, this.certPath, this.currentCertIndex);
        }
        return this.policyTree;
    }

    private void deleteChild(PolicyTree policyTree, PolicyNodeImpl policyNodeImpl) {
        Iterator iterator = policyNodeImpl.getChildren();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)iterator.next();
            this.deleteChild(policyTree, policyNodeImpl2);
        }
        policyTree.remove(policyNodeImpl);
    }

    static {
        myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CertificatePolicies").toString(), OIDMap.getOID((String)"x509.info.extensions.PolicyConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.InhibitAnyPolicy").toString()};
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        anyPolicy_OID = objectIdentifier;
    }
}

