/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class CollectionCertStoreImpl
extends CertStoreSpi {
    private LinkedList X509Certs = new LinkedList();
    private LinkedList X509CRLs = new LinkedList();

    public CollectionCertStoreImpl(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        this.init(certStoreParameters);
    }

    private void init(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        Collection<Object> collection = new LinkedList();
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("CollectionCertStoreParameters not valid");
        }
        collection = ((CollectionCertStoreParameters)certStoreParameters).getCollection();
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof X509Certificate) {
                this.X509Certs.add(object);
                continue;
            }
            if (object instanceof X509CRL) {
                this.X509CRLs.add(object);
                continue;
            }
            throw new InvalidAlgorithmParameterException();
        }
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (certSelector == null) {
            return this.X509Certs;
        }
        LinkedList<Certificate> linkedList = new LinkedList<Certificate>();
        Iterator iterator = this.X509Certs.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            if (!certSelector.match(certificate)) continue;
            linkedList.add(certificate);
        }
        return linkedList;
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (cRLSelector == null) {
            return this.X509CRLs;
        }
        LinkedList<CRL> linkedList = new LinkedList<CRL>();
        Iterator iterator = this.X509CRLs.iterator();
        while (iterator.hasNext()) {
            CRL cRL = (CRL)iterator.next();
            if (!cRLSelector.match(cRL)) continue;
            linkedList.add(cRL);
        }
        return linkedList;
    }
}

