/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Security;

public final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;

    RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(RSAPrivateKey.a("9C2\u0014szB(\f7\u001ei\u0015Xr4O(\u001cr`\f") + iOException.getMessage());
        }
    }

    RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String toString() {
        String string = null;
        string = Security.getProvider(RSAPrivateKey.a("\u0013n\n2T\u001f")) == null ? new String(RSAPrivateKey.a("\u0013n\n2T\u001b")) : new String(RSAPrivateKey.a("\u0013n\n2T\u001f"));
        return string + RSAPrivateKey.a("z~\u001497\n^.\u000ev.Ig3r#\u0016M") + RSAPrivateKey.a("7C#\r{/_}r") + this.modulus.toString() + "\n" + RSAPrivateKey.a("*^.\u000ev.Ig\u001do*C)\u001dy.\u0016M") + this.privateExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(RSAPrivateKey.a("\u0013B1\u0019{3Hg*D\u001b|5\u0011a;X\"3r#\f\"\u0016t5H.\u0016pv\f#\u0019c;\f(\u000er(^2\u0016"));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void zeroize() {
        this.modulus = BigInteger.ZERO;
        this.privateExponent = BigInteger.ZERO;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 90;
                        break;
                    }
                    case 1: {
                        n5 = 44;
                        break;
                    }
                    case 2: {
                        n5 = 71;
                        break;
                    }
                    case 3: {
                        n5 = 120;
                        break;
                    }
                    default: {
                        n5 = 23;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

