/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.DataStore;
import com.ibm.xml.b2b.util.IntegerHashtable;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.EntityManager;

public final class EntityDeclPool {
    private static final boolean DEBUG_ADDITIONS = false;
    public static final int EntityType_Mask = 65535;
    public static final int EntityType_Predefined = 0;
    public static final int EntityType_InternalGeneral = 1;
    public static final int EntityType_ExternalGeneral = 2;
    public static final int EntityType_InternalParameter = 3;
    public static final int EntityType_ExternalParameter = 4;
    public static final int EntityType_Unparsed = 5;
    public static final int EntityType_DeclaredExternally = 65536;
    public static final int ENTITY_ENTITYTYPE_OFFSET = 0;
    public static final int ENTITY_NAME_OFFSET = 1;
    public static final int PREDEFINEDENTITY_CHARVALUE_OFFSET = 2;
    public static final int PREDEFINEDENTITY_RECORD_SIZE = 3;
    public static final int INTERNALENTITY_CONTENT_OFFSET = 2;
    public static final int INTERNALENTITY_RECORD_SIZE = 3;
    public static final int EXTERNALENTITY_BASEURI_OFFSET = 2;
    public static final int EXTERNALENTITY_PUBLICID_OFFSET = 3;
    public static final int EXTERNALENTITY_SYSTEMID_OFFSET = 4;
    public static final int EXTERNALENTITY_RECORD_SIZE = 5;
    public static final int UNPARSEDENTITY_RECORD_SIZE = 2;
    private SymbolTable fSymbolTable;
    private DataStore fDataStore;
    private IntegerHashtable fEntityDecls;
    private IntegerHashtable fPEDecls;
    private int fInternalEntityCount;
    private XMLString[] fInternalEntityContent;

    public EntityDeclPool(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fDataStore = new DataStore();
        this.fEntityDecls = new IntegerHashtable();
        this.fInternalEntityContent = new XMLString[16];
        this.createPredefinedEntities();
    }

    public void reset(boolean bl) {
        this.fDataStore.reset(bl);
        this.fEntityDecls.clear(bl);
        if (this.fPEDecls != null) {
            this.fPEDecls.clear(bl);
        }
        if (this.fInternalEntityCount != 0) {
            if (!bl) {
                int n = 0;
                while (n < this.fInternalEntityCount) {
                    this.fInternalEntityContent[n] = null;
                    ++n;
                }
            }
            this.fInternalEntityCount = 0;
        }
        this.createPredefinedEntities();
    }

    public int lookupEntity(int n) {
        return this.fEntityDecls.get(n);
    }

    public int lookupPE(int n) {
        return this.fPEDecls == null ? -1 : this.fPEDecls.get(n);
    }

    public boolean isUnparsedEntity(int n) {
        int n2;
        int[] nArray = this.fDataStore.getRecordArray(n);
        int n3 = nArray[(n2 = this.fDataStore.getRecordBase(n)) + 0];
        return (n3 & 0xFFFF) == 5;
    }

    public int[] getDeclArray(int n) {
        return this.fDataStore.getRecordArray(n);
    }

    public int getDeclBase(int n) {
        return this.fDataStore.getRecordBase(n);
    }

    public XMLString getInternalEntityContent(int n) {
        return this.fInternalEntityContent[n];
    }

    public boolean addInternalEntityDecl(XMLName xMLName, XMLString xMLString, EntityManager entityManager) {
        boolean bl = entityManager.inExternalEntity();
        int n = this.fSymbolTable.addSymbol(xMLName);
        if (this.fEntityDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.addInternalEntity(1, n, xMLString, bl);
        this.fEntityDecls.put(n, n2);
        return true;
    }

    public boolean addExternalEntityDecl(XMLName xMLName, XMLString xMLString, XMLString xMLString2, EntityManager entityManager) {
        int n = entityManager.currentBaseURI();
        boolean bl = entityManager.inExternalEntity();
        int n2 = this.fSymbolTable.addSymbol(xMLName);
        if (this.fEntityDecls.get(n2) != -1) {
            return false;
        }
        int n3 = xMLString == null ? -1 : this.fSymbolTable.addSymbol(xMLString);
        int n4 = this.fSymbolTable.addSymbol(xMLString2);
        int n5 = this.addExternalEntity(2, n2, n3, n4, n, bl);
        this.fEntityDecls.put(n2, n5);
        return true;
    }

    public boolean addUnparsedEntityDecl(XMLName xMLName) {
        int n = this.fSymbolTable.addSymbol(xMLName);
        if (this.fEntityDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.fDataStore.allocateRecord(2);
        int[] nArray = this.fDataStore.getRecordArray(n2);
        int n3 = this.fDataStore.getRecordBase(n2);
        nArray[n3 + 0] = 5;
        nArray[n3 + 1] = n;
        this.fEntityDecls.put(n, n2);
        return true;
    }

    public boolean addInternalPEDecl(XMLName xMLName, XMLString xMLString, EntityManager entityManager) {
        boolean bl = entityManager.inExternalEntity();
        int n = this.fSymbolTable.addSymbol(xMLName);
        if (this.fPEDecls != null && this.fPEDecls.get(n) != -1) {
            return false;
        }
        int n2 = this.addInternalEntity(3, n, xMLString, bl);
        if (this.fPEDecls == null) {
            this.fPEDecls = new IntegerHashtable();
        }
        this.fPEDecls.put(n, n2);
        return true;
    }

    public boolean addExternalPEDecl(XMLName xMLName, XMLString xMLString, XMLString xMLString2, EntityManager entityManager) {
        int n = entityManager.currentBaseURI();
        boolean bl = entityManager.inExternalEntity();
        int n2 = this.fSymbolTable.addSymbol(xMLName);
        if (this.fPEDecls != null && this.fPEDecls.get(n2) != -1) {
            return false;
        }
        int n3 = xMLString == null ? -1 : this.fSymbolTable.addSymbol(xMLString);
        int n4 = this.fSymbolTable.addSymbol(xMLString2);
        int n5 = this.addExternalEntity(4, n2, n3, n4, n, bl);
        if (this.fPEDecls == null) {
            this.fPEDecls = new IntegerHashtable();
        }
        this.fPEDecls.put(n2, n5);
        return true;
    }

    private void createPredefinedEntities() {
        this.addPredefinedEntity("lt", '<');
        this.addPredefinedEntity("gt", '>');
        this.addPredefinedEntity("amp", '&');
        this.addPredefinedEntity("apos", '\'');
        this.addPredefinedEntity("quot", '\"');
    }

    private void addPredefinedEntity(String string, char c) {
        int n = this.fSymbolTable.addSymbol(string);
        int n2 = this.fDataStore.allocateRecord(3);
        int[] nArray = this.fDataStore.getRecordArray(n2);
        int n3 = this.fDataStore.getRecordBase(n2);
        nArray[n3 + 0] = 0;
        nArray[n3 + 1] = n;
        nArray[n3 + 2] = c;
        this.fEntityDecls.put(n, n2);
    }

    private int addInternalEntity(int n, int n2, XMLString xMLString, boolean bl) {
        int n3;
        int n4 = this.fDataStore.allocateRecord(3);
        int[] nArray = this.fDataStore.getRecordArray(n4);
        int n5 = this.fDataStore.getRecordBase(n4);
        if ((n3 = this.fInternalEntityCount++) == this.fInternalEntityContent.length) {
            XMLString[] xMLStringArray = new XMLString[n3 << 1];
            System.arraycopy(this.fInternalEntityContent, 0, xMLStringArray, 0, n3);
            this.fInternalEntityContent = xMLStringArray;
        }
        if (this.fInternalEntityContent[n3] == null) {
            this.fInternalEntityContent[n3] = new XMLString(xMLString);
        } else {
            this.fInternalEntityContent[n3].setValues(xMLString);
        }
        int n6 = bl ? n | 0x10000 : n;
        nArray[n5 + 0] = n6;
        nArray[n5 + 1] = n2;
        nArray[n5 + 2] = n3;
        return n4;
    }

    private int addExternalEntity(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = this.fDataStore.allocateRecord(5);
        int[] nArray = this.fDataStore.getRecordArray(n6);
        int n7 = this.fDataStore.getRecordBase(n6);
        int n8 = bl ? n | 0x10000 : n;
        nArray[n7 + 0] = n8;
        nArray[n7 + 1] = n2;
        nArray[n7 + 3] = n3;
        nArray[n7 + 4] = n4;
        nArray[n7 + 2] = n5;
        return n6;
    }
}

