/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.EncodingSupport;

public class XMLString {
    public static final String EMPTY_STRING = "".intern();
    private static final boolean RETAIN_CHAR_CONVERSION_BUFFER = true;
    public byte[] bytes;
    public char[] chars;
    public int offset;
    public int endOffset;
    public EncodingSupport encoding;
    public String str;
    public int handle;
    public int flags;
    public static final int FLAGS_NOTWHITESPACE = 1;
    public static final int FLAGS_ALLWHITESPACE = 2;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;

    public XMLString() {
        this.handle = -1;
    }

    public XMLString(XMLString xMLString) {
        this.bytes = xMLString.bytes;
        this.chars = xMLString.chars;
        this.offset = xMLString.offset;
        this.endOffset = xMLString.endOffset;
        this.encoding = xMLString.encoding;
        this.str = xMLString.str;
        this.handle = xMLString.handle;
        this.flags = xMLString.flags;
    }

    public XMLString(String string) {
        this.str = string;
        this.handle = -1;
    }

    public void clear() {
        this.bytes = null;
        this.chars = null;
        this.encoding = null;
        this.str = null;
        this.handle = -1;
        this.flags = 0;
        if (this.fConvertedChars != null) {
            // empty if block
        }
    }

    public void setValues(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        this.bytes = byArray;
        this.chars = null;
        this.offset = n;
        this.endOffset = n2;
        this.encoding = encodingSupport;
        this.str = null;
        this.handle = -1;
        this.flags = 0;
    }

    public void setValues(char[] cArray, int n, int n2) {
        this.bytes = null;
        this.chars = cArray;
        this.offset = n;
        this.endOffset = n2;
        this.encoding = null;
        this.str = null;
        this.handle = -1;
        this.flags = 0;
    }

    public void setValues(XMLString xMLString) {
        if (xMLString == null) {
            this.clear();
        } else {
            this.bytes = xMLString.bytes;
            this.chars = xMLString.chars;
            this.offset = xMLString.offset;
            this.endOffset = xMLString.endOffset;
            this.encoding = xMLString.encoding;
            this.str = xMLString.str;
            this.handle = xMLString.handle;
            this.flags = xMLString.flags;
        }
    }

    public String toString() {
        if (this.str == null) {
            if (this.chars == null) {
                if (this.encoding != null) {
                    this.convertToChars();
                    this.str = new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
                }
            } else {
                this.str = new String(this.chars, this.offset, this.endOffset - this.offset);
            }
        }
        return this.str;
    }

    public int charLength() {
        if (this.chars == null) {
            if (this.str == null) {
                return this.encoding.lengthAsCharacters(this.bytes, this.offset, this.endOffset);
            }
            return this.str.length();
        }
        return this.endOffset - this.offset;
    }

    public void getChars(char[][] cArray, int[] nArray) {
        if (this.chars == null) {
            if (this.str == null) {
                this.encoding.convertBytesToChars(this.bytes, this.offset, this.endOffset, cArray, nArray);
            } else {
                char[] cArray2;
                int n = nArray[0];
                int n2 = this.str.length();
                if (n + n2 > (cArray2 = cArray[0]).length) {
                    int n3 = cArray2.length << 1;
                    while (n + n2 > n3) {
                        n3 <<= 1;
                    }
                    cArray2 = new char[n3];
                    System.arraycopy(cArray[0], 0, cArray2, 0, n);
                    cArray[0] = cArray2;
                }
                this.str.getChars(0, n2, cArray2, n);
                nArray[0] = n + n2;
            }
        } else {
            int n = nArray[0];
            int n4 = this.endOffset - this.offset;
            int n5 = n + n4;
            char[] cArray3 = cArray[0];
            if (n5 > cArray3.length) {
                int n6 = cArray3.length << 1;
                while (n5 > n6) {
                    n6 <<= 1;
                }
                cArray3 = new char[n6];
                System.arraycopy(cArray[0], 0, cArray3, 0, n);
                cArray[0] = cArray3;
            }
            System.arraycopy(this.chars, this.offset, cArray3, n, n4);
            nArray[0] = n5;
        }
    }

    protected final void convertToChars() {
        if (this.fConvertedChars == null) {
            int n = 8;
            while (n < this.endOffset - this.offset) {
                n <<= 1;
            }
            this.fConvertedChars = new char[1][];
            this.fConvertedChars[0] = new char[n];
            this.fConvertedCharsOffset = new int[1];
        }
        this.fConvertedCharsOffset[0] = 0;
        this.encoding.convertBytesToChars(this.bytes, this.offset, this.endOffset, this.fConvertedChars, this.fConvertedCharsOffset);
    }
}

