/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.IOExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;

public final class UCSEncodingSupport
implements EncodingSupport {
    public static final int UTF_16BE = 0;
    public static final int UTF_16LE = 1;
    public static final int UTF_32BE = 2;
    public static final int UTF_32LE = 3;
    public static final int UTF_16 = 4;
    public static final int ISO_10646_UCS_2 = 5;
    public static final int ISO_10646_UCS_4 = 6;
    private static UCSEncodingSupport[] fgSingletons = new UCSEncodingSupport[4];
    private int fOriginalEncodingType;
    private int fEncodingType;
    private boolean fPermitBOM;
    private int fWidth;
    private int fWidthShift;

    public static EncodingSupport getInstance(int n) {
        if (n <= 3) {
            if (fgSingletons[n] == null) {
                UCSEncodingSupport.fgSingletons[n] = new UCSEncodingSupport(n);
            }
            return fgSingletons[n];
        }
        return new UCSEncodingSupport(n);
    }

    public boolean isASCIITransparent() {
        return false;
    }

    public boolean isSingleByte() {
        return false;
    }

    public void convertCharsToBytes(char[] cArray, int n, int n2, byte[][] byArray, int[] nArray) {
        int n3;
        char[] cArray2 = cArray;
        int n4 = nArray[0];
        int n5 = n2;
        int n6 = n;
        int n7 = n4 + (n5 - n6 << this.fWidthShift);
        byte[] byArray2 = byArray[0];
        if (n7 > byArray2.length) {
            n3 = byArray2.length << 1;
            while (n7 > n3) {
                n3 <<= 1;
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray[0], 0, byArray2, 0, n4);
            byArray[0] = byArray2;
        }
        switch (this.fEncodingType) {
            case 0: {
                while (n6 < n5) {
                    n3 = cArray2[n6++];
                    byArray2[n4++] = (byte)(n3 >> 8);
                    byArray2[n4++] = (byte)n3;
                }
                break;
            }
            case 1: {
                while (n6 < n5) {
                    n3 = cArray2[n6++];
                    byArray2[n4++] = (byte)n3;
                    byArray2[n4++] = (byte)(n3 >> 8);
                }
                break;
            }
            case 2: {
                while (n4 < n7) {
                    if ((n3 = cArray2[n6++]) >= 55296) {
                        if (n3 < 56320) {
                            if (n6 < n5) {
                                char c;
                                if ((c = cArray2[n6++]) >= '\udc00' && c < '\ue000') {
                                    n3 = 65536 + (n3 - 55296 << 10) + (c - 56320);
                                } else {
                                    CharConversionError.invalidSecondHalfOfSurrogatePair();
                                }
                            } else {
                                CharConversionError.missingSecondHalfOfSurrogatePair();
                            }
                            n7 -= this.fWidth;
                        } else if (n3 < 57344) {
                            CharConversionError.invalidFirstHalfOfSurrogatePair();
                        }
                    }
                    byArray2[n4++] = (byte)(n3 >> 24 & 0xFF);
                    byArray2[n4++] = (byte)(n3 >> 16 & 0xFF);
                    byArray2[n4++] = (byte)(n3 >> 8 & 0xFF);
                    byArray2[n4++] = (byte)(n3 & 0xFF);
                }
                break;
            }
            case 3: {
                while (n4 < n7) {
                    if ((n3 = cArray2[n6++]) >= 55296) {
                        if (n3 < 56320) {
                            if (n6 < n5) {
                                char c;
                                if ((c = cArray2[n6++]) >= '\udc00' && c < '\ue000') {
                                    n3 = 65536 + (n3 - 55296 << 10) + (c - 56320);
                                } else {
                                    CharConversionError.invalidSecondHalfOfSurrogatePair();
                                }
                            } else {
                                CharConversionError.missingSecondHalfOfSurrogatePair();
                            }
                            n7 -= this.fWidth;
                        } else if (n3 < 57344) {
                            CharConversionError.invalidFirstHalfOfSurrogatePair();
                        }
                    }
                    byArray2[n4++] = (byte)(n3 & 0xFF);
                    byArray2[n4++] = (byte)(n3 >> 8 & 0xFF);
                    byArray2[n4++] = (byte)(n3 >> 16 & 0xFF);
                    byArray2[n4++] = (byte)(n3 >> 24 & 0xFF);
                }
                break;
            }
            default: {
                return;
            }
        }
        nArray[0] = n4;
    }

    public int encodeCharacter(int n, byte[][] byArray, int n2) {
        throw new RuntimeException("UCSEncodingSupport#encodeCharacter()");
    }

    public int normalizeLineBreaks(byte[] byArray, int n, int n2, boolean[] blArray) {
        throw new RuntimeException("UCSEncodingSupport#normalizeLineBreaks()");
    }

    public void readCharacters(InputStream inputStream, char[][] cArray, int[] nArray, boolean[] blArray, byte[] byArray, boolean bl) {
        int n = 0;
        try {
            boolean bl2 = false;
            int n2 = 0;
            if (bl && this.fPermitBOM) {
                n2 = this.checkForUCSBOM(inputStream, byArray);
            }
            if (n2 < 0) {
                n2 += this.fWidth;
                bl2 = true;
            }
            do {
                int n3;
                if ((n = n2 - (n3 = blArray != null ? this.normalizeBytesToChars(byArray, 0, n2, cArray, nArray, blArray) : this.convertBytesToCharsPartial(byArray, 0, n2 += n, cArray, nArray))) <= 0) continue;
                int n4 = 0;
                do {
                    byArray[n4++] = byArray[n3++];
                } while (n4 < n);
            } while (!bl2 && (n2 = inputStream.read(byArray, n, byArray.length - n)) >= 0);
            if (n != 0) {
                CharConversionError.partialMultiPartCharacterSequence();
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    private int checkForUCSBOM(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 == 254) {
            n2 = inputStream.read();
            if (n2 == 255) {
                return 0;
            }
            if (this.fOriginalEncodingType == 4) {
                CharConversionError.byteOrderMarkRequired();
            } else {
                byArray[n++] = -2;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (n2 == 255) {
            n2 = inputStream.read();
            if (n2 == 254) {
                if (this.fWidth == 2) {
                    this.fEncodingType = 1;
                    return 0;
                }
                n2 = inputStream.read();
                if (n2 == 0) {
                    n2 = inputStream.read();
                    if (n2 == 0) {
                        this.fEncodingType = 3;
                        return 0;
                    }
                    byArray[n++] = -1;
                    byArray[n++] = -2;
                    byArray[n++] = 0;
                    if (n2 != -1) {
                        byArray[n++] = (byte)n2;
                        return n;
                    }
                } else {
                    byArray[n++] = -1;
                    byArray[n++] = -2;
                    if (n2 != -1) {
                        byArray[n++] = (byte)n2;
                        return n;
                    }
                }
            } else if (this.fOriginalEncodingType == 4) {
                CharConversionError.byteOrderMarkRequired();
            } else {
                byArray[n++] = -2;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (this.fOriginalEncodingType == 4) {
            CharConversionError.byteOrderMarkRequired();
        } else if (n2 == 0 && this.fWidth == 4) {
            n2 = inputStream.read();
            if (n2 == 0) {
                n2 = inputStream.read();
                if (n2 == 254) {
                    n2 = inputStream.read();
                    if (n2 == 255) {
                        return 0;
                    }
                    byArray[n++] = 0;
                    byArray[n++] = 0;
                    byArray[n++] = -2;
                    if (n2 != -1) {
                        byArray[n++] = (byte)n2;
                        return n;
                    }
                } else {
                    byArray[n++] = 0;
                    byArray[n++] = 0;
                    if (n2 != -1) {
                        byArray[n++] = (byte)n2;
                        return n;
                    }
                }
            } else {
                byArray[n++] = 0;
                if (n2 != -1) {
                    byArray[n++] = (byte)n2;
                    return n;
                }
            }
        } else if (n2 != -1) {
            byArray[n++] = (byte)n2;
            return n;
        }
        return n - this.fWidth;
    }

    public int lengthAsCharacters(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if ((n3 & this.fWidth - 1) != 0) {
            CharConversionError.partialMultiPartCharacterSequence();
        }
        return n3 >> this.fWidthShift;
    }

    public void convertBytesToChars(byte[] byArray, int n, int n2, char[][] cArray, int[] nArray) {
        int n3 = this.convertBytesToCharsPartial(byArray, n, n2, cArray, nArray);
        if (n3 != n2) {
            CharConversionError.partialMultiPartCharacterSequence();
        }
    }

    private int convertBytesToCharsPartial(byte[] byArray, int n, int n2, char[][] cArray, int[] nArray) {
        int n3;
        byte[] byArray2 = byArray;
        int n4 = n;
        int n5 = n2 - n4 >> this.fWidthShift;
        int n6 = n4 + (n5 << this.fWidthShift);
        int n7 = nArray[0];
        int n8 = n7 + n5;
        char[] cArray2 = cArray[0];
        if (n8 > cArray2.length) {
            n3 = cArray2.length << 1;
            while (n8 > n3) {
                n3 <<= 1;
            }
            cArray2 = new char[n3];
            System.arraycopy(cArray[0], 0, cArray2, 0, n7);
            cArray[0] = cArray2;
        }
        switch (this.fEncodingType) {
            case 0: {
                while (n4 < n6) {
                    int n9 = byArray2[n4++] & 0xFF;
                    int n10 = byArray2[n4++] & 0xFF;
                    int n11 = (n9 << 8) + n10;
                    cArray2[n7++] = (char)n11;
                }
                break;
            }
            case 1: {
                while (n4 < n6) {
                    int n12 = byArray2[n4++] & 0xFF;
                    int n13 = byArray2[n4++] & 0xFF;
                    int n14 = (n13 << 8) + n12;
                    cArray2[n7++] = (char)n14;
                }
                break;
            }
            case 2: {
                while (n4 < n6) {
                    int n15;
                    int n16;
                    int n17;
                    int n18 = byArray2[n4++] & 0xFF;
                    int n19 = byArray2[n4++] & 0xFF;
                    if ((n17 = (n18 << 24) + (n19 << 16) + ((n16 = byArray2[n4++] & 0xFF) << 8) + (n15 = byArray2[n4++] & 0xFF)) < 65536) {
                        cArray2[n7++] = (char)n17;
                        continue;
                    }
                    n3 = n17 - 65536;
                    if (++n8 > cArray2.length) {
                        int n20 = cArray2.length << 1;
                        while (n8 > n20) {
                            n20 <<= 1;
                        }
                        cArray2 = new char[n20];
                        System.arraycopy(cArray[0], 0, cArray2, 0, n7);
                        cArray[0] = cArray2;
                    }
                    cArray2[n7++] = (char)(55296 + (n3 >> 10));
                    cArray2[n7++] = (char)(56320 + (n3 & 0x3FF));
                }
                break;
            }
            case 3: {
                while (n4 < n6) {
                    int n21;
                    int n22;
                    int n23;
                    int n24 = byArray2[n4++] & 0xFF;
                    int n25 = byArray2[n4++] & 0xFF;
                    if ((n23 = ((n22 = byArray2[n4++] & 0xFF) << 24) + ((n21 = byArray2[n4++] & 0xFF) << 16) + (n25 << 8) + n24) < 65536) {
                        cArray2[n7++] = (char)n23;
                        continue;
                    }
                    n3 = n23 - 65536;
                    if (++n8 > cArray2.length) {
                        int n26 = cArray2.length << 1;
                        while (n8 > n26) {
                            n26 <<= 1;
                        }
                        cArray2 = new char[n26];
                        System.arraycopy(cArray[0], 0, cArray2, 0, n7);
                        cArray[0] = cArray2;
                    }
                    cArray2[n7++] = (char)(55296 + (n3 >> 10));
                    cArray2[n7++] = (char)(56320 + (n3 & 0x3FF));
                }
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = n7;
        return n4;
    }

    public int decodeCharacter(byte[] byArray, int n, int n2, int[] nArray) {
        if (n + this.fWidth <= n2) {
            int n3;
            int n4 = byArray[n++] & 0xFF;
            int n5 = byArray[n++] & 0xFF;
            switch (this.fEncodingType) {
                case 0: {
                    n3 = (n4 << 8) + n5;
                    break;
                }
                case 1: {
                    n3 = (n5 << 8) + n4;
                    break;
                }
                case 2: {
                    int n6 = byArray[n++] & 0xFF;
                    int n7 = byArray[n++] & 0xFF;
                    n3 = (n4 << 24) + (n5 << 16) + (n6 << 8) + n7;
                    break;
                }
                case 3: {
                    int n8 = byArray[n++] & 0xFF;
                    int n9 = byArray[n++] & 0xFF;
                    n3 = (n9 << 24) + (n8 << 16) + (n5 << 8) + n4;
                    break;
                }
                default: {
                    return -1;
                }
            }
            if (nArray != null) {
                nArray[0] = this.fWidth;
            }
            return n3;
        }
        CharConversionError.insufficientInputToDecodeCharacter();
        return -1;
    }

    private UCSEncodingSupport(int n) {
        this.fOriginalEncodingType = n;
        this.fEncodingType = n;
        switch (n) {
            case 0: {
                this.fWidth = 2;
                this.fWidthShift = 1;
                break;
            }
            case 1: {
                this.fWidth = 2;
                this.fWidthShift = 1;
                break;
            }
            case 2: {
                this.fWidth = 4;
                this.fWidthShift = 2;
                break;
            }
            case 3: {
                this.fWidth = 4;
                this.fWidthShift = 2;
                break;
            }
            case 4: 
            case 5: {
                this.fEncodingType = 0;
                this.fPermitBOM = true;
                this.fWidth = 2;
                this.fWidthShift = 1;
                break;
            }
            case 6: {
                this.fEncodingType = 2;
                this.fPermitBOM = true;
                this.fWidth = 4;
                this.fWidthShift = 2;
            }
        }
    }

    private int normalizeBytesToChars(byte[] byArray, int n, int n2, char[][] cArray, int[] nArray, boolean[] blArray) {
        int n3;
        int n4 = n2 - n >> this.fWidthShift;
        int n5 = n + (n4 << this.fWidthShift);
        char[] cArray2 = cArray[0];
        int n6 = nArray[0];
        int n7 = n6 + n4;
        boolean bl = blArray[0];
        if (n7 > cArray2.length) {
            n3 = cArray2.length << 1;
            while (n7 > n3) {
                n3 <<= 1;
            }
            cArray2 = new char[n3];
            System.arraycopy(cArray[0], 0, cArray2, 0, n6);
            cArray[0] = cArray2;
        }
        switch (this.fEncodingType) {
            case 0: {
                while (n < n5) {
                    int n8 = byArray[n++] & 0xFF;
                    int n9 = byArray[n++] & 0xFF;
                    int n10 = (n8 << 8) + n9;
                    if (bl) {
                        bl = false;
                        if (n10 == 10) continue;
                    }
                    if (n10 == 13) {
                        n10 = 10;
                        bl = true;
                    }
                    cArray2[n6++] = (char)n10;
                }
                break;
            }
            case 1: {
                while (n < n5) {
                    int n11 = byArray[n++] & 0xFF;
                    int n12 = byArray[n++] & 0xFF;
                    int n13 = (n12 << 8) + n11;
                    if (bl) {
                        bl = false;
                        if (n13 == 10) continue;
                    }
                    if (n13 == 13) {
                        n13 = 10;
                        bl = true;
                    }
                    cArray2[n6++] = (char)n13;
                }
                break;
            }
            case 2: {
                while (n < n5) {
                    int n14;
                    int n15;
                    int n16;
                    int n17 = byArray[n++] & 0xFF;
                    int n18 = byArray[n++] & 0xFF;
                    if ((n16 = (n17 << 24) + (n18 << 16) + ((n15 = byArray[n++] & 0xFF) << 8) + (n14 = byArray[n++] & 0xFF)) < 65536) {
                        if (bl) {
                            bl = false;
                            if (n16 == 10) continue;
                        }
                        if (n16 == 13) {
                            n16 = 10;
                            bl = true;
                        }
                        cArray2[n6++] = (char)n16;
                        continue;
                    }
                    n3 = n16 - 65536;
                    if (++n7 > cArray2.length) {
                        int n19 = cArray2.length << 1;
                        while (n7 > n19) {
                            n19 <<= 1;
                        }
                        cArray2 = new char[n19];
                        System.arraycopy(cArray[0], 0, cArray2, 0, n6);
                        cArray[0] = cArray2;
                    }
                    cArray2[n6++] = (char)(55296 + (n3 >> 10));
                    cArray2[n6++] = (char)(56320 + (n3 & 0x3FF));
                }
                break;
            }
            case 3: {
                while (n < n5) {
                    int n20;
                    int n21;
                    int n22;
                    int n23 = byArray[n++] & 0xFF;
                    int n24 = byArray[n++] & 0xFF;
                    if ((n22 = ((n21 = byArray[n++] & 0xFF) << 24) + ((n20 = byArray[n++] & 0xFF) << 16) + (n24 << 8) + n23) < 65536) {
                        if (bl) {
                            bl = false;
                            if (n22 == 10) continue;
                        }
                        if (n22 == 13) {
                            n22 = 10;
                            bl = true;
                        }
                        cArray2[n6++] = (char)n22;
                        continue;
                    }
                    n3 = n22 - 65536;
                    if (++n7 > cArray2.length) {
                        int n25 = cArray2.length << 1;
                        while (n7 > n25) {
                            n25 <<= 1;
                        }
                        cArray2 = new char[n25];
                        System.arraycopy(cArray[0], 0, cArray2, 0, n6);
                        cArray[0] = cArray2;
                    }
                    cArray2[n6++] = (char)(55296 + (n3 >> 10));
                    cArray2[n6++] = (char)(56320 + (n3 & 0x3FF));
                }
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = n6;
        blArray[0] = bl;
        return n;
    }
}

