/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan.utf16;

import com.ibm.xml.b2b.scan.DocumentEntityState;
import com.ibm.xml.b2b.scan.DocumentEventHandler;
import com.ibm.xml.b2b.scan.DocumentImplementationHandler;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public final class UTF16DocumentScanner {
    public static boolean scanDocument(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        char c;
        char[] cArray = parsedEntity.chars;
        int n = parsedEntity.offset;
        boolean bl = false;
        while (true) {
            c = cArray[n];
            while (c != '<') {
                c = cArray[++n];
            }
            c = cArray[n + 1];
            if (c != '!') {
                if (c != '?') break;
                parsedEntity.offset = n + 2;
                n = UTF16DocumentScanner.scanPI(documentEventHandler, documentEntityState, parsedEntity);
                continue;
            }
            c = cArray[n + 2];
            if (bl || c == '-') {
                parsedEntity.offset = n + 4;
                n = UTF16DocumentScanner.scanComment(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity);
                continue;
            }
            bl = true;
            parsedEntity.offset = n + 9;
            if (documentImplementationHandler != null) {
                if (!documentImplementationHandler.scanDoctypeDecl(parsedEntity)) {
                    return false;
                }
                if (!documentImplementationHandler.scanExternalSubset()) {
                    return false;
                }
                n = parsedEntity.offset;
                continue;
            }
            n = UTF16DocumentScanner.skipDoctypeDecl(parsedEntity);
        }
        parsedEntity.offset = n;
        if (UTF16DocumentScanner.scanContent(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity)) {
            n = parsedEntity.offset;
            while (true) {
                c = cArray[n];
                while (c != '<') {
                    if (c == '\u0000') {
                        return true;
                    }
                    c = cArray[++n];
                }
                if ((c = cArray[++n]) == '?') {
                    parsedEntity.offset = n + 1;
                    n = UTF16DocumentScanner.scanPI(documentEventHandler, documentEntityState, parsedEntity);
                    continue;
                }
                parsedEntity.offset = n + 3;
                n = UTF16DocumentScanner.scanComment(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity);
            }
        }
        return false;
    }

    public static boolean scanContent(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        char[] cArray = parsedEntity.chars;
        int n = parsedEntity.offset;
        while (true) {
            int n2;
            XMLString xMLString;
            int n3 = ++n;
            char c = cArray[n];
            while (c != '<' && c != '&' && c != '\u0000') {
                c = cArray[++n];
            }
            if (n > n3) {
                xMLString = documentEntityState.content;
                xMLString.setValues(cArray, n3, n);
                documentEventHandler.characters(xMLString);
            }
            if (c == '<') {
                if ((c = cArray[++n]) == '?') {
                    parsedEntity.offset = n + 1;
                    n = UTF16DocumentScanner.scanPI(documentEventHandler, documentEntityState, parsedEntity);
                    continue;
                }
                if (c == '!') {
                    if ((c = cArray[++n]) == '-') {
                        parsedEntity.offset = n + 2;
                        n = UTF16DocumentScanner.scanComment(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity);
                        continue;
                    }
                    if (documentImplementationHandler != null) {
                        documentImplementationHandler.startCDATA();
                    }
                    n3 = n += 7;
                    while (cArray[n] != ']' || cArray[n + 1] != ']' || cArray[n + 2] != '>') {
                        ++n;
                    }
                    if (n > n3) {
                        xMLString = documentEntityState.content;
                        xMLString.setValues(cArray, n3, n);
                        documentEventHandler.characters(xMLString);
                    }
                    if (documentImplementationHandler != null) {
                        documentImplementationHandler.endCDATA();
                    }
                    n += 3;
                    continue;
                }
                if (c == '/') {
                    ++n;
                    xMLString = documentEntityState.popElement();
                    c = cArray[n += xMLString.endOffset - xMLString.offset];
                    while (c != '>') {
                        c = cArray[++n];
                    }
                    ++n;
                    documentEventHandler.endElementEvent();
                    documentEntityState.endNamespacesScope();
                    if (documentEntityState.elementDepth != 0) continue;
                    parsedEntity.offset = n;
                    return true;
                }
                boolean bl = false;
                n2 = 0;
                QName qName = documentEntityState.elementType;
                qName.setValues(cArray, n, 0);
                while (true) {
                    if ((c = cArray[++n]) == '>') {
                        qName.endOffset = n++;
                        break;
                    }
                    if (c == '/') {
                        qName.endOffset = n;
                        n += 2;
                        bl = true;
                        break;
                    }
                    if (c == ' ' || c == '\n' || c == '\t') {
                        qName.endOffset = n;
                        while ((c = cArray[++n]) == ' ' || c == '\n' || c == '\t') {
                        }
                        if (c == '>') {
                            ++n;
                            break;
                        }
                        if (c == '/') {
                            n += 2;
                            bl = true;
                            break;
                        }
                        n2 = 1;
                        break;
                    }
                    if (c != ':') continue;
                    qName.sepOffset = n;
                }
                documentEntityState.createQNameSymbols(documentEntityState.elementType);
                documentEntityState.processElementType();
                while (n2 != 0) {
                    QName qName2 = documentEntityState.attributeName;
                    qName2.setValues(cArray, n, 0);
                    while ((c = cArray[++n]) != '=' && c != ' ' && c != '\n' && c != '\t') {
                        if (c != ':') continue;
                        qName2.sepOffset = n;
                    }
                    qName2.endOffset = n;
                    documentEntityState.createQNameSymbols(documentEntityState.attributeName);
                    documentEntityState.processAttributeName(qName2, true);
                    while (c != '=') {
                        c = cArray[++n];
                    }
                    c = cArray[++n];
                    while (c != '\'' && c != '\"') {
                        c = cArray[++n];
                    }
                    char c2 = c;
                    parsedEntity.offset = ++n;
                    UTF16DocumentScanner.scanAttValue(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity, c2);
                    n = parsedEntity.offset;
                    c = cArray[n];
                    while (c == ' ' || c == '\n' || c == '\t') {
                        c = cArray[++n];
                    }
                    if (c != '>' && c != '/') continue;
                    bl = c == '/';
                    documentEntityState.endOfSpecifiedAttributes();
                    if (bl) {
                        n += 2;
                        break;
                    }
                    ++n;
                    break;
                }
                if (bl) {
                    documentEventHandler.startElementEvent(true);
                    documentEntityState.endNamespacesScope();
                    if (documentEntityState.elementDepth != 0) continue;
                    parsedEntity.offset = n;
                    return true;
                }
                documentEventHandler.startElementEvent(false);
                documentEntityState.pushElement();
                continue;
            }
            if (c != '&') break;
            if ((c = cArray[++n]) == '#') {
                int n4;
                if ((c = cArray[++n]) == 'x') {
                    n4 = c - ((c = cArray[++n]) < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                    while ((c = cArray[++n]) != ';') {
                        n2 = c - (c < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                        n4 = (n4 << 4) + n2;
                    }
                } else {
                    n4 = c - 48;
                    while (true) {
                        if ((c = cArray[++n]) == ';') {
                            ++n;
                            break;
                        }
                        n2 = c - 48;
                        n4 = n4 * 10 + n2;
                    }
                }
                documentEventHandler.character(n4, false);
                continue;
            }
            xMLString = documentEntityState.entityName;
            n3 = n;
            while (c != ';') {
                c = cArray[++n];
            }
            xMLString.setValues(cArray, n3, n);
            ++n;
            UTF16DocumentScanner.entityReferenceInContent(documentEventHandler, documentImplementationHandler, documentEntityState, (XMLName)xMLString);
        }
        parsedEntity.offset = n;
        return true;
    }

    public static boolean scanAttValue(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity, int n) {
        char[] cArray = parsedEntity.chars;
        int n2 = parsedEntity.offset;
        while (true) {
            XMLString xMLString;
            int n3 = ++n2;
            char c = cArray[n2];
            boolean bl = true;
            while (c != n && c != '&') {
                if (c == '\t' || c == '\n' || c == '\r') {
                    bl = false;
                }
                c = cArray[++n2];
            }
            if (n2 > n3) {
                xMLString = documentEntityState.content;
                xMLString.setValues(cArray, n3, n2);
                documentEntityState.attributeValueCharacters(xMLString, bl);
            }
            if (c == n) {
                parsedEntity.offset = c != '\u0000' ? n2 + 1 : n2;
                return true;
            }
            if ((c = cArray[++n2]) == '#') {
                int n4;
                int n5;
                if ((c = cArray[++n2]) == 'x') {
                    n5 = c - ((c = cArray[++n2]) < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                    while ((c = cArray[++n2]) != ';') {
                        n4 = c - (c < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                        n5 = (n5 << 4) + n4;
                    }
                } else {
                    n5 = c - 48;
                    while (true) {
                        if ((c = cArray[++n2]) == ';') {
                            ++n2;
                            break;
                        }
                        n4 = c - 48;
                        n5 = n5 * 10 + n4;
                    }
                }
                documentEntityState.attributeValueCharacter(n5, false);
                continue;
            }
            xMLString = documentEntityState.entityName;
            n3 = n2;
            while (c != ';') {
                c = cArray[++n2];
            }
            xMLString.setValues(cArray, n3, n2);
            ++n2;
            UTF16DocumentScanner.entityReferenceInAttValue(documentImplementationHandler, documentEntityState, (XMLName)xMLString);
        }
    }

    private static int scanComment(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        char[] cArray = parsedEntity.chars;
        int n = parsedEntity.offset;
        XMLString xMLString = documentEntityState.content;
        int n2 = n;
        char c = cArray[n];
        while (c != '-' || cArray[n + 1] != '-') {
            c = cArray[++n];
        }
        xMLString.setValues(cArray, n2, n);
        if (documentImplementationHandler != null) {
            documentImplementationHandler.comment(xMLString);
        }
        return n + 3;
    }

    private static int scanPI(DocumentEventHandler documentEventHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        char[] cArray = parsedEntity.chars;
        int n = parsedEntity.offset;
        XMLName xMLName = documentEntityState.target;
        XMLString xMLString = documentEntityState.content;
        int n2 = n;
        boolean bl = false;
        char c = cArray[n];
        while ((c = cArray[++n]) != '?') {
            if (c != ' ' && c != '\n' && c != '\t') continue;
            bl = true;
            break;
        }
        xMLName.setValues(cArray, n2, n);
        if (bl) {
            while ((c = cArray[++n]) == ' ' || c == '\n' || c == '\t') {
            }
            n2 = n;
            while (c != '?' || cArray[n + 1] != '>') {
                c = cArray[++n];
            }
        } else {
            n2 = n;
        }
        xMLString.setValues(cArray, n2, n);
        documentEventHandler.processingInstruction(xMLName, xMLString);
        return n + 2;
    }

    private static int skipDoctypeDecl(ParsedEntity parsedEntity) {
        char c;
        char[] cArray = parsedEntity.chars;
        int n = parsedEntity.offset;
        do {
            if ((c = cArray[++n]) != '[') continue;
            while (true) {
                if ((c = cArray[++n]) != ']') {
                    continue;
                }
                while ((c = cArray[++n]) == ' ' || c == '\n' || c == '\t') {
                }
                if (c == '>') break;
            }
        } while (c != '>');
        return ++n;
    }

    private static boolean entityReferenceInContent(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, XMLName xMLName) {
        if (documentImplementationHandler != null) {
            return documentImplementationHandler.entityReferenceInContent(xMLName);
        }
        int n = documentEntityState.checkPredefinedEntities(xMLName);
        if (n != -1) {
            documentEventHandler.character(n, true);
            return true;
        }
        documentEntityState.undeclaredEntityInContent(xMLName);
        return false;
    }

    private static boolean entityReferenceInAttValue(DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, XMLName xMLName) {
        if (documentImplementationHandler != null) {
            return documentImplementationHandler.entityReferenceInAttValue(xMLName);
        }
        int n = documentEntityState.checkPredefinedEntities(xMLName);
        if (n != -1) {
            documentEntityState.attributeValueCharacter(n, true);
            return true;
        }
        documentEntityState.undeclaredEntityInAttValue(xMLName);
        return false;
    }

    private UTF16DocumentScanner() {
    }
}

