/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan.singleByte;

import com.ibm.xml.b2b.scan.DocumentEntityState;
import com.ibm.xml.b2b.scan.DocumentEventHandler;
import com.ibm.xml.b2b.scan.DocumentImplementationHandler;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public final class SingleByteDocumentScanner {
    public static boolean scanDocument(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        char c;
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        boolean bl = false;
        while (true) {
            c = cArray[byArray[n] & 0xFF];
            while (c != '<') {
                c = cArray[byArray[++n] & 0xFF];
            }
            c = cArray[byArray[n + 1] & 0xFF];
            if (c != '!') {
                if (c != '?') break;
                parsedEntity.offset = n + 2;
                n = SingleByteDocumentScanner.scanPI(documentEventHandler, documentEntityState, parsedEntity);
                continue;
            }
            c = cArray[byArray[n + 2] & 0xFF];
            if (bl || c == '-') {
                parsedEntity.offset = n + 4;
                n = SingleByteDocumentScanner.scanComment(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity);
                continue;
            }
            bl = true;
            parsedEntity.offset = n + 9;
            if (documentImplementationHandler != null) {
                if (!documentImplementationHandler.scanDoctypeDecl(parsedEntity)) {
                    return false;
                }
                if (!documentImplementationHandler.scanExternalSubset()) {
                    return false;
                }
                n = parsedEntity.offset;
                continue;
            }
            n = SingleByteDocumentScanner.skipDoctypeDecl(parsedEntity);
        }
        parsedEntity.offset = n;
        if (SingleByteDocumentScanner.scanContent(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity)) {
            n = parsedEntity.offset;
            while (true) {
                c = cArray[byArray[n] & 0xFF];
                while (c != '<') {
                    if (c == '\u0000') {
                        return true;
                    }
                    c = cArray[byArray[++n] & 0xFF];
                }
                if ((c = cArray[byArray[++n] & 0xFF]) == '?') {
                    parsedEntity.offset = n + 1;
                    n = SingleByteDocumentScanner.scanPI(documentEventHandler, documentEntityState, parsedEntity);
                    continue;
                }
                parsedEntity.offset = n + 3;
                n = SingleByteDocumentScanner.scanComment(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity);
            }
        }
        return false;
    }

    public static boolean scanContent(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        while (true) {
            int n2;
            XMLString xMLString;
            int n3 = ++n;
            char c = cArray[byArray[n] & 0xFF];
            while (c != '<' && c != '&' && c != '\u0000') {
                c = cArray[byArray[++n] & 0xFF];
            }
            if (n > n3) {
                xMLString = documentEntityState.content;
                xMLString.setValues(byArray, n3, n, singleByteEncodingSupport);
                documentEventHandler.characters(xMLString);
            }
            if (c == '<') {
                if ((c = cArray[byArray[++n] & 0xFF]) == '?') {
                    parsedEntity.offset = n + 1;
                    n = SingleByteDocumentScanner.scanPI(documentEventHandler, documentEntityState, parsedEntity);
                    continue;
                }
                if (c == '!') {
                    if ((c = cArray[byArray[++n] & 0xFF]) == '-') {
                        parsedEntity.offset = n + 2;
                        n = SingleByteDocumentScanner.scanComment(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity);
                        continue;
                    }
                    if (documentImplementationHandler != null) {
                        documentImplementationHandler.startCDATA();
                    }
                    n3 = n += 7;
                    while (cArray[byArray[n] & 0xFF] != ']' || cArray[byArray[n + 1] & 0xFF] != ']' || cArray[byArray[n + 2] & 0xFF] != '>') {
                        ++n;
                    }
                    if (n > n3) {
                        xMLString = documentEntityState.content;
                        xMLString.setValues(byArray, n3, n, singleByteEncodingSupport);
                        documentEventHandler.characters(xMLString);
                    }
                    if (documentImplementationHandler != null) {
                        documentImplementationHandler.endCDATA();
                    }
                    n += 3;
                    continue;
                }
                if (c == '/') {
                    ++n;
                    xMLString = documentEntityState.popElement();
                    c = cArray[byArray[n += xMLString.endOffset - xMLString.offset] & 0xFF];
                    while (c != '>') {
                        c = cArray[byArray[++n] & 0xFF];
                    }
                    ++n;
                    documentEventHandler.endElementEvent();
                    documentEntityState.endNamespacesScope();
                    if (documentEntityState.elementDepth != 0) continue;
                    parsedEntity.offset = n;
                    return true;
                }
                boolean bl = false;
                n2 = 0;
                QName qName = documentEntityState.elementType;
                qName.setValues(byArray, n, 0, singleByteEncodingSupport);
                while (true) {
                    if ((c = cArray[byArray[++n] & 0xFF]) == '>') {
                        qName.endOffset = n++;
                        break;
                    }
                    if (c == '/') {
                        qName.endOffset = n;
                        n += 2;
                        bl = true;
                        break;
                    }
                    if (c == ' ' || c == '\n' || c == '\t') {
                        qName.endOffset = n;
                        while ((c = cArray[byArray[++n] & 0xFF]) == ' ' || c == '\n' || c == '\t') {
                        }
                        if (c == '>') {
                            ++n;
                            break;
                        }
                        if (c == '/') {
                            n += 2;
                            bl = true;
                            break;
                        }
                        n2 = 1;
                        break;
                    }
                    if (c != ':') continue;
                    qName.sepOffset = n;
                }
                documentEntityState.createQNameSymbols(documentEntityState.elementType);
                documentEntityState.processElementType();
                while (n2 != 0) {
                    QName qName2 = documentEntityState.attributeName;
                    qName2.setValues(byArray, n, 0, singleByteEncodingSupport);
                    while ((c = cArray[byArray[++n] & 0xFF]) != '=' && c != ' ' && c != '\n' && c != '\t') {
                        if (c != ':') continue;
                        qName2.sepOffset = n;
                    }
                    qName2.endOffset = n;
                    documentEntityState.createQNameSymbols(documentEntityState.attributeName);
                    documentEntityState.processAttributeName(qName2, true);
                    while (c != '=') {
                        c = cArray[byArray[++n] & 0xFF];
                    }
                    c = cArray[byArray[++n] & 0xFF];
                    while (c != '\'' && c != '\"') {
                        c = cArray[byArray[++n] & 0xFF];
                    }
                    char c2 = c;
                    parsedEntity.offset = ++n;
                    SingleByteDocumentScanner.scanAttValue(documentEventHandler, documentImplementationHandler, documentEntityState, parsedEntity, c2);
                    n = parsedEntity.offset;
                    c = cArray[byArray[n] & 0xFF];
                    while (c == ' ' || c == '\n' || c == '\t') {
                        c = cArray[byArray[++n] & 0xFF];
                    }
                    if (c != '>' && c != '/') continue;
                    bl = c == '/';
                    documentEntityState.endOfSpecifiedAttributes();
                    if (bl) {
                        n += 2;
                        break;
                    }
                    ++n;
                    break;
                }
                if (bl) {
                    documentEventHandler.startElementEvent(true);
                    documentEntityState.endNamespacesScope();
                    if (documentEntityState.elementDepth != 0) continue;
                    parsedEntity.offset = n;
                    return true;
                }
                documentEventHandler.startElementEvent(false);
                documentEntityState.pushElement();
                continue;
            }
            if (c != '&') break;
            if ((c = cArray[byArray[++n] & 0xFF]) == '#') {
                int n4;
                if ((c = cArray[byArray[++n] & 0xFF]) == 'x') {
                    n4 = c - ((c = cArray[byArray[++n] & 0xFF]) < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                    while ((c = cArray[byArray[++n] & 0xFF]) != ';') {
                        n2 = c - (c < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                        n4 = (n4 << 4) + n2;
                    }
                } else {
                    n4 = c - 48;
                    while (true) {
                        if ((c = cArray[byArray[++n] & 0xFF]) == ';') {
                            ++n;
                            break;
                        }
                        n2 = c - 48;
                        n4 = n4 * 10 + n2;
                    }
                }
                documentEventHandler.character(n4, false);
                continue;
            }
            xMLString = documentEntityState.entityName;
            n3 = n;
            while (c != ';') {
                c = cArray[byArray[++n] & 0xFF];
            }
            xMLString.setValues(byArray, n3, n, singleByteEncodingSupport);
            ++n;
            SingleByteDocumentScanner.entityReferenceInContent(documentEventHandler, documentImplementationHandler, documentEntityState, (XMLName)xMLString);
        }
        parsedEntity.offset = n;
        return true;
    }

    public static boolean scanAttValue(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity, int n) {
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        byte[] byArray = parsedEntity.bytes;
        int n2 = parsedEntity.offset;
        while (true) {
            XMLString xMLString;
            int n3 = ++n2;
            char c = cArray[byArray[n2] & 0xFF];
            boolean bl = true;
            while (c != n && c != '&') {
                if (c == '\t' || c == '\n' || c == '\r') {
                    bl = false;
                }
                c = cArray[byArray[++n2] & 0xFF];
            }
            if (n2 > n3) {
                xMLString = documentEntityState.content;
                xMLString.setValues(byArray, n3, n2, singleByteEncodingSupport);
                documentEntityState.attributeValueCharacters(xMLString, bl);
            }
            if (c == n) {
                parsedEntity.offset = c != '\u0000' ? n2 + 1 : n2;
                return true;
            }
            if ((c = cArray[byArray[++n2] & 0xFF]) == '#') {
                int n4;
                int n5;
                if ((c = cArray[byArray[++n2] & 0xFF]) == 'x') {
                    n5 = c - ((c = cArray[byArray[++n2] & 0xFF]) < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                    while ((c = cArray[byArray[++n2] & 0xFF]) != ';') {
                        n4 = c - (c < 'A' ? 48 : (c < 'a' ? 65 : 97) - 10);
                        n5 = (n5 << 4) + n4;
                    }
                } else {
                    n5 = c - 48;
                    while (true) {
                        if ((c = cArray[byArray[++n2] & 0xFF]) == ';') {
                            ++n2;
                            break;
                        }
                        n4 = c - 48;
                        n5 = n5 * 10 + n4;
                    }
                }
                documentEntityState.attributeValueCharacter(n5, false);
                continue;
            }
            xMLString = documentEntityState.entityName;
            n3 = n2;
            while (c != ';') {
                c = cArray[byArray[++n2] & 0xFF];
            }
            xMLString.setValues(byArray, n3, n2, singleByteEncodingSupport);
            ++n2;
            SingleByteDocumentScanner.entityReferenceInAttValue(documentImplementationHandler, documentEntityState, (XMLName)xMLString);
        }
    }

    private static int scanComment(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        XMLString xMLString = documentEntityState.content;
        int n2 = n;
        char c = cArray[byArray[n] & 0xFF];
        while (c != '-' || cArray[byArray[n + 1] & 0xFF] != '-') {
            c = cArray[byArray[++n] & 0xFF];
        }
        xMLString.setValues(byArray, n2, n, parsedEntity.encoding);
        if (documentImplementationHandler != null) {
            documentImplementationHandler.comment(xMLString);
        }
        return n + 3;
    }

    private static int scanPI(DocumentEventHandler documentEventHandler, DocumentEntityState documentEntityState, ParsedEntity parsedEntity) {
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        XMLName xMLName = documentEntityState.target;
        XMLString xMLString = documentEntityState.content;
        int n2 = n;
        boolean bl = false;
        char c = cArray[byArray[n] & 0xFF];
        while ((c = cArray[byArray[++n] & 0xFF]) != '?') {
            if (c != ' ' && c != '\n' && c != '\t') continue;
            bl = true;
            break;
        }
        xMLName.setValues(byArray, n2, n, parsedEntity.encoding);
        if (bl) {
            while ((c = cArray[byArray[++n] & 0xFF]) == ' ' || c == '\n' || c == '\t') {
            }
            n2 = n;
            while (c != '?' || cArray[byArray[n + 1] & 0xFF] != '>') {
                c = cArray[byArray[++n] & 0xFF];
            }
        } else {
            n2 = n;
        }
        xMLString.setValues(byArray, n2, n, parsedEntity.encoding);
        documentEventHandler.processingInstruction(xMLName, xMLString);
        return n + 2;
    }

    private static int skipDoctypeDecl(ParsedEntity parsedEntity) {
        char c;
        SingleByteEncodingSupport singleByteEncodingSupport = (SingleByteEncodingSupport)parsedEntity.encoding;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        do {
            if ((c = cArray[byArray[++n] & 0xFF]) != '[') continue;
            while (true) {
                if ((c = cArray[byArray[++n] & 0xFF]) != ']') {
                    continue;
                }
                while ((c = cArray[byArray[++n] & 0xFF]) == ' ' || c == '\n' || c == '\t') {
                }
                if (c == '>') break;
            }
        } while (c != '>');
        return ++n;
    }

    private static boolean entityReferenceInContent(DocumentEventHandler documentEventHandler, DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, XMLName xMLName) {
        if (documentImplementationHandler != null) {
            return documentImplementationHandler.entityReferenceInContent(xMLName);
        }
        int n = documentEntityState.checkPredefinedEntities(xMLName);
        if (n != -1) {
            documentEventHandler.character(n, true);
            return true;
        }
        documentEntityState.undeclaredEntityInContent(xMLName);
        return false;
    }

    private static boolean entityReferenceInAttValue(DocumentImplementationHandler documentImplementationHandler, DocumentEntityState documentEntityState, XMLName xMLName) {
        if (documentImplementationHandler != null) {
            return documentImplementationHandler.entityReferenceInAttValue(xMLName);
        }
        int n = documentEntityState.checkPredefinedEntities(xMLName);
        if (n != -1) {
            documentEntityState.attributeValueCharacter(n, true);
            return true;
        }
        documentEntityState.undeclaredEntityInAttValue(xMLName);
        return false;
    }

    private SingleByteDocumentScanner() {
    }
}

