/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan;

import com.ibm.xml.b2b.scan.DocumentScannerSupport;
import com.ibm.xml.b2b.util.ErrorReporter;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public abstract class WFCDocumentScannerSupport
extends DocumentScannerSupport {
    private static final int USE_HASHTABLE_ATTR_COUNT = 16;
    private int[] fAttrHashtable;
    private int[] fNextAttrInBucket;
    private int fNSDeclNamespaceHandle;
    private ErrorReporter fErrors;
    private String[] fErrorArgs;
    private int fErrorArgsCount;

    public WFCDocumentScannerSupport(SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer, ErrorReporter errorReporter) {
        super(symbolTable, xMLStringBuffer);
        this.fNSDeclNamespaceHandle = this.fSymbolTable.addSymbol("http://www.w3.org/2000/xmlns/");
        this.fErrors = errorReporter;
        this.fErrorArgs = new String[8];
    }

    public void reset(boolean bl) {
        super.reset(bl);
        this.fNSDeclNamespaceHandle = this.fSymbolTable.addSymbol("http://www.w3.org/2000/xmlns/");
        this.fErrorArgsCount = 0;
    }

    protected void entityNotDeclared(XMLName xMLName) {
        Object[] objectArray = new String[]{xMLName.toString()};
        this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47, objectArray);
    }

    public void setParameter(int n, XMLString xMLString) {
        this.fErrorArgs[n] = xMLString.toString();
        if (n >= this.fErrorArgsCount) {
            this.fErrorArgsCount = n + 1;
        }
    }

    public void setInvalidCharParameter(int n, ParsedEntity parsedEntity) {
        int n2 = parsedEntity.decodeInvalidCharacter();
        this.fErrorArgs[n] = Integer.toHexString(n2);
        if (n >= this.fErrorArgsCount) {
            this.fErrorArgsCount = n + 1;
        }
    }

    public void reportWarning(String string, int n) {
        Object[] objectArray;
        if (this.fErrorArgsCount == 0) {
            objectArray = null;
        } else {
            objectArray = this.fErrorArgs;
            this.fErrorArgsCount = 0;
        }
        this.fErrors.reportWarning(string, n, objectArray);
    }

    public void reportRecoverableError(String string, int n) {
        Object[] objectArray;
        if (this.fErrorArgsCount == 0) {
            objectArray = null;
        } else {
            objectArray = this.fErrorArgs;
            this.fErrorArgsCount = 0;
        }
        this.fErrors.reportRecoverableError(string, n, objectArray);
    }

    public void reportFatalError(String string, int n) {
        Object[] objectArray;
        if (this.fErrorArgsCount == 0) {
            objectArray = null;
        } else {
            objectArray = this.fErrorArgs;
            this.fErrorArgsCount = 0;
        }
        this.fErrors.reportFatalError(string, n, objectArray);
    }

    private void checkDuplicateAttrs() {
        int n;
        String string;
        int n2 = this.firstMapping;
        while (n2 < this.lastMapping - 1) {
            string = this.prefixes[n2];
            n = n2 + 1;
            while (n < this.lastMapping) {
                if (this.prefixes[n] == string) {
                    this.duplicateAttribute(this.nsDeclQNames[n2]);
                }
                ++n;
            }
            ++n2;
        }
        if (this.attrCount < 16) {
            n2 = 0;
            while (n2 < this.attrCount - 1) {
                string = this.attrNames[n2].localPart;
                n = n2 + 1;
                while (n < this.attrCount) {
                    if (this.attrNames[n].localPart == string && this.attrNames[n].namespaceURI == this.attrNames[n2].namespaceURI) {
                        this.duplicateAttribute(this.attrNames[n].str);
                    }
                    ++n;
                }
                ++n2;
            }
        } else {
            int n3 = this.attrCount >> 4;
            int n4 = 1024;
            while (n4 < n3) {
                n4 <<= 1;
            }
            if (this.fAttrHashtable == null || n4 > this.fAttrHashtable.length) {
                this.fAttrHashtable = new int[n4];
            }
            n2 = 0;
            while (n2 < n4) {
                this.fAttrHashtable[n2] = -1;
                ++n2;
            }
            --n4;
            int n5 = this.attrNames.length;
            if (this.fNextAttrInBucket == null || n5 > this.fNextAttrInBucket.length) {
                this.fNextAttrInBucket = new int[n5];
            }
            n2 = 0;
            while (n2 < this.attrCount) {
                int n6 = this.attrNames[n2].localHandle;
                int n7 = this.attrNames[n2].nsHandle;
                int n8 = n6 + n7;
                int n9 = n8 & n4;
                int n10 = this.fAttrHashtable[n9];
                if (n10 >= 0) {
                    int n11 = n10;
                    while (n11 >= 0) {
                        if (this.attrNames[n11].localHandle == n6 && this.attrNames[n11].nsHandle == n7) {
                            this.duplicateAttribute(this.attrNames[n2].str);
                            return;
                        }
                        n11 = this.fNextAttrInBucket[n11];
                    }
                }
                this.fNextAttrInBucket[n2] = n10;
                this.fAttrHashtable[n9] = n2++;
            }
        }
    }

    public void resolveNamespaceURIs() {
        super.resolveNamespaceURIs();
        this.checkDuplicateAttrs();
    }

    protected void createPrefixMapping(String string, int n, String string2) {
        if (string != XMLString.EMPTY_STRING && n == 0) {
            this.namespaceNameEmpty(string);
        }
        if (string == this.fDefaultPrefix) {
            if (n != this.nsHandles[0]) {
                this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 51, null);
            }
        } else if (string == this.nsDeclPrefix) {
            this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 54, null);
        } else if (n == this.nsHandles[0] || n == this.fNSDeclNamespaceHandle) {
            this.illegalNamespaceURI(string, n);
        }
        super.createPrefixMapping(string, n, string2);
    }

    protected boolean setNamespaceURI(QName qName) {
        if (!super.setNamespaceURI(qName)) {
            this.undeclaredPrefix(qName.prefix);
        }
        return true;
    }

    protected void undeclaredPrefix(String string) {
        Object[] objectArray = new String[]{string};
        this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 50, objectArray);
    }

    private void namespaceNameEmpty(String string) {
        Object[] objectArray = new String[]{string};
        this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 52, objectArray);
    }

    private void illegalNamespaceURI(String string, int n) {
        Object[] objectArray = new String[]{string, this.fSymbolTable.toString(n)};
        this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 53, objectArray);
    }

    protected void duplicateAttribute(String string) {
        Object[] objectArray = new String[]{this.currentElement.str, string};
        this.fErrors.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 17, objectArray);
    }
}

