/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;
    private int c;
    private static final byte[] d = new byte[]{-67, 86, -22, -14, -94, -15, -84, 42, -80, -109, -47, -100, 27, 51, -3, -48, 48, 4, -74, -36, 125, -33, 50, 75, -9, -53, 69, -101, 49, -69, 33, 90, 65, -97, -31, -39, 74, 77, -98, -38, -96, 104, 44, -61, 39, 95, -128, 54, 62, -18, -5, -107, 26, -2, -50, -88, 52, -87, 19, -16, -90, 63, -40, 12, 120, 36, -81, 35, 82, -63, 103, 23, -11, 102, -112, -25, -24, 7, -72, 96, 72, -26, 30, 83, -13, -110, -92, 114, -116, 8, 21, 110, -122, 0, -124, -6, -12, 127, -118, 66, 25, -10, -37, -51, 20, -115, 80, 18, -70, 60, 6, 78, -20, -77, 53, 17, -95, -120, -114, 43, -108, -103, -73, 113, 116, -45, -28, -65, 58, -34, -106, 14, -68, 10, -19, 119, -4, 55, 107, 3, 121, -119, 98, -58, -41, -64, -46, 124, 106, -117, 34, -93, 91, 5, 93, 2, 117, -43, 97, -29, 24, -113, 85, 81, -83, 31, 11, 94, -123, -27, -62, 87, 99, -54, 61, 108, -76, -59, -52, 112, -78, -111, 89, 13, 71, 32, -56, 79, 88, -32, 1, -30, 22, 56, -60, 111, 59, 15, 101, 70, -66, 126, 45, 123, -126, -7, 64, -75, 29, 115, -8, -21, 38, -57, -121, -105, 37, 84, -79, 40, -86, -104, -99, -91, 100, 109, 122, -44, 16, -127, 68, -17, 73, -42, -82, 46, -35, 118, 92, 47, -89, 28, -55, 9, 105, -102, -125, -49, 41, 57, -71, -23, 76, -1, 67, -85};

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        int n2;
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException(RC2Parameters.a("\u0011$$\u007fu*%5}l9> /u98$b`,/7/v(/&fc1)${l7$"));
        }
        byte[] byArray = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        if (byArray != null) {
            if (byArray.length != 8) {
                throw new InvalidParameterSpecException(RC2Parameters.a("\u0011\u001ceaj,j}/g!> |%4%+h"));
            }
            this.a = (byte[])byArray.clone();
        }
        if ((n2 = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()) < 1 || n2 > 1024) {
            throw new InvalidParameterSpecException(RC2Parameters.a("\u001d,#jf,#3j%3/</v10 /l+j+`qx#+/q0/e}d6- /j>jt/(x{u=1x(,{vv"));
        }
        this.c = n2;
        this.b = n2 >= 256 ? n2 : this.a(n2);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        byte[] byArray2;
        block8: {
            byArray2 = null;
            try {
                DerValue derValue = new DerValue(byArray);
                if (derValue.getTag() == 4) {
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(RC2Parameters.a("\u0011\u001ce\u007fd*9,abx/7}j*pej},8$/a9>$"));
                    }
                    this.b = this.a(32);
                    this.c = 32;
                    break block8;
                }
                if (derValue.getTag() == 48) {
                    int n2 = derValue.getData().getInteger().intValue();
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(RC2Parameters.a("\n\tw/U98$b`,/7|%(+7|l6-ejw*%75%\u001d21}dx.${d"));
                    }
                    if (n2 < 1 || n2 > 1024) {
                        throw new IOException(RC2Parameters.a("\n\twY`*9,`kx#6/k7>efkx>-j%*++h`x%#/4xge>5j~k"));
                    }
                    this.c = n2 >= 256 ? n2 : this.b(n2);
                    this.b = n2;
                    break block8;
                }
                throw new IOException(RC2Parameters.a("\n\tw/U98$b`,/7|%(+7|l6-ejw*%75%,+\"/") + derValue.getTag() + RC2Parameters.a("x$*{%+?5\u007fj*> k"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(RC2Parameters.a("\n\twY`*9,`kx& ab,\"e{j7j'fb"));
            }
        }
        if (byArray2.length != 8) {
            throw new IOException(RC2Parameters.a("\u0011\u001ceaj,j}/g!> |%4%+h"));
        }
        this.a = byArray2;
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName(RC2Parameters.a("2+3n}v)7vu,%k|u=)k]Fj\u001a$}d5/1jw\u000b: l"));
            if (clazz2.isAssignableFrom(clazz)) {
                if (this.a == null) {
                    return new RC2ParameterSpec(this.c);
                }
                return new RC2ParameterSpec(this.c, this.a);
            }
            throw new InvalidParameterSpecException(RC2Parameters.a("\u0011$$\u007fu*%5}l9> /u98$b`,/7/v(/&fc1)${l7$"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(RC2Parameters.a("\r$6zu(%7{`<j5nw9' {`*j6\u007f`;##ff9>,`kbj") + classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.c == 32) {
            derOutputStream.putOctetString(this.a);
        } else {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.putOctetString(this.a);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = RC2Parameters.a("Rje/%\u0011\u001c\u007f\u0005^");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.a);
        string = string + "]";
        return RC2Parameters.a("\u001d,#jf,#3j%3/</g1>65\u000f") + BigInteger.valueOf(this.c).toString() + "\n" + string;
    }

    private int a(int n2) {
        byte by2 = d[n2];
        if (by2 >= 0) {
            return by2;
        }
        return by2 + 256;
    }

    private int b(int n2) throws IOException {
        int n3;
        for (n3 = 1; n3 < 256; ++n3) {
            int n4;
            int n5 = d[n3];
            int n6 = n4 = n5 >= 0 ? n5 : n5 + 256;
            if (n2 == n4) break;
        }
        if (n3 < 256) {
            return n3;
        }
        throw new IOException(RC2Parameters.a("\n\twY`*9,`kx)$ak7>em`x,*zk<j,a%,\" /q*++|i9>,`kx>$mi=d"));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 88;
                        break;
                    }
                    case 1: {
                        n5 = 74;
                        break;
                    }
                    case 2: {
                        n5 = 69;
                        break;
                    }
                    case 3: {
                        n5 = 15;
                        break;
                    }
                    default: {
                        n5 = 5;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

