/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
    static final String[] flagNames = new String[]{PKCS11TokenInfo.a("_yL"), PKCS11TokenInfo.a("ZeBhkRgYszHt_yj"), PKCS11TokenInfo.a("AxLu`ReNm{DeNx"), PKCS11TokenInfo.a("XdNnq]~EcgC~_uoA~Qyj"), PKCS11TokenInfo.a("HoHp{^~]yqHoBoz^"), PKCS11TokenInfo.a("_rXha_rTwkThEszRyNyjHs"), PKCS11TokenInfo.a("N{D\u007feRxEczB|Nr"), PKCS11TokenInfo.a("^b[la_cXc~LeJpbH{"), PKCS11TokenInfo.a("]eDhkNcNxqLb_tkCcB\u007foY~Drq]v_t"), PKCS11TokenInfo.a("IbJpqNeRlzBhDlk_v_uaCd"), PKCS11TokenInfo.a("Yx@y`R~EuzDvGutHs"), PKCS11TokenInfo.a("^rHs`IvYeqLb_tkCcB\u007foY~Dr"), PKCS11TokenInfo.a("XdNnq]~EcmBbEhqAx\\"), PKCS11TokenInfo.a("XdNnq]~EchDyJpqYeR"), PKCS11TokenInfo.a("XdNnq]~EcbBt@yj"), PKCS11TokenInfo.a("XdNnq]~EczBhIyqN\u007fJriHs"), PKCS11TokenInfo.a("^xTlgChHs{CcTpaZ"), PKCS11TokenInfo.a("^xTlgChMu`L{Th|T"), PKCS11TokenInfo.a("^xTlgChGsmFrO"), PKCS11TokenInfo.a("^xTlgCh_sqOrT\u007ffLyLyj")};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, String string5) {
        this.label = string;
        this.manufacturer = string2;
        this.model = string3;
        this.serialNumber = string4;
        this.flags = n2;
        this.maxSessionCount = n3;
        this.sessionCount = n4;
        this.maxRwSessionCount = n5;
        this.rwSessionCount = n6;
        this.maxPinLen = n7;
        this.minPinLen = n8;
        this.totalPublicMemory = n9;
        this.freePublicMemory = n10;
        this.totalPrivateMemory = n11;
        this.freePrivateMemory = n12;
        this.hardwareVersion = n13;
        this.firmwareVersion = n14;
        this.utcTime = string5;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return PKCS11TokenInfo.a("]|Ho\u001f<cdWKc~eZA7=+\u001c\u000e-{j^Ka\r+\u001c\u000e-\u0017+\u001c\u000e-\u0017+\u001c\u000e") + this.label + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e@VeIHlT\u007fI\\hE1\u001c\u000e-\u0017+\u001c") + this.manufacturer + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e@XoYB7\u0017+\u001c\u000e-\u0017+\u001c\u000e-\u0017+\u001c") + this.model + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e^RyUOa\r+\u001c\u000e-\u0017+\u001c\u000e-\u0017+\u001c") + this.serialNumber + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eK[j[]7\u0017+\u001c\u000e-\u0017+\u001c\u000e-\u0017+\u001c") + this.flagsToString(PKCS11TokenInfo.a("-K+")) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e@Vs\u001c]hDxUAcD1\u001c\u000e-\u0017+\u001c") + this.infinite(this.maxSessionCount) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e^RxOGbYx\u0006\u000e-\u0017+\u001c\u000e-\u0017+\u001c") + this.unavailable(this.sessionCount) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e@Vs\u001c|Z\u0017xY]~^dR]7\u0017+\u001c") + this.infinite(this.maxRwSessionCount) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e_`+OK~DbS@~\r+\u001c\u000e-\u0017+\u001c") + this.unavailable(this.rwSessionCount) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e@Vs\u001c~Dy+PKc\r+\u001c\u000e-\u0017+\u001c") + this.maxPinLen + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000e@^e\u001c~Dy+PKc\r+\u001c\u000e-\u0017+\u001c") + this.minPinLen + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eYX\u007f]B-G~^BdT+QK`\r+\u001c") + this.unavailable(this.totalPublicMemory) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eKEnY\u000e}BiPGn\u0017fYC7\u0017+\u001c") + this.unavailable(this.freePublicMemory) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eYX\u007f]B-GyUXlCn\u001cChZ1\u001c") + this.unavailable(this.totalPrivateMemory) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eKEnY\u000e}EbJOyR+QK`\r+\u001c") + this.unavailable(this.freePrivateMemory) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eEVyXYlEn\u001cXhExUAc\r+\u001c") + PKCS11.versionString(this.hardwareVersion) + PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eK^yQYlEn\u001cXhExUAc\r+\u001c") + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? PKCS11TokenInfo.a("\u0007\u0017+\u001c\u000eXcH\u001cZdZn\u0006\u000e-\u0017+\u001c\u000e-\u0017+\u001c") + this.utcTime : "");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    String infinite(int n2) {
        return n2 == 0 ? PKCS11TokenInfo.a("HqMymY~]ybThBrhDyBhk") : this.unavailable(n2);
    }

    String unavailable(int n2) {
        return n2 == -1 ? PKCS11TokenInfo.a("XyJjoD{J~bHhBrhBeF}zDxE") : Integer.toString(n2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 13;
                        break;
                    }
                    case 1: {
                        n5 = 55;
                        break;
                    }
                    case 2: {
                        n5 = 11;
                        break;
                    }
                    case 3: {
                        n5 = 60;
                        break;
                    }
                    default: {
                        n5 = 46;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

