/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;

final class Signature {
    private MessageDigest msgdig;
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private int mechanism;
    private int modSize = 256;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Signature";

    protected Signature(int n) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Signature", (Object)new Integer(n));
        }
        this.mechanism = n;
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Signature");
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)privateKey);
        }
        this.isSign = true;
        PrivateKey privateKey2 = privateKey;
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof DSAPrivateKey)) {
            if (privateKey instanceof java.security.interfaces.RSAPrivateKey || privateKey instanceof RSAPrivateCrtKey || privateKey instanceof java.security.interfaces.DSAPrivateKey) {
                KeyFactory keyFactory = null;
                String string = privateKey.getAlgorithm();
                try {
                    if (string.equalsIgnoreCase("DSA")) {
                        keyFactory = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                        privateKey2 = (PKCS11PrivateKey)keyFactory.translateKey(privateKey);
                    }
                    keyFactory = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                    privateKey2 = (PKCS11PrivateKey)keyFactory.translateKey(privateKey);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitSign_1", (Throwable)new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitSign");
                    }
                    throw new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + exception.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitSign_2", (Throwable)new InvalidKeyException("not a PKCS11 DSA or PKCS11 RSA private key"));
                    debug.exit(16384L, (Object)className, "engineInitSign");
                }
                throw new InvalidKeyException("not a DSA or RSA private key: " + privateKey);
            }
        }
        if (privateKey2 instanceof RSAPrivateKey) {
            this.keyObject = ((RSAPrivateKey)privateKey2).getObject();
            this.modSize = ((RSAPrivateKey)privateKey2).getModulus().bitLength() / 8 + 10;
        }
        if (privateKey2 instanceof DSAPrivateKey) {
            this.keyObject = ((DSAPrivateKey)privateKey2).getObject();
        }
        this.session.signInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)publicKey);
        }
        this.isSign = false;
        PublicKey publicKey2 = publicKey;
        if (!(publicKey instanceof RSAPublicKey) && !(publicKey instanceof DSAPublicKey)) {
            if (publicKey instanceof java.security.interfaces.RSAPublicKey || publicKey instanceof java.security.interfaces.DSAPublicKey) {
                KeyFactory keyFactory = null;
                String string = publicKey.getAlgorithm();
                try {
                    if (string.equalsIgnoreCase("DSA")) {
                        keyFactory = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                        publicKey2 = (PKCS11PublicKey)keyFactory.translateKey(publicKey);
                    }
                    keyFactory = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                    publicKey2 = (PKCS11PublicKey)keyFactory.translateKey(publicKey);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitVerify_1", (Throwable)new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + exception.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitVerify");
                    }
                    throw new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + exception.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitVerify_2", (Throwable)new InvalidKeyException("not a DSA or RSA public key"));
                    debug.exit(16384L, (Object)className, "engineInitVerify");
                }
                throw new InvalidKeyException("not a DSA or RSA public key: " + publicKey);
            }
        }
        if (publicKey2 instanceof RSAPublicKey) {
            this.keyObject = ((RSAPublicKey)publicKey2).getObject();
        }
        if (publicKey2 instanceof DSAPublicKey) {
            this.keyObject = ((DSAPublicKey)publicKey2).getObject();
        }
        this.session.verifyInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), new Integer(n2)};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
        }
        if (this.isSign) {
            this.session.signUpdate(byArray, n, n2);
        } else {
            this.session.verifyUpdate(byArray, n, n2);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = new byte[this.modSize];
        n = this.session.signFinal(byArray2, 0);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return byArray;
    }

    protected byte[] engineSign(byte[] byArray, int n) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign", (Object)byArray, (Object)new Integer(n));
        }
        int n2 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[this.modSize];
        n2 = this.session.sign(byArray, 0, n, byArray3, 0);
        byArray2 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray2, 0, n2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return byArray2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        boolean bl = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify", (Object)byArray);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        try {
            bl = this.session.verifyFinal(byArray, 0, byArray.length);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SignatureException("PKCS11 Exception : " + pKCS11Exception.getMessage());
        }
        return bl;
    }

    protected boolean engineVerify(byte[] byArray, byte[] byArray2, int n) throws SignatureException {
        boolean bl = false;
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, byArray2, new Integer(n)};
            debug.entry(16384L, (Object)className, "engineVerify", objectArray);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        try {
            bl = this.session.verify(byArray2, 0, n, byArray, 0, byArray.length);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new SignatureException("PKCS11 Exception : " + pKCS11Exception.getMessage());
        }
        return bl;
    }
}

