/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SHA1withDSA
extends SignatureSpi {
    private Signature sig = new Signature(18);

    protected void engineSetParameter(String string, Object object) {
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.sig.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.sig.engineUpdate(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.sig.engineSign();
        try {
            byte[] byArray2 = new byte[20];
            byte[] byArray3 = new byte[20];
            System.arraycopy(byArray, 0, byArray2, 0, 20);
            System.arraycopy(byArray, 20, byArray3, 0, 20);
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(new BigInteger(1, byArray2));
            derOutputStream.putInteger(new BigInteger(1, byArray3));
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[40];
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            byte[] byArray3 = derValueArray[0].getInteger().toByteArray();
            byte[] byArray4 = derValueArray[1].getInteger().toByteArray();
            int n = byArray3.length;
            if (n > 20) {
                System.arraycopy(byArray3, n - 20, byArray2, 0, 20);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 20 - n, n);
            }
            n = byArray4.length;
            if (n > 20) {
                System.arraycopy(byArray4, n - 20, byArray2, 20, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray2, 40 - n, n);
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature :" + iOException);
        }
        return this.sig.engineVerify(byArray2);
    }
}

