/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Session;
import java.security.DigestException;

final class Hash
implements Cloneable {
    private static final int MAX_HASH_LENGTH = 20;
    private byte[] digest;
    private byte[] buffer;
    private byte[] checksum;
    private byte[] mdBuffer;
    private int bufferIndex;
    private int bufferLeft;
    private int mechanism;
    private PKCS11Session session;
    private boolean initObject = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Hash";

    protected Hash(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Hash", (Object)("mechanism: " + n));
        }
        this.mechanism = n;
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Hash");
        }
    }

    private void init() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "init");
        }
        this.session = IBMPKCS11Impl.session;
        this.initObject = false;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "init");
        }
    }

    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineReset");
        }
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineReset");
        }
    }

    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n).toString(), new Integer(n2).toString()};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
        }
        if (!this.initObject) {
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        this.session.digestUpdate(byArray, n, n2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDigest");
        }
        if (!this.initObject) {
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        int n = 0;
        byte[] byArray = new byte[20];
        n = this.session.digestFinal(byArray, 0);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return byArray2;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n).toString(), new Integer(n2).toString()};
            debug.entry(16384L, (Object)className, "engineDigest", objectArray);
        }
        if (!this.initObject) {
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        int n3 = 0;
        byte[] byArray2 = new byte[20];
        n3 = this.session.digestFinal(byArray2, 0);
        if (n2 < n3) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDigest", "partial digests not returned");
            }
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n < n3) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDigest", "insufficient space in the output buffer to store the digest");
            }
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return n3;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "clone");
        }
        Hash hash = null;
        try {
            hash = (Hash)super.clone();
            hash.digest = (byte[])this.digest.clone();
            hash.buffer = (byte[])this.buffer.clone();
            hash.checksum = (byte[])this.checksum.clone();
            hash.mdBuffer = (byte[])this.mdBuffer.clone();
            hash.bufferIndex = this.bufferIndex;
            hash.bufferLeft = this.bufferLeft;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone");
            }
            return hash;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            block4: {
                if (debug == null) break block4;
                debug.exception(16384L, (Object)className, "clone", (Throwable)cloneNotSupportedException);
            }
            return hash;
        }
    }
}

