/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class DESedeCipher
extends CipherSpi {
    protected int cipherMode;
    private boolean decrypting = false;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    private byte[] iv = null;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private int mechanism;
    public static final int DES_BLOCK_SIZE = 8;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public DESedeCipher() {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.cipherMode = 0;
        this.mechanism = 306;
    }

    public DESedeCipher(String string, String string2) throws NoSuchAlgorithmException, NoSuchPaddingException {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        try {
            this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        this.engineSetMode(string);
        this.engineSetPadding(string2);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String string2 = string.toUpperCase();
        if (string2.equals("ECB")) {
            this.cipherMode = 0;
            this.mechanism = 306;
        } else if (string2.equals("CBC")) {
            this.cipherMode = 1;
            this.mechanism = 307;
        } else {
            throw new NoSuchAlgorithmException("Cipher mode: " + string + " not found");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (this.mechanism == 307) {
            if (string == null || string.equalsIgnoreCase("NoPadding")) {
                this.mechanism = 307;
                return;
            } else {
                if (!string.equalsIgnoreCase("Pad")) throw new NoSuchPaddingException("Padding: " + string + " can not be verified for use. " + "Use Pad instead.");
                this.mechanism = 310;
            }
            return;
        } else {
            if (string == null || string.equalsIgnoreCase("NoPadding")) return;
            throw new NoSuchPaddingException("No padding implemented for ECB mode");
        }
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected int engineGetOutputSize(int n) {
        throw new UnsupportedOperationException("This size can not be guaranteed.");
    }

    protected byte[] engineGetIV() {
        if (this.cipherMode == 0) {
            return null;
        }
        return this.iv;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        DESedeKey dESedeKey;
        if ((n == 2 || n == 4) && this.cipherMode != 0) {
            throw new InvalidKeyException("Parameters missing");
        }
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException("Key given is not a DESede key.");
        }
        if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                dESedeKey = (DESedeKey)secretKeyFactory.translateKey((SecretKey)key);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
            }
        } else {
            dESedeKey = (DESedeKey)key;
        }
        if (this.cipherMode == 1) {
            this.iv = new byte[8];
            secureRandom.nextBytes(this.iv);
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(n, dESedeKey.getObject(), this.iv, 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        DESedeKey dESedeKey;
        Object object;
        if ((n == 2 || n == 4) && this.cipherMode != 0 && algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!(key instanceof PKCS11SecretKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException("Key given is not a DESede key.");
        }
        if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                object = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                dESedeKey = (DESedeKey)((SecretKeyFactory)object).translateKey((SecretKey)key);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + exception.getMessage());
            }
        } else {
            dESedeKey = (DESedeKey)key;
        }
        if (this.cipherMode == 1) {
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
            } else if (secureRandom != null) {
                object = new byte[8];
                secureRandom.nextBytes((byte[])object);
            }
        }
        this.cipher = new PKCS11Cipher(this.mechanism);
        this.cipher.engineInit(n, dESedeKey.getObject(), this.iv, 8);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                ivParameterSpec = (IvParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = DESedeCipher.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(n, key, ivParameterSpec, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.cipher.engineUpdate(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.engineDoFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.cipher.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.cipherMode == 0) {
            return null;
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("DESede", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            algorithmParameters.init(ivParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("IvParameterSpec not supported");
        }
        return algorithmParameters;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof DESedeKey || key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW"))) {
            throw new InvalidKeyException();
        }
        return 168;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        int n = ((PKCS11Key)key).getObject().size() + 7;
        return this.cipher.engineWrap(((PKCS11Key)key).getObject(), n);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key = null;
        int[] nArray = null;
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[2];
        PKCS11Object pKCS11Object = null;
        switch (n) {
            case 3: {
                objectArray2 = ConstructKeys.constructSecretKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructSecretKey(pKCS11Object, string);
                break;
            }
            case 2: {
                objectArray2 = ConstructKeys.constructPrivateKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructPrivateKey(pKCS11Object, string);
                break;
            }
            case 1: {
                objectArray2 = ConstructKeys.constructPublicKeyAttrs(string);
                nArray = (int[])objectArray2[0];
                objectArray = (Object[])objectArray2[1];
                pKCS11Object = this.cipher.engineUnwrap(byArray, nArray, objectArray);
                key = ConstructKeys.constructPublicKey(pKCS11Object, string);
            }
        }
        return key;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

