/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;

public final class DESPKCS11KeyFactory
extends SecretKeyFactorySpi {
    private PKCS11Session session = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"despkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyFactory";
    static /* synthetic */ Class class$javax$crypto$spec$DESKeySpec;

    public DESPKCS11KeyFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DESPKCS11KeyFactory");
        }
        IBMPKCS11Impl.verifyJceJar();
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DESPKCS11KeyFactory");
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESKey dESKey;
        block11: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "engineGenerateSecret", (Object)keySpec);
            }
            dESKey = null;
            if (keySpec == null || !(keySpec instanceof DESKeySpec) && !(keySpec instanceof PKCS11KeySpec)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGenerateSecret", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGenerateSecret");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (!(keySpec instanceof PKCS11KeySpec)) {
                try {
                    PKCS11Object pKCS11Object = null;
                    byte[] byArray = null;
                    Boolean bl = Boolean.FALSE;
                    Boolean bl2 = Boolean.FALSE;
                    Boolean bl3 = Boolean.TRUE;
                    Boolean bl4 = Boolean.TRUE;
                    Boolean bl5 = Boolean.TRUE;
                    byte[] byArray2 = null;
                    DESKeySpec dESKeySpec = (DESKeySpec)keySpec;
                    byArray2 = dESKeySpec.getKey();
                    byArray = this.genID();
                    int[] nArray = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                    Object[] objectArray = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES, byArray, Boolean.TRUE, bl, bl2, bl3, new Boolean(bl3), bl4, new Boolean(bl4), byArray2};
                    pKCS11Object = this.session.createObject(nArray, objectArray);
                    dESKey = new DESKey(pKCS11Object, byArray, null, bl, bl2, bl3, bl4, bl5, byArray2);
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGenerateSecret", (Throwable)invalidKeyException);
                    }
                    break block11;
                }
            }
            PKCS11Object pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
            byte[] byArray = (byte[])this.getAttrValue(pKCS11Object, 258);
            String string = (String)this.getAttrValue(pKCS11Object, 3);
            Boolean bl = (Boolean)this.getAttrValue(pKCS11Object, 1);
            Boolean bl6 = (Boolean)this.getAttrValue(pKCS11Object, 259);
            Boolean bl7 = (Boolean)this.getAttrValue(pKCS11Object, 260);
            Boolean bl8 = (Boolean)this.getAttrValue(pKCS11Object, 262);
            Boolean bl9 = (Boolean)this.getAttrValue(pKCS11Object, 354);
            byte[] byArray3 = (byte[])this.getAttrValue(pKCS11Object, 17);
            if (debug != null) {
                System.out.println("ID = " + byArray);
                System.out.println("label = " + string);
                System.out.println("isToken = " + bl);
                System.out.println("isSensitive = " + bl6);
                System.out.println("encrypt = " + bl7);
                System.out.println("wrapping = " + bl8);
                System.out.println("extractable = " + bl9);
                System.out.println("value = " + byArray3);
            }
            try {
                dESKey = new DESKey(pKCS11Object, byArray, string, bl, bl6, bl7, bl8, bl9, byArray3);
            }
            catch (InvalidKeyException invalidKeyException) {
                if (debug == null) break block11;
                debug.exception(16384L, (Object)className, "engineGenerateSecret", (Throwable)invalidKeyException);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineGenerateSecret");
        }
        return dESKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)secretKey, (Object)clazz);
        }
        try {
            if (secretKey != null && secretKey instanceof PKCS11SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> clazz2 = Class.forName("javax.crypto.spec.DESKeySpec");
                if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                    if (((DESKey)secretKey).getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec_1", "Secret key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec_1");
                        }
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_2", (Object)"PKCS11SecretKey");
                    }
                    return new DESKeySpec(((DESKey)secretKey).getValue());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_3", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_3");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (secretKey != null && secretKey instanceof SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> clazz3 = Class.forName("javax.crypto.spec.DESKeySpec");
                if (clazz != null && clazz3.isAssignableFrom(clazz)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec_4", (Object)"SecretKey");
                    }
                    return new DESKeySpec(secretKey.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec_5", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec_5");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec_6", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGetKeySpec_6");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec_7", (Throwable)invalidKeyException);
                debug.exit(16384L, (Object)className, "engineGetKeySpec_7");
            }
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec_8", (Throwable)classNotFoundException);
                debug.exit(16384L, (Object)className, "engineGetKeySpec_8");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)secretKey);
        }
        try {
            if (secretKey != null && secretKey instanceof DESKey) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"PKCS11 DES KEY");
                }
                return secretKey;
            }
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("DES") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                DESKeySpec dESKeySpec = (DESKeySpec)this.engineGetKeySpec(secretKey, class$javax$crypto$spec$DESKeySpec == null ? (class$javax$crypto$spec$DESKeySpec = DESPKCS11KeyFactory.class$("javax.crypto.spec.DESKeySpec")) : class$javax$crypto$spec$DESKeySpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DES KEY");
                }
                return this.engineGenerateSecret(dESKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Inappropriate key format/algorithm");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)invalidKeySpecException);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        return byArray;
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

