/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.nio.Debug;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

abstract class SelectorImpl
extends AbstractSelector {
    protected static final Debug deregdebug = Debug.getInstance("deregister");
    protected Set selectedKeys;
    protected HashSet keys;
    private SelectGate selectGate = new SelectGate();

    protected SelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.selectedKeys = new HashSet();
        this.keys = new HashSet();
    }

    public Set keys() {
        return this.keys;
    }

    public Set selectedKeys() {
        return this.selectedKeys;
    }

    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int lockAndDoSelect(long l) throws IOException {
        SelectorImpl selectorImpl = this;
        // MONITORENTER : selectorImpl
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        Object object = this.selectGate;
        // MONITORENTER : object
        // MONITOREXIT : object
        object = this.keys;
        // MONITORENTER : object
        Set set = this.selectedKeys;
        // MONITORENTER : set
        // MONITOREXIT : set
        // MONITOREXIT : object
        // MONITOREXIT : selectorImpl
        return this.doSelect(l);
    }

    public int select(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        return this.lockAndDoSelect(l == 0L ? -1L : l);
    }

    public int select() throws IOException {
        return this.select(0L);
    }

    public int selectNow() throws IOException {
        return this.lockAndDoSelect(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implCloseSelector() throws IOException {
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            ((SelectionKey)iterator.next()).cancel();
        }
        SelectGate selectGate = this.selectGate;
        synchronized (selectGate) {
            this.wakeup();
            HashSet hashSet = this.keys;
            synchronized (hashSet) {
                Set set = this.selectedKeys;
                synchronized (set) {
                    this.implClose();
                }
            }
        }
    }

    protected abstract void implClose() throws IOException;

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        if (!(abstractSelectableChannel instanceof SelChImpl)) {
            throw new IllegalSelectorException();
        }
        SelectionKeyImpl selectionKeyImpl = new SelectionKeyImpl((SelChImpl)((Object)abstractSelectableChannel), this);
        selectionKeyImpl.attach(object);
        HashSet hashSet = this.keys;
        synchronized (hashSet) {
            this.implRegister(selectionKeyImpl);
        }
        selectionKeyImpl.interestOps(n);
        return selectionKeyImpl;
    }

    protected abstract void implRegister(SelectionKeyImpl var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDeregisterQueue() throws IOException {
        Set set;
        Set set2 = set = this.cancelledKeys();
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKeyImpl selectionKeyImpl = null;
                try {
                    selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    this.implDereg(selectionKeyImpl);
                    iterator.remove();
                    if (deregdebug == null) continue;
                    deregdebug.println("Deregistered key " + selectionKeyImpl);
                }
                catch (IOException iOException) {
                    if (deregdebug == null) continue;
                    deregdebug.println("Exception thrown while deregistering key " + selectionKeyImpl);
                    deregdebug.println("Key.interestOpts:" + selectionKeyImpl.interestOps());
                    deregdebug.println("Key.channel:" + selectionKeyImpl.channel());
                    deregdebug.println("Key.channel.blocking?:" + selectionKeyImpl.channel().isBlocking());
                    deregdebug.println("Key.selector:" + selectionKeyImpl.selector());
                    deregdebug.println("this.selector:" + this.toString());
                    deregdebug.printStackTrace(iOException);
                }
            }
        }
    }

    protected abstract void implDereg(SelectionKeyImpl var1) throws IOException;

    public abstract Selector wakeup();

    private static class SelectGate {
        private SelectGate() {
        }
    }
}

