/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import com.ibm.jvm.io.ASCIIPrintStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import sun.io.CharToByteConverter;
import sun.security.action.GetPropertyAction;

public class NetworkClient {
    protected Socket serverSocket = null;
    public PrintStream serverOutput;
    public InputStream serverInput;
    protected static int defaultSoTimeout;
    protected static int defaultConnectTimeout;
    protected static String encoding;

    private static boolean isASCIISuperset(String string) throws Exception {
        String string2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] byArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        CharToByteConverter charToByteConverter = CharToByteConverter.getConverter(string);
        byte[] byArray2 = charToByteConverter.convertAll(string2.toCharArray());
        return Arrays.equals(byArray2, byArray);
    }

    public void openServer(String string, int n) throws IOException, UnknownHostException {
        if (this.serverSocket != null) {
            this.closeServer();
        }
        this.serverSocket = this.doConnect(string, n);
        try {
            this.serverOutput = new ASCIIPrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + "encoding not found");
        }
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        Socket socket = new Socket();
        if (defaultConnectTimeout > 0) {
            socket.connect(new InetSocketAddress(string, n), defaultConnectTimeout);
        } else {
            socket.connect(new InetSocketAddress(string, n));
        }
        if (defaultSoTimeout > 0) {
            socket.setSoTimeout(defaultSoTimeout);
        }
        return socket;
    }

    protected InetAddress getLocalAddress() throws IOException {
        if (this.serverSocket == null) {
            throw new IOException("not connected");
        }
        return this.serverSocket.getLocalAddress();
    }

    public void closeServer() throws IOException {
        if (!this.serverIsOpen()) {
            return;
        }
        this.serverSocket.close();
        this.serverSocket = null;
        this.serverInput = null;
        this.serverOutput = null;
    }

    public boolean serverIsOpen() {
        return this.serverSocket != null;
    }

    public NetworkClient(String string, int n) throws IOException {
        this.openServer(string, n);
    }

    public NetworkClient() {
    }

    static {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("sun.net.client.defaultReadTimeout");
            }
        });
        defaultSoTimeout = n == null ? -1 : n;
        n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("sun.net.client.defaultConnectTimeout");
            }
        });
        defaultConnectTimeout = n == null ? -1 : n;
        encoding = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding", "ISO8859_1"));
        try {
            if (!NetworkClient.isASCIISuperset(encoding)) {
                encoding = "ISO8859_1";
            }
        }
        catch (Exception exception) {
            encoding = "ISO8859_1";
        }
    }
}

