/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlSupport {
    private static final String PREFS_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    private static final String PREFS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT preferences (root) ><!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\"  ><!ELEMENT root (map, node*) ><!ATTLIST root          type (system|user) #REQUIRED ><!ELEMENT node (map, node*) ><!ATTLIST node          name CDATA #REQUIRED ><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private static final String MAP_XML_VERSION = "1.0";

    XmlSupport() {
    }

    static void export(OutputStream outputStream, Preferences preferences, boolean bl) throws IOException, BackingStoreException {
        if (((AbstractPreferences)preferences).isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        coreDocumentImpl.appendChild((Node)coreDocumentImpl.createDocumentType("preferences", null, PREFS_DTD_URI));
        Element element = (Element)coreDocumentImpl.appendChild((Node)coreDocumentImpl.createElement("preferences"));
        element.setAttribute("EXTERNAL_XML_VERSION", "1.0");
        Element element2 = (Element)element.appendChild(coreDocumentImpl.createElement("root"));
        element2.setAttribute("type", preferences.isUserNode() ? "user" : "system");
        ArrayList arrayList = new ArrayList();
        Object object = preferences;
        Preferences preferences2 = ((Preferences)object).parent();
        while (preferences2 != null) {
            arrayList.add(object);
            object = preferences2;
            preferences2 = ((Preferences)object).parent();
        }
        object = element2;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            object.appendChild(coreDocumentImpl.createElement("map"));
            object = (Element)object.appendChild(coreDocumentImpl.createElement("node"));
            object.setAttribute("name", ((Preferences)arrayList.get(i)).name());
        }
        XmlSupport.putPreferencesInXml((Element)object, (Document)coreDocumentImpl, preferences, bl);
        XmlSupport.writeXMLPreferences(coreDocumentImpl, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putPreferencesInXml(Element element, Document document, Preferences preferences, boolean bl) throws BackingStoreException {
        Object object;
        Preferences[] preferencesArray = null;
        String[] stringArray = null;
        Object object2 = ((AbstractPreferences)preferences).lock;
        synchronized (object2) {
            int n;
            if (((AbstractPreferences)preferences).isRemoved()) {
                element.getParentNode().removeChild(element);
                return;
            }
            object = preferences.keys();
            Element element2 = (Element)element.appendChild(document.createElement("map"));
            for (n = 0; n < ((String[])object).length; ++n) {
                Element element3 = (Element)element2.appendChild(document.createElement("entry"));
                element3.setAttribute("key", object[n]);
                element3.setAttribute("value", preferences.get(object[n], null));
            }
            if (bl) {
                stringArray = preferences.childrenNames();
                preferencesArray = new Preferences[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    preferencesArray[n] = preferences.node(stringArray[n]);
                }
            }
        }
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = (Element)element.appendChild(document.createElement("node"));
                object.setAttribute("name", stringArray[i]);
                XmlSupport.putPreferencesInXml((Element)object, document, preferencesArray[i], bl);
            }
        }
    }

    static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        try {
            Object object;
            Object var1_1 = null;
            String string = null;
            Document document = XmlSupport.load(inputStream);
            if (document instanceof DeferredDocumentImpl) {
                object = (DeferredDocumentImpl)document;
                string = object.getXmlVersion();
            }
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Exported preferences file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            object = (Element)document.getChildNodes().item(1).getChildNodes().item(0);
            Preferences preferences = object.getAttribute("type").equals("user") ? Preferences.userRoot() : Preferences.systemRoot();
            XmlSupport.ImportSubtree(preferences, (Element)object);
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static Document load(InputStream inputStream) throws SAXException, IOException {
        Resolver resolver = new Resolver();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new Resolver());
            documentBuilder.setErrorHandler(new EH());
            return documentBuilder.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
            throw new Error(parserConfigurationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ImportSubtree(Preferences preferences, Element element) {
        Preferences[] preferencesArray;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        Object object = ((AbstractPreferences)preferences).lock;
        synchronized (object) {
            if (((AbstractPreferences)preferences).isRemoved()) {
                return;
            }
            Element element2 = (Element)nodeList.item(0);
            XmlSupport.ImportPrefs(preferences, element2);
            preferencesArray = new Preferences[n - 1];
            for (int i = 1; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                preferencesArray[i - 1] = preferences.node(element3.getAttribute("name"));
            }
        }
        for (int i = 1; i < n; ++i) {
            XmlSupport.ImportSubtree(preferencesArray[i - 1], (Element)nodeList.item(i));
        }
    }

    private static void ImportPrefs(Preferences preferences, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            preferences.put(element2.getAttribute("key"), element2.getAttribute("value"));
        }
    }

    static void exportMap(OutputStream outputStream, Map map) throws IOException {
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        coreDocumentImpl.appendChild((Node)coreDocumentImpl.createDocumentType("map", null, PREFS_DTD_URI));
        Element element = (Element)coreDocumentImpl.appendChild((Node)coreDocumentImpl.createElement("map"));
        element.setAttribute("MAP_XML_VERSION", "1.0");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Element element2 = (Element)element.appendChild(coreDocumentImpl.createElement("entry"));
            element2.setAttribute("key", (String)entry.getKey());
            element2.setAttribute("value", (String)entry.getValue());
        }
        XmlSupport.writeXMLPreferences(coreDocumentImpl, outputStream);
    }

    static void importMap(InputStream inputStream, Map map) throws IOException, InvalidPreferencesFormatException {
        try {
            Object object;
            String string = null;
            Document document = XmlSupport.load(inputStream);
            Element element = (Element)document.getChildNodes().item(1);
            if (document instanceof DeferredDocumentImpl) {
                object = (DeferredDocumentImpl)document;
                string = object.getXmlVersion();
            }
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Preferences map file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            object = element.getChildNodes();
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)object.item(i);
                map.put(element2.getAttribute("key"), element2.getAttribute("value"));
            }
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static void writeXMLPreferences(CoreDocumentImpl coreDocumentImpl, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println();
        int n = coreDocumentImpl.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            XmlSupport.writeXMLNode(coreDocumentImpl.item(i), printWriter, 0);
            printWriter.println();
            printWriter.flush();
        }
    }

    private static void writeXMLNode(Node node, PrintWriter printWriter, int n) {
        int n2;
        int n3 = n;
        if (node == null) {
            return;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            printWriter.print(' ');
        }
        n2 = node.getNodeType();
        switch (n2) {
            case 10: {
                DocumentType documentType = (DocumentType)node;
                printWriter.print("<!DOCTYPE ");
                printWriter.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    printWriter.print(" PUBLIC '");
                    printWriter.print(string);
                    printWriter.print("' '");
                    printWriter.print(string2);
                    printWriter.print('\'');
                } else {
                    printWriter.print(" SYSTEM '");
                    printWriter.print(string2);
                    printWriter.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    printWriter.println(" [");
                    printWriter.print(string3);
                    printWriter.print(']');
                }
                printWriter.println('>');
                break;
            }
            case 1: {
                printWriter.print('<');
                printWriter.print(node.getNodeName());
                Attr[] attrArray = XmlSupport.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    printWriter.print(' ');
                    printWriter.print(attr.getNodeName());
                    printWriter.print("=\"");
                    XmlSupport.normalizeAndPrint(attr.getNodeValue(), printWriter);
                    printWriter.print('\"');
                }
                Node node2 = node.getFirstChild();
                if (node2 != null) {
                    printWriter.print('>');
                    printWriter.println();
                    while (node2 != null) {
                        XmlSupport.writeXMLNode(node2, printWriter, n3 + 2);
                        node2 = node2.getNextSibling();
                    }
                    for (int i = 0; i < n3; ++i) {
                        printWriter.print(' ');
                    }
                    printWriter.print("</");
                    printWriter.print(node.getNodeName());
                    printWriter.println('>');
                } else {
                    printWriter.println(" />");
                }
                printWriter.flush();
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                printWriter.flush();
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                printWriter.flush();
                break;
            }
            case 3: {
                XmlSupport.normalizeAndPrint(node.getNodeValue(), printWriter);
                printWriter.flush();
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
                printWriter.flush();
            }
        }
    }

    protected static void normalizeAndPrint(String string, PrintWriter printWriter) {
        int n = string != null ? string.length() : 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            XmlSupport.normalizeAndPrint(c, printWriter);
        }
    }

    protected static void normalizeAndPrint(char c, PrintWriter printWriter) {
        switch (c) {
            case '<': {
                printWriter.print("&lt;");
                break;
            }
            case '>': {
                printWriter.print("&gt;");
                break;
            }
            case '&': {
                printWriter.print("&amp;");
                break;
            }
            case '\"': {
                printWriter.print("&quot;");
                break;
            }
            default: {
                printWriter.print(c);
            }
        }
    }

    private static Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.equals(XmlSupport.PREFS_DTD_URI)) {
                InputSource inputSource = new InputSource(new StringReader(XmlSupport.PREFS_DTD));
                inputSource.setSystemId(XmlSupport.PREFS_DTD_URI);
                return inputSource;
            }
            throw new SAXException("Invalid system identifier: " + string2);
        }
    }
}

