/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.jvm.ExtendedSystem;

final class CompactStringArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int DEBUGSHOWOVERLAPLIMIT = 100;
    private static final boolean DEBUGTRACE = false;
    private static final boolean DEBUGSMALL = false;
    private static final boolean DEBUGOVERLAP = false;
    private static final int DEBUGSMALLLIMIT = 30000;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private char[] values;
    private short[] indices;
    private StringBuffer exceptions = new StringBuffer();
    private boolean isCompact;

    public CompactStringArray() {
        this("");
    }

    public CompactStringArray(String string) {
        this.values = new char[65536];
        this.indices = new short[512];
        this.setElementAt('\u0000', '\uffff', string);
        for (int i = 0; i < 512; ++i) {
            this.indices[i] = (short)(i << 7);
        }
        this.isCompact = false;
    }

    public CompactStringArray(short[] sArray, char[] cArray, String string) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i = 0; i < 512; ++i) {
            short s = sArray[i];
            if (s >= 0 && s < cArray.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = sArray;
        this.values = cArray;
    }

    public void elementAt(char c, StringBuffer stringBuffer) {
        char c2 = this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
        if (c2 >= '\ue000' && c2 <= '\uf800') {
            int n = c2 - 57344;
            while (true) {
                if ((c2 = this.exceptions.charAt(n)) == '\uffff') {
                    return;
                }
                stringBuffer.append(c2);
                ++n;
            }
        }
        stringBuffer.append(c2);
    }

    public String elementAt(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        this.elementAt(c, stringBuffer);
        return stringBuffer.toString();
    }

    public void setElementAt(char c, String string) {
        char c2;
        if (this.isCompact) {
            this.expand();
        }
        if (string.length() == 1 && ((c2 = string.charAt(0)) < '\ue000' || c2 >= '\uf800')) {
            this.values[c] = c2;
            return;
        }
        String string2 = string + '\uffff';
        int n = this.exceptions.toString().indexOf(string2);
        if (n != -1) {
            this.values[c] = (char)(57344 + n);
            return;
        }
        this.values[c] = (char)(57344 + this.exceptions.length());
        for (int i = 0; i < string.length(); ++i) {
            this.exceptions.append(string.charAt(i));
        }
        this.exceptions.append('\uffff');
    }

    public void setElementAt(char c, char c2, String string) {
        if (c >= c2) {
            return;
        }
        this.setElementAt(c, string);
        char c3 = this.values[c];
        for (int i = c + '\u0001'; i <= c2; ++i) {
            this.values[i] = c3;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n;
            char[] cArray = new char[65536];
            int n2 = 128;
            for (n = 0; n < 128; n = (int)((short)(n + 1))) {
                cArray[n] = (char)n;
            }
            this.indices[0] = 0;
            for (int n3 = 1; n3 < 512; n3 = (int)((short)(n3 + 1))) {
                int n4 = n3 << 7;
                int n5 = this.FindOverlappingPosition(n4, cArray, n2);
                int n6 = n5 + 128;
                if (n6 > n2) {
                    for (n = (int)((short)n2); n < n6; n = (int)((short)(n + 1))) {
                        cArray[n] = (char)(n - n5 + n4);
                    }
                    n2 = n6;
                }
                this.indices[n3] = (short)n5;
            }
            char[] cArray2 = (char[])ExtendedSystem.newArray(Character.TYPE, n2, this);
            for (n = 0; n < n2; n = (int)((short)(n + 1))) {
                cArray2[n] = this.values[cArray[n]];
            }
            this.values = null;
            this.values = cArray2;
            this.isCompact = true;
        }
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactStringArray compactStringArray = (CompactStringArray)super.clone();
            compactStringArray.values = (char[])this.values.clone();
            compactStringArray.indices = (short[])this.indices.clone();
            compactStringArray.exceptions = new StringBuffer(this.exceptions.toString());
            return compactStringArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactStringArray compactStringArray = (CompactStringArray)object;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactStringArray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        for (int i = 0; i < this.values.length; i += n2) {
            n = n * 37 + this.values[i];
        }
        return n;
    }

    void writeArrays() {
        int n;
        int n2 = 0;
        n2 = this.values.length > 0 ? this.values.length : this.values.length + 65536;
        System.out.println("{");
        for (n = 0; n < 511; ++n) {
            System.out.print("(short)" + (this.getIndexArrayValue(n) >= 0 ? this.getIndexArrayValue(n) : this.getIndexArrayValue(n) + 65536) + ", ");
            if (n == 0 || n % 10 != 0) continue;
            System.out.println();
        }
        System.out.println("(char)" + (this.getIndexArrayValue(511) >= 0 ? this.getIndexArrayValue(n) : this.getIndexArrayValue(n) + 65536) + " }");
        System.out.println("{");
        for (n = 0; n < n2 - 1; ++n) {
            char c = this.getArrayValue(n);
            if (c < ' ' || c > '~' && c < '\u00a0' || c > '\u0100') {
                System.out.print("(char)0x" + Integer.toString(c, 16).toUpperCase() + ",");
            } else {
                System.out.print("'" + c + "',");
            }
            if (n == 0 || n % 10 != 0) continue;
            System.out.println();
        }
        System.out.println("(char)" + this.getArrayValue(n2 - 1) + " }");
        System.out.println("\"" + this.exceptions.toString() + "\"");
    }

    void printIndex(char n, short s) {
        for (int i = n; i < s; ++i) {
            System.out.println(i + " -> : " + (this.indices[i] >= 0 ? this.indices[i] : this.indices[i] + 65536));
        }
        System.out.println();
    }

    void printPlainArray(int n, int n2, char[] cArray) {
        if (cArray != null) {
            for (int i = n; i < n + n2; ++i) {
                System.out.print(" " + this.getArrayValue(cArray[i]));
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                System.out.print(" " + this.getArrayValue(i));
            }
        }
        System.out.println("    Range: start " + n + " , count " + n2);
    }

    private void expand() {
        if (this.isCompact) {
            int n;
            char[] cArray = (char[])ExtendedSystem.newArray(Character.TYPE, 65536, this);
            for (n = 0; n < 65536; ++n) {
                cArray[n] = this.values[(this.indices[n >> 7] & 0xFFFF) + (n & 0x7F)];
            }
            for (n = 0; n < 512; ++n) {
                this.indices[n] = (short)(n << 7);
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private short capacity() {
        return (short)this.values.length;
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    private short getIndexArrayValue(int n) {
        return this.indices[n];
    }

    private int FindOverlappingPosition(int n, char[] cArray, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; n3 += 128) {
            int n4;
            int n5 = 128;
            if (n3 + 128 > n2) {
                n5 = (short)(n2 - n3);
            }
            for (n4 = 0; n4 < n5 && this.values[n + n4] == this.values[cArray[n3 + n4]]; n4 = (int)((short)(n4 + 1))) {
            }
            if (n4 == n5) break;
        }
        return n3;
    }
}

