/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Hashtable;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private boolean initialized = false;
    private Hashtable pdcache = new Hashtable(11);
    private static final Debug debug = Debug.getInstance("scl");
    private Hashtable buffer2codesource = new Hashtable(11);

    protected SecureClassLoader(ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected SecureClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.initialized = true;
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        if (codeSource == null) {
            return this.defineClass(string, byArray, n, n2);
        }
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        this.check();
        return new Permissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inflateMirroredProtectionDomain(Class clazz, byte[] byArray) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            Object object;
            CodeSource codeSource = (CodeSource)this.buffer2codesource.get(byArray);
            if (codeSource == null) {
                try {
                    object = new ObjectInputStream(new ByteArrayInputStream(byArray));
                    codeSource = (CodeSource)((ObjectInputStream)object).readObject();
                    this.buffer2codesource.put(byArray, codeSource);
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object = codeSource.getCertificates();
            ProtectionDomain protectionDomain = this.getProtectionDomain(codeSource);
            this.setMirroredProtectionDomains(clazz, protectionDomain, (Object[])object);
        }
    }

    private native void setMirroredProtectionDomains(Class var1, ProtectionDomain var2, Object[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = null;
        Hashtable hashtable = this.pdcache;
        synchronized (hashtable) {
            PermissionCollection permissionCollection;
            protectionDomain = (ProtectionDomain)this.pdcache.get(codeSource);
            if (protectionDomain == null && (protectionDomain = new ProtectionDomain(codeSource, permissionCollection = this.getPermissions(codeSource), this, null)) != null) {
                this.pdcache.put(codeSource, protectionDomain);
                if (debug != null) {
                    debug.println(" getPermissions " + protectionDomain);
                    debug.println("");
                }
            }
        }
        return protectionDomain;
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    private void copyFrom(ClassLoader classLoader) {
        SecureClassLoader secureClassLoader = (SecureClassLoader)classLoader;
        this.pdcache = secureClassLoader.pdcache;
        this.buffer2codesource = secureClassLoader.buffer2codesource;
        secureClassLoader.pdcache = null;
        secureClassLoader.buffer2codesource = null;
        secureClassLoader.initialized = false;
    }
}

