/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sun.security.util.Debug;

public abstract class Provider
extends Properties {
    private static final Debug debug = Debug.getInstance("jca", "Provider");
    private String name;
    private String info;
    private double version;
    private transient Set entrySet = null;
    private transient int entrySetCallCount = 0;
    static final long serialVersionUID = -4298000515446427739L;

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }

    Provider(String string) {
        this(string, 1.0, "no information available");
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    static Provider loadProvider(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        Object object = clazz.newInstance();
        if (object instanceof Provider) {
            if (debug != null) {
                debug.println("Loaded provider " + string);
            }
            return (Provider)object;
        }
        if (debug != null) {
            debug.println(string + " is not a provider");
        }
        return null;
    }

    public String toString() {
        return this.name + " version " + this.version;
    }

    public synchronized void clear() {
        Provider.check("clearProviderProperties." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider properties");
        }
        super.clear();
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        Provider.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Load " + this.name + " provider properties");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        this.putAllInternal(properties);
    }

    public synchronized void putAll(Map map) {
        Provider.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Put all " + this.name + " provider properties");
        }
        this.putAllInternal(map);
    }

    private void putAllInternal(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            super.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized Set entrySet() {
        if (this.entrySet == null) {
            if (this.entrySetCallCount++ == 0) {
                this.entrySet = Collections.unmodifiableMap(this).entrySet();
            } else {
                return super.entrySet();
            }
        }
        if (this.entrySetCallCount != 2) {
            throw new RuntimeException("Internal error.");
        }
        return this.entrySet;
    }

    public Set keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(super.values());
    }

    public synchronized Object put(Object object, Object object2) {
        Provider.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Set " + this.name + " provider property [" + object + "/" + object2 + "]");
        }
        return super.put(object, object2);
    }

    public synchronized Object remove(Object object) {
        Provider.check("removeProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider property " + object);
        }
        return super.remove(object);
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }
}

