/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.oldformat;

import com.ibm.jvm.oldformat.ExternalTraceBuffer;
import com.ibm.jvm.oldformat.SpannedTraceEntry;
import com.ibm.jvm.oldformat.TraceBufferHeader;
import com.ibm.jvm.oldformat.TraceEntry;
import com.ibm.jvm.oldformat.TraceEntryFactory;
import com.ibm.jvm.oldformat.TraceEntryList;
import com.ibm.jvm.oldformat.Util;
import java.math.BigInteger;

public class TraceBuffer {
    protected TraceBufferHeader bufferHeader;
    protected byte[] buffer;
    protected int initialEntryOffset;
    protected TraceEntryFactory factory;
    protected static int traceType;
    protected int hack;

    protected static final TraceBuffer newBuffer(byte[] byArray) {
        if (Util.getProperty("TRACE_TYPE", "INTERNAL").equals("INTERNAL")) {
            Util.Debug.println("traceType = " + Util.getProperty("TRACE_TYPE"));
            traceType = 0;
            return new TraceBuffer(byArray);
        }
        Util.Debug.println("traceType = " + Util.getProperty("TRACE_TYPE"));
        traceType = 1;
        return new ExternalTraceBuffer(byArray);
    }

    protected TraceBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.factory = new TraceEntryFactory();
        byte[] byArray2 = new byte[TraceBufferHeader.HEADER_LENGTH];
        System.arraycopy(byArray, 0, byArray2, 0, TraceBufferHeader.HEADER_LENGTH);
        this.bufferHeader = new TraceBufferHeader(byArray2);
        this.initialEntryOffset = (int)this.bufferHeader.getNextEntryOffset();
    }

    protected final TraceEntryList readEntries(int n) {
        try {
            Util.Debug.println("TraceBuffer: readEntries() - enter");
            TraceEntryFactory.setInitialOffset(n);
            TraceEntryFactory.setUpperWord(this.bufferHeader.getUpperWordOfTimeStamp());
            TraceEntryFactory.setWrapTime(this.bufferHeader.getWrapTime());
            TraceEntryFactory.setPassedOnce(false);
            TraceEntry traceEntry = this.factory.readEntry(this.buffer, n, this.bufferHeader.getThreadID());
            TraceEntryList traceEntryList = new TraceEntryList();
            traceEntryList.add(traceEntry);
            while (traceEntry != null && !(traceEntry instanceof SpannedTraceEntry) && traceEntry.getNextLength() != 0L) {
                if ((traceEntry = this.factory.readEntry(this.buffer, (int)traceEntry.getNextOffset(), this.bufferHeader.getThreadID())) == null) continue;
                traceEntryList.addFirst(traceEntry);
            }
            Util.Debug.println("TraceBuffer: readEntries() - exit");
            return traceEntryList;
        }
        catch (Exception exception) {
            System.out.println("TraceBuffer.readEntries() " + exception);
            return null;
        }
    }

    protected final BigInteger getLatestTimeStamp() {
        return this.bufferHeader.getLastTimeStamp();
    }

    protected final int getOffsetToFirstEntry() {
        return this.initialEntryOffset;
    }

    protected final TraceBufferHeader getHeader() {
        return this.bufferHeader;
    }

    public final String toString() {
        return "TraceBuffer, type = " + traceType + ", header = " + this.bufferHeader + " offset was " + this.hack;
    }
}

