/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.oldformat;

import com.ibm.jvm.oldformat.TraceBuffer;
import com.ibm.jvm.oldformat.TraceFile;
import com.ibm.jvm.oldformat.TraceFormat;
import com.ibm.jvm.oldformat.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public final class MultiTraceFile
extends TraceFile {
    private static final int RADIX = 36;
    private Vector fileBuffers = new Vector(36);
    private int newest = 0;
    private BigInteger bigTime = BigInteger.ZERO;

    public MultiTraceFile(String string, int n) throws Exception {
        int n2 = 0;
        char c = Integer.toString(n2, 36).toUpperCase().charAt(0);
        File file = new File(string.replace('#', c));
        this.fileBuffers.addElement(this.readFile(file));
        int n3 = this.getGenerations((byte[])this.fileBuffers.elementAt(0));
        int n4 = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            c = Integer.toString(n2, 36).toUpperCase().charAt(0);
            try {
                file = new File(string.replace('#', c));
                this.fileBuffers.addElement(this.readFile(file));
                if (n4 == 0) continue;
                System.out.println("Trace file " + string.replace('#', c) + " is missing");
                System.exit(-3);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (n4 != 0) continue;
                n4 = n2;
            }
        }
        System.out.println("Processing " + (n4 > 0 ? Integer.toString(n4) : "all") + " of the " + n3 + " generations specified at runtime");
    }

    private int getGenerations(byte[] byArray) {
        this.header = this.createHeader(byArray);
        String string = Util.getProperty("GENERATIONS", "0");
        return Integer.parseInt(string);
    }

    protected Vector readData() {
        Vector vector = new Vector(36);
        Vector vector2 = null;
        int n = Integer.MAX_VALUE;
        TraceBuffer traceBuffer = null;
        for (int i = 0; i < this.fileBuffers.size(); ++i) {
            byte[] byArray = (byte[])this.fileBuffers.elementAt(i);
            int n2 = byArray.length;
            this.header = this.createHeader(byArray);
            vector2 = this.readTraceBuffers(this.header, byArray);
            traceBuffer = (TraceBuffer)vector2.elementAt(0);
            BigInteger bigInteger = (double)TraceFormat.verMod >= 1.1 ? traceBuffer.bufferHeader.getWritePlatform() : traceBuffer.getLatestTimeStamp();
            System.out.println("Time of last record written for generation " + i + " is " + Util.getFormattedTime(bigInteger));
            if (bigInteger.compareTo(this.bigTime) > 0) {
                this.bigTime = bigInteger;
                this.newest = 0;
            } else {
                ++this.newest;
            }
            vector.add(0, vector2);
        }
        return vector;
    }

    protected void processData(Vector vector) {
        int n = this.findNewestFile(vector);
        for (int i = 0; i < vector.size(); ++i) {
            Object[] objectArray = ((Vector)vector.elementAt(n)).toArray();
            int n2 = this.findNewest(objectArray);
            this.readEntriesFromBuffers(objectArray, n2);
            n = (n + 1) % vector.size();
        }
    }

    protected void computeSummary(Vector vector) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            super.computeSummary((Vector)vector.elementAt(i));
        }
    }

    protected final int findNewest(Object[] objectArray) {
        return 0;
    }

    protected final int findNewestFile(Vector vector) {
        return this.newest;
    }
}

