/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.converters;

import com.ibm.converters.UnsignedMath;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Decimal {
    public static final int PACKED_DECIMAL = 48;
    public static final int ZONED_DECIMAL = 51;
    public static final int COBOL2_ZONED_DECIMAL = 53;
    public static final int NUMERIC_CHARACTER = 50;
    private static final long TenToThe9th = 1000000000L;
    private static final long TenToThe18th = 1000000000000000000L;
    private static final int TenToThe18thHigh = 232830643;
    private static final int TenToThe18thLow = -1486618624;
    private static final byte[] TenToThe27th = new byte[]{3, 59, 46, 60, -97, -48, -128, 60, -24, 0, 0, 0};
    private static final int TenToThe27thHigh = UnsignedMath.convert(TenToThe27th, 0);
    private static final int TenToThe27thMed = UnsignedMath.convert(TenToThe27th, 4);
    private static final int TenToThe27thLow = UnsignedMath.convert(TenToThe27th, 8);

    private Decimal() {
    }

    public static BigDecimal cobol2ZonedDecimalBytesToBigDecimal(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public static double cobol2ZonedDecimalBytesToDouble(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public static long cobol2ZonedDecimalBytesToLong(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    private static BigDecimal convert(byte[] byArray, int n, int n2, int n3) {
        int n4;
        byte[] byArray2 = null;
        boolean bl = Decimal.isNegative(byArray, n, n2);
        int n5 = n2 * 2 - 1;
        if (n5 <= 9) {
            n4 = 32;
            byArray2 = Decimal.convertUpTo9Digits(byArray, n2, n);
        } else if (n5 <= 18) {
            n4 = 64;
            byArray2 = Decimal.convertUpTo18Digits(byArray, n2, n);
        } else if (n5 <= 27) {
            n4 = 96;
            byArray2 = Decimal.convertUpTo27Digits(byArray, n2, n);
        } else if (n5 <= 31) {
            n4 = 128;
            byArray2 = Decimal.convertUpTo31Digits(byArray, n2, n);
        } else {
            throw new IllegalArgumentException();
        }
        return Decimal.createBigDecimal(byArray2, n4, n3, bl);
    }

    private static byte[] convertUpTo18Digits(byte[] byArray, int n, int n2) {
        byte[] byArray2 = Decimal.create8ByteNumberWithSign(byArray, n2 + (n - 5), n2 + n);
        byArray2[7] = (byte)(byArray2[7] & 0xFC);
        int n3 = Decimal.cvb(byArray2);
        byArray2 = Decimal.create8ByteNumberWithoutSign(byArray, n2, n2 + (n - 5), true);
        int n4 = Decimal.cvb(byArray2);
        long l = UnsignedMath.multiplyAsUnsigned(n4, 1000000000L) + (long)n3;
        byte[] byArray3 = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return byArray3;
    }

    private static byte[] convertUpTo27Digits(byte[] byArray, int n, int n2) {
        byte[] byArray2 = Decimal.create8ByteNumberWithSign(byArray, n2 + (n - 5), n2 + n);
        byArray2[7] = (byte)(byArray2[7] & 0xFC);
        int n3 = Decimal.cvb(byArray2);
        byArray2 = Decimal.create8ByteNumberWithoutSign(byArray, n2 + (n - 10), n2 + (n - 5), false);
        int n4 = Decimal.cvb(byArray2);
        byArray2 = Decimal.create8ByteNumberWithSign(byArray, n2, n2 + (n - 9));
        byArray2[7] = (byte)(byArray2[7] & 0xFC);
        int n5 = Decimal.cvb(byArray2);
        long l = UnsignedMath.multiplyAsUnsigned(n4, 1000000000L) + (long)n3;
        long l2 = UnsignedMath.multiplyAsUnsigned(n5, -1486618624) + l;
        long l3 = UnsignedMath.multiplyAsUnsigned(n5, 232830643);
        long l4 = l2 >>> 32;
        long l5 = (l3 += l4) >>> 32;
        byte[] byArray3 = new byte[]{(byte)(l5 >>> 24), (byte)(l5 >>> 16), (byte)(l5 >>> 8), (byte)l5, (byte)((l3 &= 0xFFFFFFFFL) >>> 24), (byte)(l3 >>> 16), (byte)(l3 >>> 8), (byte)l3, (byte)((l2 &= 0xFFFFFFFFL) >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
        return byArray3;
    }

    private static byte[] convertUpTo31Digits(byte[] byArray, int n, int n2) {
        byte[] byArray2 = Decimal.create8ByteNumberWithSign(byArray, n2 + (n - 5), n2 + n);
        byArray2[7] = (byte)(byArray2[7] & 0xFC);
        int n3 = Decimal.cvb(byArray2);
        byArray2 = Decimal.create8ByteNumberWithoutSign(byArray, n2 + (n - 10), n2 + (n - 5), false);
        int n4 = Decimal.cvb(byArray2);
        byArray2 = Decimal.create8ByteNumberWithSign(byArray, n2 + (n - 14), n2 + (n - 9));
        byArray2[7] = (byte)(byArray2[7] & 0xFC);
        int n5 = Decimal.cvb(byArray2);
        byArray2 = Decimal.create8ByteNumberWithoutSign(byArray, n2, n2 + (n - 14), true);
        int n6 = Decimal.cvb(byArray2);
        long l = UnsignedMath.multiplyAsUnsigned(n4, 1000000000L);
        long l2 = UnsignedMath.multiplyAsUnsigned(n5, -1486618624) + (l += (long)n3);
        long l3 = UnsignedMath.multiplyAsUnsigned(n5, 232830643);
        long l4 = l2 >>> 32;
        l2 &= 0xFFFFFFFFL;
        long l5 = (l3 += l4) >>> 32;
        l3 &= 0xFFFFFFFFL;
        long l6 = UnsignedMath.multiplyAsUnsigned(n6, TenToThe27thLow);
        long l7 = UnsignedMath.multiplyAsUnsigned(n6, TenToThe27thMed);
        long l8 = UnsignedMath.multiplyAsUnsigned(n6, TenToThe27thHigh);
        long l9 = l6 >>> 32;
        long l10 = (l7 += l9) >>> 32;
        long l11 = l2 + (l6 &= 0xFFFFFFFFL);
        long l12 = l3 + (l7 &= 0xFFFFFFFFL);
        long l13 = l5 + (l8 += l10);
        long l14 = l11 >>> 32;
        long l15 = (l12 += l14) >>> 32;
        byte[] byArray3 = new byte[]{(byte)((l13 += l15) >>> 56), (byte)(l13 >>> 48), (byte)(l13 >>> 40), (byte)(l13 >>> 32), (byte)(l13 >>> 24), (byte)(l13 >>> 16), (byte)(l13 >>> 8), (byte)l13, (byte)((l12 &= 0xFFFFFFFFL) >>> 24), (byte)(l12 >>> 16), (byte)(l12 >>> 8), (byte)l12, (byte)((l11 &= 0xFFFFFFFFL) >>> 24), (byte)(l11 >>> 16), (byte)(l11 >>> 8), (byte)l11};
        return byArray3;
    }

    private static byte[] convertUpTo9Digits(byte[] byArray, int n, int n2) {
        byte[] byArray2 = Decimal.create8ByteNumberWithSign(byArray, n2, n2 + n);
        byArray2[7] = (byte)(byArray2[7] & 0xFC);
        int n3 = Decimal.cvb(byArray2);
        byte[] byArray3 = new byte[4];
        UnsignedMath.convert(n3, byArray3, 0);
        return byArray3;
    }

    private static final byte[] create8ByteNumberWithoutSign(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        byte[] byArray2 = new byte[8];
        int n4 = UnsignedMath.convert(byArray, n, n2 - n > 4 ? 4 : n2 - n);
        if (bl) {
            n3 = n4 >>> 28;
            int n5 = 7 - (n2 - n);
            byArray2[7 - (n2 - n)] = n3;
        }
        n4 <<= 4;
        if (n2 - n > 4) {
            UnsignedMath.convert(n4 |= (byArray[n2 - 1] & 0xF0) >>> 4, byArray2, 8 - (n2 - n));
            n3 = byArray[n2 - 1];
            if (n3 < 0) {
                n3 += 256;
            }
            byArray2[7] = (byte)((n3 & 0xF) << 4 | 0xC);
        } else {
            UnsignedMath.convert(n4 |= 0xC, byArray2, 4);
        }
        return byArray2;
    }

    private static final byte[] create8ByteNumberWithSign(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[8];
        int n3 = byArray2.length - 1;
        for (int i = n2 - 1; i >= n; --i) {
            byArray2[n3] = byArray[i];
            --n3;
        }
        return byArray2;
    }

    private static final byte[] create8ByteZonedWithSign(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[8];
        int n3 = byArray2.length - 1;
        for (int i = n2 - 1; i >= n; --i) {
            byArray2[n3] = byArray[i];
            --n3;
        }
        return byArray2;
    }

    private static BigDecimal createBigDecimal(byte[] byArray, int n, int n2, boolean bl) {
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(bl ? -1 : 1, byArray), n2);
        return bigDecimal;
    }

    private static int cvb(byte[] byArray) {
        int n;
        int n2 = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            int n3 = byArray[i] & 0xF;
            n = Decimal.highNibble(byArray[i]);
            n2 = n2 * 10 + n;
            n2 = n2 * 10 + n3;
        }
        n = Decimal.highNibble(byArray[7]);
        n2 = n2 * 10 + n;
        if (Decimal.isNegative(byArray, 15)) {
            n2 = -n2;
        }
        return n2;
    }

    public static BigDecimal getBigDecimal(byte[] byArray, int n, int n2, int n3, int n4, String string) {
        switch (n4) {
            case 48: {
                int n5 = n2 / 2 + 1;
                return Decimal.packedDecimalBytesToBigDecimal(byArray, n, n5, n3);
            }
            case 51: {
                int n6 = 0;
                return Decimal.zonedDecimalBytesToBigDecimal(byArray, n, n6, n3);
            }
            case 53: {
                int n7 = 0;
                return Decimal.cobol2ZonedDecimalBytesToBigDecimal(byArray, n, n7, n3);
            }
            case 50: {
                int n8 = 0;
                return Decimal.numericCharacterBytesToBigDecimal(byArray, n, n8, n3, string);
            }
        }
        throw new IllegalArgumentException();
    }

    public static double getDouble(byte[] byArray, int n, int n2, int n3, int n4, String string) {
        switch (n4) {
            case 48: {
                int n5 = n2 / 2 + 1;
                return Decimal.packedDecimalBytesToDouble(byArray, n, n5, n3);
            }
            case 51: {
                int n6 = 0;
                return Decimal.zonedDecimalBytesToDouble(byArray, n, n6, n3);
            }
            case 53: {
                int n7 = 0;
                return Decimal.cobol2ZonedDecimalBytesToDouble(byArray, n, n7, n3);
            }
            case 50: {
                int n8 = 0;
                return Decimal.numericCharacterBytesToDouble(byArray, n, n8, n3, string);
            }
        }
        throw new IllegalArgumentException();
    }

    public static long getLong(byte[] byArray, int n, int n2, int n3, int n4, String string) {
        switch (n4) {
            case 48: {
                int n5 = n2 / 2 + 1;
                return Decimal.packedDecimalBytesToLong(byArray, n, n5, n3);
            }
            case 51: {
                int n6 = 0;
                return Decimal.zonedDecimalBytesToLong(byArray, n, n6);
            }
            case 53: {
                int n7 = 0;
                return Decimal.cobol2ZonedDecimalBytesToLong(byArray, n, n7, n3);
            }
            case 50: {
                int n8 = 0;
                return Decimal.numericCharacterBytesToLong(byArray, n, n8, n3, string);
            }
        }
        throw new IllegalArgumentException();
    }

    private static final int highNibble(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2 >>> 4;
    }

    private static final boolean isNegative(byte[] byArray, int n) {
        if ((byArray[n / 2] & 0xF) == 11) {
            return true;
        }
        return (byArray[n / 2] & 0xF) == 13;
    }

    private static final boolean isNegative(byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        if ((byArray[n3] & 0xF) == 11) {
            return true;
        }
        return (byArray[n3] & 0xF) == 13;
    }

    public static BigDecimal numericCharacterBytesToBigDecimal(byte[] byArray, int n, int n2, int n3, String string) {
        throw new UnsupportedOperationException();
    }

    public static double numericCharacterBytesToDouble(byte[] byArray, int n, int n2, int n3, String string) {
        throw new UnsupportedOperationException();
    }

    public static long numericCharacterBytesToLong(byte[] byArray, int n, int n2, int n3, String string) {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal packedDecimalBytesToBigDecimal(byte[] byArray, int n, int n2, int n3) {
        BigDecimal bigDecimal = BigDecimal.valueOf(0L);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(0L);
        bigDecimal2 = Decimal.convert(byArray, n, n2, n3);
        return bigDecimal2;
    }

    public static double packedDecimalBytesToDouble(byte[] byArray, int n, int n2, int n3) {
        double d = 0.0;
        double d2 = 0.0;
        long l = 0L;
        boolean bl = Decimal.isNegative(byArray, n, n2);
        int n4 = n2 * 2 - 1;
        if (n4 <= 9) {
            byte[] byArray2 = Decimal.create8ByteNumberWithSign(byArray, n, n + n2);
            byArray2[7] = (byte)(byArray2[7] & 0xFC);
            l = Decimal.cvb(byArray2);
            d = n3 >= 0 ? (double)l / Math.pow(10.0, n3) : (double)l;
        } else if (n4 <= 18) {
            int n5 = n + (n4 / 2 - 4);
            byte[] byArray3 = Decimal.create8ByteNumberWithSign(byArray, n5, n + n2);
            byArray3[7] = (byte)(byArray3[7] & 0xFC);
            int n6 = Decimal.cvb(byArray3);
            byArray3 = Decimal.create8ByteNumberWithoutSign(byArray, n, n5, true);
            int n7 = Decimal.cvb(byArray3);
            l = UnsignedMath.multiplyAsUnsigned(n7, 1000000000L) + (long)n6;
            d = n3 > 0 ? (double)l / Math.pow(10.0, n3) : (double)l;
        } else if (n4 <= 27) {
            int n8 = n + (n2 - 5);
            byte[] byArray4 = Decimal.create8ByteNumberWithSign(byArray, n8, n + n2);
            byArray4[7] = (byte)(byArray4[7] & 0xFC);
            int n9 = Decimal.cvb(byArray4);
            byArray4 = Decimal.create8ByteNumberWithoutSign(byArray, n + (n2 - 10), n + (n2 - 5), false);
            int n10 = Decimal.cvb(byArray4);
            byArray4 = Decimal.create8ByteNumberWithSign(byArray, n, n + (n2 - 9));
            byArray4[7] = (byte)(byArray4[7] & 0xFC);
            int n11 = Decimal.cvb(byArray4);
            if (n3 > 0) {
                d2 = UnsignedMath.multiplyAsUnsigned(n11, Math.pow(10.0, 18 - n3));
                d = (d2 += UnsignedMath.multiplyAsUnsigned(n10, Math.pow(10.0, 9 - n3))) + (double)n9 / Math.pow(10.0, n3);
            } else {
                d2 = UnsignedMath.multiplyAsUnsigned(n10, 1000000000L) + (long)n9;
                d = d2 + UnsignedMath.multiplyAsUnsigned(n11, Math.pow(10.0, 18.0));
            }
        } else if (n4 <= 31) {
            byte[] byArray5 = Decimal.create8ByteNumberWithSign(byArray, n + (n2 - 5), n + n2);
            byArray5[7] = (byte)(byArray5[7] & 0xFC);
            int n12 = Decimal.cvb(byArray5);
            byArray5 = Decimal.create8ByteNumberWithoutSign(byArray, n + (n2 - 10), n + (n2 - 5), false);
            int n13 = Decimal.cvb(byArray5);
            byArray5 = Decimal.create8ByteNumberWithSign(byArray, n + (n2 - 14), n + (n2 - 9));
            byArray5[7] = (byte)(byArray5[7] & 0xFC);
            int n14 = Decimal.cvb(byArray5);
            byArray5 = Decimal.create8ByteNumberWithoutSign(byArray, n, n + (n2 - 14), true);
            int n15 = Decimal.cvb(byArray5);
            if (n3 > 0) {
                if (n15 > 0) {
                    d2 = UnsignedMath.multiplyAsUnsigned(n15, Math.pow(10.0, 27 - n3));
                }
                if (n14 > 0) {
                    d2 += UnsignedMath.multiplyAsUnsigned(n14, Math.pow(10.0, 18 - n3));
                }
                if (n13 > 0) {
                    d2 += UnsignedMath.multiplyAsUnsigned(n13, Math.pow(10.0, 9 - n3));
                }
                d = d2 + (double)n12 / Math.pow(10.0, n3);
            } else {
                if (n15 > 0) {
                    d2 = UnsignedMath.multiplyAsUnsigned(n15, Math.pow(10.0, 27.0));
                }
                if (n14 > 0) {
                    d2 += UnsignedMath.multiplyAsUnsigned(n14, Math.pow(10.0, 18.0));
                }
                if (n13 > 0) {
                    d2 += UnsignedMath.multiplyAsUnsigned(n13, Math.pow(10.0, 9.0));
                }
                d = d2 + (double)n12;
            }
        }
        if (bl) {
            d = -d;
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long packedDecimalBytesToLong(byte[] byArray, int n, int n2, int n3) {
        int n4;
        long l = 0L;
        double d = 0.0;
        boolean bl = Decimal.isNegative(byArray, n, n2);
        if (n3 > 0) {
            n4 = n3 % 2;
            if (n4 == 0) {
                n2 -= n3 / 2;
                n3 = 0;
            } else {
                n2 -= n3 / 2;
                n3 = 1;
            }
        }
        if ((n4 = n2 * 2 - 1) <= 9) {
            byte[] byArray2 = Decimal.create8ByteNumberWithSign(byArray, n, n + n2);
            byArray2[7] = (byte)(byArray2[7] & 0xFC);
            l = Decimal.cvb(byArray2);
            if (n3 > 0) {
                l = (long)((double)l / Math.pow(10.0, n3));
            }
        } else if (n4 <= 18) {
            int n5 = n + (n4 / 2 - 4);
            byte[] byArray3 = Decimal.create8ByteNumberWithSign(byArray, n5, n + n2);
            byArray3[7] = (byte)(byArray3[7] & 0xFC);
            int n6 = Decimal.cvb(byArray3);
            byArray3 = Decimal.create8ByteNumberWithoutSign(byArray, n, n5, true);
            int n7 = Decimal.cvb(byArray3);
            l = UnsignedMath.multiplyAsUnsigned(n7, 1000000000L) + (long)n6;
            if (n3 > 0) {
                l = (long)((double)l / Math.pow(10.0, n3));
            }
        } else if (n4 <= 27) {
            int n8 = n + (n2 - 5);
            byte[] byArray4 = Decimal.create8ByteNumberWithSign(byArray, n8, n + n2);
            byArray4[7] = (byte)(byArray4[7] & 0xFC);
            int n9 = Decimal.cvb(byArray4);
            byArray4 = Decimal.create8ByteNumberWithoutSign(byArray, n + (n2 - 10), n + (n2 - 5), false);
            int n10 = Decimal.cvb(byArray4);
            byArray4 = Decimal.create8ByteNumberWithSign(byArray, n, n + (n2 - 9));
            byArray4[7] = (byte)(byArray4[7] & 0xFC);
            int n11 = Decimal.cvb(byArray4);
            if (n3 > 0) {
                d = UnsignedMath.multiplyAsUnsigned(n11, Math.pow(10.0, 18 - n3));
                if ((d += UnsignedMath.multiplyAsUnsigned(n10, Math.pow(10.0, 9 - n3))) > 9.223372036854776E18) {
                    throw new IllegalArgumentException();
                }
                l = (long)(d + (double)n9 / Math.pow(10.0, n3));
            } else {
                l = UnsignedMath.multiplyAsUnsigned(n10, 1000000000L) + (long)n9;
                if (n11 > 0) {
                    if (n11 >= 10) throw new IllegalArgumentException();
                    l = UnsignedMath.multiplyAsUnsigned(n11, 1000000000000000000L) + l;
                }
            }
        } else if (n4 <= 31) {
            byte[] byArray5 = Decimal.create8ByteNumberWithSign(byArray, n + (n2 - 5), n + n2);
            byArray5[7] = (byte)(byArray5[7] & 0xFC);
            int n12 = Decimal.cvb(byArray5);
            byArray5 = Decimal.create8ByteNumberWithoutSign(byArray, n + (n2 - 10), n + (n2 - 5), false);
            int n13 = Decimal.cvb(byArray5);
            byArray5 = Decimal.create8ByteNumberWithSign(byArray, n + (n2 - 14), n + (n2 - 9));
            byArray5[7] = (byte)(byArray5[7] & 0xFC);
            int n14 = Decimal.cvb(byArray5);
            byArray5 = Decimal.create8ByteNumberWithoutSign(byArray, n, n + (n2 - 14), true);
            int n15 = Decimal.cvb(byArray5);
            if (n3 > 0) {
                d = UnsignedMath.multiplyAsUnsigned(n15, Math.pow(10.0, 27 - n3));
                d += UnsignedMath.multiplyAsUnsigned(n14, Math.pow(10.0, 18 - n3));
                if ((d += UnsignedMath.multiplyAsUnsigned(n13, Math.pow(10.0, 9 - n3))) > 9.223372036854776E18) {
                    throw new IllegalArgumentException();
                }
                l = (long)(d + (double)n12 / Math.pow(10.0, n3));
            } else {
                d = UnsignedMath.multiplyAsUnsigned(n15, Math.pow(10.0, 27.0));
                d += UnsignedMath.multiplyAsUnsigned(n14, Math.pow(10.0, 18.0));
                if ((d += UnsignedMath.multiplyAsUnsigned(n13, Math.pow(10.0, 9.0))) > 9.223372036854776E18) {
                    throw new IllegalArgumentException();
                }
                l = (long)(d + (double)n12 / Math.pow(10.0, n3));
            }
        }
        if (bl) {
            l = -l;
        }
        if (n4 <= 32) return l;
        throw new IllegalArgumentException();
    }

    public static BigDecimal zonedDecimalBytesToBigDecimal(byte[] byArray, int n, int n2, int n3) {
        int n4;
        long l = 0L;
        int n5 = (n2 - 1) * 4;
        int n6 = n + n2 - 1;
        for (n4 = n; n4 <= n6; n4 += 1) {
            int n7 = byArray[n4] & 0xF;
            l = l * 10L + (long)n7;
        }
        n4 = Decimal.zonedIsNegative(byArray, n, n2) ? 1 : 0;
        byte[] byArray2 = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return Decimal.createBigDecimal(byArray2, n5, n3, n4 != 0);
    }

    public static double zonedDecimalBytesToDouble(byte[] byArray, int n, int n2, int n3) {
        long l = Decimal.zonedDecimalBytesToLong(byArray, n, n2);
        double d = (double)l / Math.pow(10.0, n3);
        return d;
    }

    public static long zonedDecimalBytesToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = (n2 - 1) * 4;
        int n4 = n + n2 - 1;
        for (int i = n; i <= n4; ++i) {
            int n5 = byArray[i] & 0xF;
            l = l * 10L + (long)n5;
        }
        if (Decimal.zonedIsNegative(byArray, n, n2)) {
            l = -l;
        }
        return l;
    }

    private static final boolean zonedIsNegative(byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        return (byArray[n3] | 0xF) != -49;
    }
}

