/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util.html;

import com.ibm.jvm.util.html.Cell;
import com.ibm.jvm.util.html.Column;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Row;
import java.util.ArrayList;
import java.util.Iterator;

public class Table
extends Element {
    protected Row headerRow;
    protected ArrayList rows = new ArrayList();
    protected ArrayList columns = new ArrayList();
    protected int columnGap = 3;
    protected int cellspacing = -1;
    protected int cellpadding = 4;
    protected int border = 1;
    protected int width = -1;
    protected boolean usePercent;
    protected String bgcolor;
    protected boolean suppressEmptyColumns;

    public Table() {
    }

    public Table(String[] stringArray) {
        this.createHeaderRow();
        for (int i = 0; i < stringArray.length; ++i) {
            Cell cell = new Cell(stringArray[i]);
            this.headerRow.addCell(cell);
        }
    }

    public Table(String string, String string2) {
        this(new String[]{string, string2});
    }

    public Table(String string, String string2, String string3) {
        this(new String[]{string, string2, string3});
    }

    public Table(String string, String string2, String string3, String string4) {
        this(new String[]{string, string2, string3, string4});
    }

    public Table(int n, int n2, int n3) {
        this.border = n;
        this.cellspacing = n2;
        this.cellpadding = n3;
    }

    public Table(int n, int n2, int n3, String string) {
        this(n, n2, n3);
        this.bgcolor = string;
    }

    public Table(int n, int n2, int n3, int n4, String string) {
        this(n2, n3, n4, string);
        this.width = n;
        this.usePercent = true;
    }

    public void suppressEmptyColumns(boolean bl) {
        this.suppressEmptyColumns = bl;
    }

    public void setCellSpacing(int n) {
        this.cellspacing = n;
    }

    public void setCellPadding(int n) {
        this.cellpadding = n;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setColumnGap(int n) {
        this.columnGap = n;
    }

    public int columnGap() {
        return this.columnGap;
    }

    private void createHeaderRow() {
        this.headerRow = new Row(true);
        this.headerRow.setTable(this);
    }

    public void addHeaderCell(String string) {
        if (this.headerRow == null) {
            this.createHeaderRow();
        }
        Cell cell = new Cell(string);
        this.headerRow.addCell(cell);
    }

    public void addCellToColumn(Cell cell, int n) {
        Column column;
        if (n == this.columns.size()) {
            column = new Column();
            this.addColumn(column);
        } else {
            column = (Column)this.columns.get(n);
        }
        column.addCell(cell);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addRow(Row row) {
        this.rows.add(row);
        row.setTable(this);
        for (int i = 0; i < row.size(); ++i) {
            Cell cell = row.cellAt(i);
            this.addCellToColumn(cell, i);
        }
    }

    public void addRow(int[] nArray) {
        Row row = new Row(nArray);
        this.addRow(row);
    }

    public void addRow(String[] stringArray) {
        Row row = new Row(stringArray);
        this.addRow(row);
    }

    public void addRow(String string, String string2) {
        this.addRow(new String[]{string, string2});
    }

    public void addRow(String string, String string2, String string3) {
        this.addRow(new String[]{string, string2, string3});
    }

    protected String toHtmlString() {
        String string = "<table border=\"" + this.border + "\" cellpadding=\"" + this.cellpadding + "\"";
        if (this.cellspacing != -1) {
            string = string + " cellspacing=\"" + this.cellspacing + "\"";
        }
        if (this.bgcolor != null) {
            string = string + " bgcolor=\"" + this.bgcolor + "\"";
        }
        if (this.width != -1) {
            string = string + " width=\"" + this.width;
            if (this.usePercent) {
                string = string + "%";
            }
            string = string + "\"";
        }
        string = string + ">";
        string = this.beautify(string);
        if (this.headerRow != null) {
            string = string + this.headerRow.toHtmlString();
        }
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            string = string + row.toHtmlString();
        }
        string = string + "</table>";
        return this.beautify(string);
    }

    protected String toTextString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.headerRow != null) {
            stringBuffer.append(this.headerRow.toTextString());
        }
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            stringBuffer.append(row.toTextString());
        }
        return stringBuffer.toString();
    }
}

