/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump.examples;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Page;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class PrintHpiTrace {
    public static void main(String[] stringArray) {
        try {
            Dump dump = new Dump(stringArray[0]);
            AddressSpace addressSpace = dump.getDefaultAddressSpace();
            Enumeration enumeration = addressSpace.getPages();
            while (enumeration.hasMoreElements()) {
                Page page = (Page)enumeration.nextElement();
                int[] nArray = page.getIntArray();
                for (int i = 0; i < nArray.length; ++i) {
                    int n;
                    int n2;
                    int n3;
                    String string;
                    if (nArray[i] != 0x2A2A2A4A || !(string = addressSpace.readString(n3 = page.getAddress() + (i << 2))).equals("***JAVA_TRACE_TABLE****") || !(string = addressSpace.readString(n3 + 24)).equals("S390JAVA")) continue;
                    int n4 = addressSpace.readInt(n3 + 32);
                    int n5 = addressSpace.readInt(n3 + 44);
                    int n6 = addressSpace.readInt(n3 + 48);
                    int n7 = addressSpace.readInt(n3 + 52);
                    int n8 = n2 = n7 + n4;
                    int n9 = addressSpace.getId();
                    System.out.println("found hpi trace, offset = " + PrintHpiTrace.hex(n4) + " table start = " + PrintHpiTrace.hex(n7) + " table end = " + PrintHpiTrace.hex(n6) + " table size = " + PrintHpiTrace.hex(n5) + " asid = " + PrintHpiTrace.hex(n9));
                    boolean bl = false;
                    while (true) {
                        try {
                            if (addressSpace.readInt(n8 + 20) == n9 && (n = addressSpace.readInt(n8)) >= 32 && n < 100) {
                                bl = true;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            n8 = n7 - 4;
                        }
                        if ((n8 += 4) == n2) break;
                        if (n8 < n6) continue;
                        n8 = n7;
                    }
                    if (!bl) {
                        System.out.println("could not find a valid record!");
                        return;
                    }
                    n = 1;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
                    int n10 = 0;
                    int n11 = n8;
                    while (n10 < n5 && !(n8 >= n2 ? n11 >= n2 && n11 < n8 : n11 >= n2)) {
                        int n12 = addressSpace.readInt(n11);
                        if (n11 + n12 >= n6) {
                            n11 += n12 - n5;
                            n10 += n12;
                            System.out.println("skipping last record");
                            continue;
                        }
                        int n13 = addressSpace.readInt(n11 + 4);
                        long l = addressSpace.readInt(n11 + 8);
                        long l2 = addressSpace.readInt(n11 + 12);
                        Date date = AddressSpace.mvsClockToDate(l << 32 | l2 & 0xFFFFFFFFL);
                        if (n != 0) {
                            System.out.println("Trace begins at " + date);
                            n = 0;
                        }
                        String string2 = simpleDateFormat.format(date);
                        String string3 = n13 == 0 ? "No format string" : addressSpace.readString(n13);
                        int n14 = addressSpace.readInt(n11 + 16);
                        int n15 = addressSpace.readInt(n11 + 24);
                        System.out.print(string2 + " tcb " + PrintHpiTrace.hex(n14) + " " + string3 + " ");
                        for (int j = 0; j < n15; ++j) {
                            int n16 = addressSpace.readInt(n11 + 32 + (j << 2));
                            System.out.print(PrintHpiTrace.hex(n16) + " ");
                        }
                        System.out.println("");
                        n11 += n12;
                        n10 += n12;
                    }
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Oops: " + exception);
        }
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }
}

