/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.HeapClass;

public class HeapField
extends Base {
    HeapClass cl;
    char type;
    int offset;
    int fb;

    HeapField(HeapClass heapClass, int n) {
        this.cl = heapClass;
        this.fb = n;
        try {
            this.type = heapClass.fbFieldType(n);
            this.offset = heapClass.fbStaticValueAddress(n);
        }
        catch (Exception exception) {
            throw new Error("Unexpected exception: " + exception);
        }
    }

    String fbName() throws Exception {
        int n = this.cl.space.readInt(this.fb + 8);
        return this.cl.space.readString(n);
    }

    String fbSignature() throws Exception {
        int n = this.cl.space.readInt(this.fb + 4);
        return this.cl.space.readString(n);
    }

    boolean fbIsStatic() throws Exception {
        return (this.cl.space.readUnsignedShort(this.fb + 12) & 8) != 0;
    }

    boolean fbIsReference() throws Exception {
        return (this.cl.space.readUnsignedShort(this.fb + 14) & 2) != 0;
    }

    boolean fbIsFinal() throws Exception {
        return (this.cl.space.readUnsignedShort(this.fb + 12) & 0x10) != 0;
    }

    int fbStaticValueAddress() throws Exception {
        return this.cl.space.readInt(this.fb + 20);
    }

    public String toString() {
        try {
            String string = this.fbName() + " " + this.fbSignature();
            if (this.fbIsStatic() && this.fbIsReference()) {
                int n = this.fbStaticValueAddress();
                int n2 = this.cl.space.readInt(n);
                string = string + " (value = 0x" + HeapField.hex(n2) + ")";
            }
            return string;
        }
        catch (Exception exception) {
            throw new Error("error getting fbName: " + exception);
        }
    }
}

