/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.HprofContentHandler;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import java.io.EOFException;
import java.io.InputStream;

public class HprofParser {
    static final int HPROF_UTF8 = 1;
    static final int HPROF_LOAD_CLASS = 2;
    static final int HPROF_UNLOAD_CLASS = 3;
    static final int HPROF_FRAME = 4;
    static final int HPROF_TRACE = 5;
    static final int HPROF_ALLOC_SITES = 6;
    static final int HPROF_START_THREAD = 10;
    static final int HPROF_END_THREAD = 11;
    static final int HPROF_HEAP_DUMP = 12;
    static final int HPROF_CONTROL_SETTINGS = 14;
    static final int HPROF_GC_ROOT_UNKNOWN = 255;
    static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    static final int HPROF_GC_CLASS_DUMP = 32;
    static final int HPROF_GC_INSTANCE_DUMP = 33;
    static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    InputStream input;
    HprofContentHandler handler;
    int remainder;
    IntHashtable strings = new IntHashtable();
    int tag;
    int lastTag;

    HprofParser(HprofContentHandler hprofContentHandler, InputStream inputStream) throws Exception {
        this.setContentHandler(hprofContentHandler);
        try {
            this.parse(inputStream);
        }
        catch (EOFException eOFException) {
            System.out.println("Warning: unexpected EOF, dump may not be complete, tag " + this.tag + " prev tag " + this.lastTag);
        }
    }

    final int readInputByte() throws Exception {
        int n = this.input.read();
        if (n == -1) {
            throw new EOFException("Unexpected EOF");
        }
        return n;
    }

    void setContentHandler(HprofContentHandler hprofContentHandler) {
        this.handler = hprofContentHandler;
    }

    void parse(InputStream inputStream) throws Exception {
        this.input = inputStream;
        this.handler.header(this.readString());
        this.skip(4);
        this.skip(8);
        while (true) {
            this.tag = inputStream.read();
            if (this.tag == -1) {
                return;
            }
            this.skip(4);
            this.remainder = this.readInt();
            switch (this.tag) {
                case 12: {
                    int n;
                    this.handler.beginHeapDump();
                    block27: while (this.remainder > 0) {
                        this.tag = this.readByte();
                        switch (this.tag) {
                            case 32: {
                                int n2;
                                int n3;
                                n = this.readInt();
                                this.skip(4);
                                int n4 = this.readInt();
                                this.skip(20);
                                int n5 = this.readInt();
                                int n6 = this.readShort();
                                for (int i = 0; i < n6; ++i) {
                                    this.skip(2);
                                    n3 = this.readByte();
                                    this.skip(1 << (n3 & 3));
                                }
                                n6 = this.readShort();
                                IntegerArray integerArray = new IntegerArray();
                                for (n3 = 0; n3 < n6; ++n3) {
                                    this.skip(4);
                                    n2 = this.readByte();
                                    if (n2 == 2) {
                                        integerArray.add(this.readInt());
                                        continue;
                                    }
                                    this.skip(1 << (n2 & 3));
                                }
                                n6 = this.readShort();
                                int[] nArray = new int[n6];
                                for (n2 = 0; n2 < n6; ++n2) {
                                    this.skip(4);
                                    nArray[n2] = this.readByte();
                                }
                                this.handler.classDump(n, n4, integerArray.toArray(), nArray);
                                continue block27;
                            }
                            case 34: {
                                n = this.readInt();
                                this.skip(4);
                                int n4 = this.readInt();
                                int n5 = this.readInt();
                                int[] nArray = new int[n4];
                                for (int i = 0; i < n4; ++i) {
                                    nArray[i] = this.readInt();
                                }
                                this.handler.objectArrayDump(n, n5, nArray);
                                continue block27;
                            }
                            case 35: {
                                n = this.readInt();
                                this.skip(4);
                                int n4 = this.readInt();
                                int n5 = this.readByte();
                                this.skip(n4 * (1 << (n5 & 3)));
                                this.handler.primitiveArrayDump(n, n5, n4);
                                continue block27;
                            }
                            case 33: {
                                n = this.readInt();
                                this.skip(4);
                                int n4 = this.readInt();
                                int n5 = this.readInt();
                                short[] sArray = new short[n5];
                                for (int i = 0; i < n5; ++i) {
                                    sArray[i] = (short)this.readByte();
                                }
                                this.handler.instanceDump(n, n4, sArray);
                                continue block27;
                            }
                            case 255: {
                                this.skip(4);
                                continue block27;
                            }
                            case 1: {
                                this.skip(8);
                                continue block27;
                            }
                            case 2: {
                                this.skip(12);
                                continue block27;
                            }
                            case 3: {
                                this.skip(12);
                                continue block27;
                            }
                            case 5: {
                                this.skip(4);
                                continue block27;
                            }
                            case 6: {
                                this.skip(8);
                                continue block27;
                            }
                            case 8: {
                                this.skip(12);
                                continue block27;
                            }
                            case 4: {
                                this.skip(8);
                                continue block27;
                            }
                        }
                        this.handler.error("Unknown heap dump tag: " + this.tag);
                        return;
                    }
                    this.handler.endHeapDump();
                    break;
                }
                case 1: {
                    int n = this.readInt();
                    String string = this.readString(this.remainder);
                    this.strings.put(n, (Object)string);
                    this.handler.utf8(n, string);
                    break;
                }
                case 2: {
                    this.skip(4);
                    int n = this.readInt();
                    this.skip(4);
                    int n7 = this.readInt();
                    String string = (String)this.strings.get(n7);
                    this.handler.loadClass(n, string);
                    break;
                }
                case 3: {
                    this.skip(4);
                    break;
                }
                case 14: {
                    this.skip(6);
                    break;
                }
                case 10: {
                    this.skip(24);
                    break;
                }
                case 11: {
                    this.skip(4);
                    break;
                }
                case 5: {
                    this.skip(4);
                    this.skip(4);
                    int n = this.readInt();
                    this.skip(n * 4);
                    break;
                }
                case 4: {
                    this.skip(24);
                    break;
                }
                case 6: {
                    this.skip(this.remainder);
                    break;
                }
                default: {
                    this.handler.error("Unknown tag: " + this.tag);
                    return;
                }
            }
            this.lastTag = this.tag;
        }
    }

    final String readString() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.readInputByte()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    final String readString(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.readInputByte());
        }
        return stringBuffer.toString();
    }

    final int readInt() throws Exception {
        int n = this.readInputByte();
        int n2 = this.readInputByte();
        int n3 = this.readInputByte();
        int n4 = this.readInputByte();
        this.remainder -= 4;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    final int readShort() throws Exception {
        int n = this.readInputByte();
        int n2 = this.readInputByte();
        this.remainder -= 2;
        return (n << 8) + n2;
    }

    final int readByte() throws Exception {
        int n = this.readInputByte();
        --this.remainder;
        return n;
    }

    final void skip(int n) throws Exception {
        this.remainder -= n;
        while (n > 0) {
            n = (int)((long)n - this.input.skip(n));
        }
    }
}

