/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.HprofContentHandler;
import com.ibm.jvm.findroots.HprofParser;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.IntegerArray;
import java.io.BufferedInputStream;
import java.io.FileInputStream;

public class HprofParseFile {
    IntHashtable classes = new IntHashtable();
    HeapdumpContentHandler handler;

    HprofParseFile(HeapdumpContentHandler heapdumpContentHandler, String string) throws Exception {
        this.handler = heapdumpContentHandler;
        this.parse(string, new pass1());
        this.parse(string, new pass2());
    }

    void parse(String string, HprofContentHandler hprofContentHandler) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        new HprofParser(hprofContentHandler, bufferedInputStream);
    }

    class HprofClass {
        int id;
        String name;
        HprofClass superClass;
        int[] instanceFieldTypes;

        HprofClass(int n, String string) {
            this.id = n;
            this.name = string;
        }
    }

    class pass2
    implements HprofContentHandler {
        pass2() {
        }

        public void classDump(int n, int n2, int[] nArray, int[] nArray2) {
            HprofClass hprofClass = (HprofClass)HprofParseFile.this.classes.get(n);
            HprofParseFile.this.handler.classDump(n, hprofClass.name, nArray, 300);
        }

        public void instanceDump(int n, int n2, short[] sArray) {
            HprofClass hprofClass = (HprofClass)HprofParseFile.this.classes.get(n2);
            String string = hprofClass.name;
            int n3 = 0;
            IntegerArray integerArray = new IntegerArray();
            while (hprofClass != null) {
                for (int i = 0; i < hprofClass.instanceFieldTypes.length; ++i) {
                    short s;
                    short s2;
                    short s3;
                    short s4;
                    int n4;
                    if (hprofClass.instanceFieldTypes[i] == 2 && (n4 = ((s4 = sArray[n3]) << 24) + ((s3 = sArray[n3 + 1]) << 16) + ((s2 = sArray[n3 + 2]) << 8) + (s = sArray[n3 + 3])) != 0) {
                        integerArray.add(n4);
                    }
                    n3 += 1 << (hprofClass.instanceFieldTypes[i] & 3);
                }
                hprofClass = hprofClass.superClass;
            }
            HprofParseFile.this.handler.instanceDump(n, string, integerArray.toArray(), sArray.length + 8);
        }

        public void objectArrayDump(int n, int n2, int[] nArray) {
            HprofClass hprofClass = (HprofClass)HprofParseFile.this.classes.get(n2);
            HprofParseFile.this.handler.objectArrayDump(n, hprofClass.name, nArray, nArray.length << 2);
        }

        public void primitiveArrayDump(int n, int n2, int n3) {
            HprofParseFile.this.handler.primitiveArrayDump(n, n2, n3);
        }

        public void error(String string) {
            HprofParseFile.this.handler.error(string);
        }

        public void loadClass(int n, String string) {
        }

        public void header(String string) {
        }

        public void utf8(int n, String string) {
        }

        public void beginHeapDump() {
        }

        public void endHeapDump() {
        }
    }

    class pass1
    implements HprofContentHandler {
        pass1() {
        }

        public void loadClass(int n, String string) {
            HprofParseFile.this.classes.put(n, (Object)new HprofClass(n, string));
        }

        public void classDump(int n, int n2, int[] nArray, int[] nArray2) {
            HprofClass hprofClass = (HprofClass)HprofParseFile.this.classes.get(n);
            hprofClass.superClass = (HprofClass)HprofParseFile.this.classes.get(n2);
            hprofClass.instanceFieldTypes = nArray2;
        }

        public void error(String string) {
            HprofParseFile.this.handler.error(string);
        }

        public void header(String string) {
        }

        public void utf8(int n, String string) {
        }

        public void beginHeapDump() {
        }

        public void endHeapDump() {
        }

        public void objectArrayDump(int n, int n2, int[] nArray) {
        }

        public void primitiveArrayDump(int n, int n2, int n3) {
        }

        public void instanceDump(int n, int n2, short[] sArray) {
        }
    }
}

