/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.HeapdumpContentHandler;
import com.ibm.jvm.findroots.VersionDetector;
import com.ibm.jvm.util.IntegerArray;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

public class HeapdumpParser {
    HeapdumpContentHandler handler;
    LineNumberReader rin;
    String line;
    VersionDetector dt;

    HeapdumpParser(HeapdumpContentHandler heapdumpContentHandler, String string) throws Exception {
        this.handler = heapdumpContentHandler;
        this.parse(string);
    }

    void parse(String string) throws Exception {
        this.dt = new VersionDetector(new LineNumberReader(new FileReader(string)));
        FileReader fileReader = new FileReader(string);
        this.rin = new LineNumberReader(fileReader);
        String string2 = null;
        int n = 12;
        boolean bl = this.dt.hasFlags();
        while ((this.line = this.rin.readLine()) != null) {
            int n2;
            if (this.line.startsWith("//")) continue;
            if (!this.line.startsWith("0x")) {
                System.err.println("Expected 0x... on line " + this.rin.getLineNumber() + " but got: " + this.line);
                continue;
            }
            String string3 = this.line.substring(2, 10);
            long l = Long.parseLong(string3, 16);
            if (bl) {
                if (this.line.charAt(11) != '<') {
                    System.err.println("Missing flags marker '<' on line " + this.rin.getLineNumber() + " in: " + this.line);
                    continue;
                }
                n2 = 12;
                while (this.line.charAt(n2) != '>') {
                    ++n2;
                }
                string2 = this.line.substring(12, n2);
                n = n2 + 3;
            }
            if (this.line.charAt(n - 1) != '[') {
                System.err.println("Missing size marker '[' on line,position: " + this.rin.getLineNumber() + "," + (n - 1) + " in: " + this.line);
                continue;
            }
            n2 = n;
            while (this.line.charAt(n2) != ']') {
                ++n2;
            }
            int n3 = Integer.parseInt(this.line.substring(n, n2));
            String string4 = this.line.substring(n2 + 2);
            if (string4.startsWith("primitive array")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("byte[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("char[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("short[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("int[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("long[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("float[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("double[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            if (string4.startsWith("bool[]")) {
                this.handler.primitiveArrayDump((int)l, 1, n3);
                continue;
            }
            IntegerArray integerArray = new IntegerArray();
            this.line = this.rin.readLine();
            if (this.line == null || !this.line.startsWith("\t")) {
                System.err.println("Expected \\t... on line " + this.rin.getLineNumber() + " but got: " + this.line);
            } else {
                String string5;
                StringTokenizer stringTokenizer = new StringTokenizer(this.line);
                while (stringTokenizer.hasMoreTokens() && !(string5 = stringTokenizer.nextToken()).equals("ignoring")) {
                    string5 = string5.substring(2);
                    try {
                        integerArray.add((int)Long.parseLong(string5, 16));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.err.println("something dodgy here on line " + this.rin.getLineNumber() + " in: " + this.line);
                    }
                }
            }
            if (string4.startsWith("class ")) {
                this.handler.classDump((int)l, string4.substring(6), integerArray.toArray(), n3);
                continue;
            }
            if (string4.startsWith("array of ")) {
                this.handler.objectArrayDump((int)l, string4.substring(9), integerArray.toArray(), n3);
                continue;
            }
            this.handler.instanceDump((int)l, string4, integerArray.toArray(), n3);
        }
    }
}

