/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.FreeList;
import com.ibm.jvm.dump.plugins.Chunk;
import com.ibm.jvm.dump.plugins.ChunkVisitor;
import com.ibm.jvm.dump.plugins.OutputStrategy;

public class WhatIsChunkVisitor
extends ChunkVisitor {
    private long addrAsLong;
    private boolean foundIt;

    WhatIsChunkVisitor(boolean bl, FreeList freeList, DvAddress dvAddress, OutputStrategy outputStrategy) {
        super(bl, freeList, outputStrategy);
        this.addrAsLong = dvAddress.getAddressAsLong();
        this.foundIt = false;
    }

    WhatIsChunkVisitor(FreeList freeList, DvAddress dvAddress, OutputStrategy outputStrategy) {
        this(false, freeList, dvAddress, outputStrategy);
    }

    boolean processChunk(long l) {
        long l2 = Chunk.getHeader(l);
        if (l <= this.addrAsLong && l + l2 >= this.addrAsLong) {
            this.outputStrategy.output("    \"0x" + DvUtils.rJustifyZ(Long.toHexString(this.addrAsLong), 0) + "\" is within a chunk on " + this.freeListToWalk.getFreeListName());
            this.outputStrategy.output("     Hint: can use \"for 0x" + DvUtils.rJustifyZ(Long.toHexString(l), 0) + " as Chunk\" ");
            this.foundIt = true;
            return false;
        }
        return true;
    }

    boolean foundIt() {
        return this.foundIt;
    }
}

