/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.plugins.OutputStrategy;
import java.util.Iterator;
import java.util.Vector;

public class IndentingOutputStrategy
extends OutputStrategy {
    static final int MAXPADDING = 100;
    static String padding;
    int indentationLevel = 0;

    public IndentingOutputStrategy(OutputStrategy outputStrategy) {
        super(outputStrategy);
    }

    public void setIndentationLevel(int n) {
        this.checkIndentationLevel(n);
        this.indentationLevel = n;
    }

    public void increaseIndentationLevel(int n) {
        this.checkIndentationLevel(this.indentationLevel + n);
        this.indentationLevel += n;
    }

    public void decreaseIndentationLevel(int n) {
        this.checkIndentationLevel(this.indentationLevel - n);
        this.indentationLevel -= n;
    }

    private void checkIndentationLevel(int n) {
        if (n >= 0 && n < 100) {
            return;
        }
        throw new RuntimeException("IndentingOutputStream - invalid indentation level " + n);
    }

    private void checkIndentationLevel() {
        this.checkIndentationLevel(this.indentationLevel);
    }

    private void outputString(String string) {
        this.outputStrategy.output(padding.substring(0, this.indentationLevel) + string);
    }

    void output(String string) {
        if (this.indentationLevel == 0) {
            this.outputStrategy.output(string);
            return;
        }
        this.checkIndentationLevel();
        this.outputString(string);
    }

    void output(Vector vector) {
        if (this.indentationLevel == 0) {
            this.outputStrategy.output(vector);
            return;
        }
        this.checkIndentationLevel();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.outputString((String)iterator.next());
        }
    }

    void flush() {
        this.outputStrategy.flush();
    }

    static {
        char[] cArray = new char[100];
        for (int i = 0; i < 100; ++i) {
            cArray[i] = 32;
        }
        padding = new String(cArray);
    }
}

