/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.ClassDetails;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvConstants;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmds;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import java.util.Vector;

public class DvClassSupportSov
extends CommandPlugin {
    private static DvClassSupportSov selfRef;
    private static int ptrLength;
    private static int methodBlockSize;
    private static int fieldBlockSize;
    private static int cc1;
    private static int cc2;
    private static int cc3;
    private static int totalClassesCount;
    private static String[] commandsSupported;
    private static String[] mySuffixes;
    private static long mirrorTable;
    private static long stringValueOffset;
    private static ClassDetails javaLangString;
    private static final String badString = "Unable to get Instance Values";

    public DvClassSupportSov() {
        selfRef = this;
        ptrLength = DvUtils.pointerLength();
    }

    public String[] getSuffixes() {
        return mySuffixes;
    }

    public String pluginName() {
        return "General plugin supporting DVClassCommands (for sov)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void getClasses(Vector vector) {
        Vector vector2 = DvClassCommands.getTheClassesVector();
        if (0 == vector2.size()) {
            cc1 = this.getClassesForCategory("LOADEDCLASSES", vector);
            cc3 = this.getClassesForCategory("LOADEDSYSTEMCLASSES", vector);
            cc2 = this.getClassesForCategory("LOADEDACSCLASSES", vector);
            vector.add(" Number of classes found via loadedClasses       = " + cc1);
            vector.add(" Number of classes found via loadedACSClasses    = " + cc2);
            vector.add(" Number of classes found via loadedSystemClasses = " + cc3);
        }
        methodBlockSize = CType.find("methodblock").getSize();
        fieldBlockSize = CType.find("fieldblock").getSize();
        DvUtils.writetoTrace("methodblock size is x" + Integer.toHexString(methodBlockSize));
        DvUtils.writetoTrace("fieldblock size is x" + Integer.toHexString(fieldBlockSize));
    }

    private int getClassesForCategory(String string, Vector vector) {
        DvUtils.writetoTrace("Entry: DvClassCommands.getClassesForCategory -" + string);
        DvDump dvDump = DvConsole.theDump;
        int n = 0;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        long l = 0L;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l2 = DvUtils.jvmFromThreadId(dvThread.id());
        String string2 = DvUtils.getJVMHint(l2, string);
        if (null != string2) {
            long l3 = DvUtils.hexToLong(string2);
            try {
                DvUtils.writetoTrace("  current_start = " + Long.toHexString(l3));
                long l4 = 0L;
                if (0L != l3) {
                    l4 = DvUtils.getFieldAddress(l3, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                }
                long l5 = l4 - l3;
                while (0L != l4) {
                    l = l4;
                    boolean bl = false;
                    long l6 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "shared_class_id"}, dvAddressSpace);
                    int n2 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l6));
                    if (n2 != 0) {
                        int n3 = this.processSharedClass(l, dvAddressSpace, dvDump, l5, n2, vector);
                        n += n3;
                    } else {
                        bl = this.storeClass(l, dvAddressSpace, dvDump, l5, vector, 0L);
                        if (bl) {
                            ++totalClassesCount;
                            ++n;
                        }
                    }
                    if (bl) {
                        long l7 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "memory_table"}, dvAddressSpace);
                        l3 = l4 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l7);
                        if (0L == l4) continue;
                        l4 = DvUtils.getFieldAddress(l4, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                        continue;
                    }
                    l4 = 0L;
                }
            }
            catch (DvAddressException dvAddressException) {
                vector.add(" DvAddressException whilst accessing class");
                vector.add(" data from file:\n" + dvAddressException.getMessage());
            }
        } else {
            vector.add(" Hint missing for category " + string);
            vector.add(" Probably due to mismatch in types file.");
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.getClassesForCategory -" + string + "  count=" + n);
        return n;
    }

    public void showMethods(ClassDetails classDetails, Vector vector, Boolean bl) {
        DvDump dvDump = DvConsole.theDump;
        DvUtils.writetoTrace("Entry: DvClassCommands.showMethods");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        boolean bl2 = true;
        int n = dvDump.getArchitecture();
        boolean bl3 = DvUtils.is64BitSystem(n);
        vector.add("\n Method Block details follow.....\n ===========================\n");
        vector.add(classDetails);
        vector.add("\n");
        if (0L < classDetails.methods_count) {
            long l = classDetails.methods;
            int n2 = 0;
            while ((long)n2 < classDetails.methods_count) {
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "methodblock");
                    if (!DvClassSupportSov.clazzCheck(n2, dvAddress, classDetails.address, dvAddressSpace, bl3)) {
                        vector.add("    *** Consistency check failed - clazz field not matching (showMethods)");
                    }
                    String string = "!!!Not established!!!";
                    String string2 = "!!!Not established!!!";
                    CTypeObject cTypeObject2 = cTypeObject.getField("member");
                    if (null != cTypeObject2) {
                        CTypeObject cTypeObject3 = cTypeObject2.getField("name");
                        CTypeObject cTypeObject4 = cTypeObject2.getField("signature");
                        if (null != cTypeObject3) {
                            DvAddress dvAddress2 = null;
                            try {
                                dvAddress2 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
                                byte[] byArray = dvAddressSpace.readBytes(dvAddress2, 256L);
                                string = DvUtils.getStringFromBytes(byArray);
                                dvAddress2 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject4.getAddr()));
                                byArray = dvAddressSpace.readBytes(dvAddress2, 256L);
                                string2 = DvUtils.getStringFromBytes(byArray);
                            }
                            catch (DvAddressException dvAddressException) {
                                // empty catch block
                            }
                        }
                    }
                    vector.add("\n Method Block #" + (n2 + 1) + " : " + string + "\n    Signature: " + string2 + "\n =====================================" + "\n");
                    vector.add(cTypeObject);
                } else {
                    vector.add("   *** Method block #" + n2 + " address (" + Long.toHexString(l) + ") not valid***");
                }
                ++n2;
                l += (long)methodBlockSize;
            }
        } else {
            vector.add("   *** Class has NO METHODS ***");
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.showMethods");
    }

    public void showStatics(ClassDetails classDetails, Vector vector, Boolean bl) {
        DvUtils.writetoTrace("Entry: DvClassCommands.showStatics");
        DvDump dvDump = DvConsole.theDump;
        boolean bl2 = true;
        int n = dvDump.getArchitecture();
        boolean bl3 = DvUtils.is64BitSystem(n);
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        int n2 = dvAddressSpace.pointerSize();
        vector.add("\n Statics for " + classDetails.name + "\n ===========================\n");
        if (classDetails.loaderInitd) {
            if (0L < classDetails.fields_count) {
                long l = classDetails.fields;
                int n3 = 0;
                while ((long)n3 < classDetails.fields_count) {
                    DvAddress dvAddress = dvAddressSpace.createAddress(l);
                    if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                        short s = 0;
                        try {
                            long l2 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "access"}, dvAddressSpace);
                            s = dvAddressSpace.readShort(dvAddressSpace.createAddress(l2));
                        }
                        catch (DvAddressException dvAddressException) {
                            // empty catch block
                        }
                        if (8 == (8 & s)) {
                            String string;
                            CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "fieldblock");
                            if (!DvClassSupportSov.clazzCheck(n3, dvAddress, classDetails.address, dvAddressSpace, bl3)) {
                                vector.add("    *** Consistency check failed - clazz field not matching (showStatics)");
                            }
                            long l3 = 0L;
                            long l4 = 0L;
                            long l5 = 0L;
                            long l6 = 0L;
                            String string2 = null;
                            try {
                                l4 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "signature"}, dvAddressSpace);
                                l5 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "name"}, dvAddressSpace);
                                l6 = DvUtils.getFieldAddress(l, new String[]{"fieldblock", "shared_class_id"}, dvAddressSpace);
                                l3 = DvUtils.getFieldAddress(l, new String[]{"fieldblock", "value"}, dvAddressSpace);
                                if (bl3) {
                                    l5 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l5));
                                    l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l3));
                                    l4 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l4));
                                } else {
                                    l5 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l5));
                                    l3 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l3));
                                    l4 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l4));
                                }
                                l6 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l6));
                                if (0L != l6) {
                                    l3 = DvClassSupportSov.staticClassValueAddress(l6, l3, n2, dvAddressSpace);
                                }
                                string2 = DvUtils.stringFromAddress(l4, dvAddressSpace);
                            }
                            catch (DvAddressException dvAddressException) {
                                // empty catch block
                            }
                            if (l5 != 0L) {
                                string = " Field #" + (n3 + 1) + " @0x" + Long.toHexString(l) + " : " + DvUtils.stringFromAddress(l5, dvAddressSpace);
                                vector.add(string);
                            }
                            if (l3 != 0L && l4 != 0L) {
                                string = "     " + DvClassCommands.fieldValue(l3, string2, dvAddressSpace, false);
                                vector.add(string);
                            } else {
                                vector.add("valueAddress:0x" + Long.toHexString(l3) + "  sigAddress:0x" + Long.toHexString(l4));
                                vector.add(DvUtils.stringFromAddress(l4, dvAddressSpace));
                                vector.add(" !!! Value unobtainable for this field");
                            }
                            vector.add("      Access flags:" + DvConstants.interpretAccess(s));
                        }
                    } else {
                        vector.add("   *** Field block #" + n3 + " address (" + Long.toHexString(l) + ") not valid***");
                    }
                    ++n3;
                    l += (long)fieldBlockSize;
                }
            } else {
                vector.add("   *** Class has NO FIELDS ***");
            }
        } else {
            vector.add("   *** Loader not initialized - statics invalid ***");
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.showStatics");
    }

    private static long staticClassValueAddress(long l, long l2, long l3, DvAddressSpace dvAddressSpace) {
        long l4 = 0L;
        DvUtils.writetoTrace("Entry: DvClassCommands.staticClassValueAddress");
        long l5 = mirrorTable + l3 * l;
        try {
            long l6 = DvUtils.getPtrFromPtr(DvConsole.theDump, dvAddressSpace, l5);
            long l7 = DvUtils.getFieldAddress(l6, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
            long l8 = DvUtils.getFieldAddress(l7, new String[]{"MirroredClassData", "static_variable_values"}, dvAddressSpace);
            l8 = DvUtils.getPtrFromPtr(DvConsole.theDump, dvAddressSpace, l8);
            l4 = l8 + l2;
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("DvClassCommands:staticClassValueAddress caught DvAddressException!", 0, true);
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.staticClassValueAddress" + Long.toHexString(l4));
        return l4;
    }

    public static DvClassCommands.FieldInfo showFields(ClassDetails classDetails, Vector vector, Boolean bl, DvDump dvDump) {
        DvUtils.writetoTrace("Entry: DvClassCommands.showFields");
        boolean bl2 = true;
        int n = dvDump.getArchitecture();
        boolean bl3 = DvUtils.is64BitSystem(n);
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        if (null != vector) {
            vector.add("\n Fields (non-static) for " + classDetails.name + "\n =====================================\n");
        }
        DvClassCommands.FieldInfo fieldInfo = (DvClassCommands.FieldInfo)DvClassCommands.fieldsHashByName.get(classDetails.name);
        boolean bl4 = false;
        if (null == fieldInfo) {
            bl4 = true;
            fieldInfo = new DvClassCommands.FieldInfo();
        }
        if (0L < classDetails.fields_count) {
            long l = classDetails.fields;
            int n2 = 0;
            while ((long)n2 < classDetails.fields_count) {
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    short s = 0;
                    try {
                        long l2 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "access"}, dvAddressSpace);
                        s = dvAddressSpace.readShort(dvAddressSpace.createAddress(l2));
                    }
                    catch (DvAddressException dvAddressException) {
                        // empty catch block
                    }
                    if (8 != (8 & s)) {
                        String string;
                        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "fieldblock");
                        if (null != vector && !DvClassSupportSov.clazzCheck(n2, dvAddress, classDetails.address, dvAddressSpace, bl3)) {
                            vector.add("    *** Consistency check failed - clazz field not matching (showFields)");
                        }
                        long l3 = 0L;
                        long l4 = 0L;
                        long l5 = 0L;
                        String string2 = null;
                        try {
                            l4 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "signature"}, dvAddressSpace);
                            l5 = DvUtils.getFieldAddress(l, new String[]{"MemberBlock", "name"}, dvAddressSpace);
                            l3 = DvUtils.getFieldAddress(l, new String[]{"fieldblock", "value"}, dvAddressSpace);
                            if (bl3) {
                                l5 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l5));
                                l3 = (long)dvAddressSpace.readInt(dvAddressSpace.createAddress(l3)) & 0xFFFFFFFFL;
                                l4 = dvAddressSpace.readLong(dvAddressSpace.createAddress(l4));
                            } else {
                                l5 = (long)dvAddressSpace.readInt(dvAddressSpace.createAddress(l5)) & 0xFFFFFFFFL;
                                l3 = (long)dvAddressSpace.readInt(dvAddressSpace.createAddress(l3)) & 0xFFFFFFFFL;
                                l4 = (long)dvAddressSpace.readInt(dvAddressSpace.createAddress(l4)) & 0xFFFFFFFFL;
                            }
                            string2 = DvUtils.stringFromAddress(l4, dvAddressSpace);
                        }
                        catch (DvAddressException dvAddressException) {
                            // empty catch block
                        }
                        String string3 = "";
                        if (l5 != 0L) {
                            string3 = DvUtils.stringFromAddress(l5, dvAddressSpace);
                            string = " Field #" + (n2 + 1) + " @0x" + Long.toHexString(l) + " : " + string3;
                            if (null != vector) {
                                vector.add(string);
                            }
                            if (string3.equals("value") && classDetails.name.equals("java/lang/String")) {
                                stringValueOffset = l3;
                            }
                        }
                        if (l4 != 0L) {
                            string = "     " + DvClassCommands.fieldValue(l3, string2, dvAddressSpace, true);
                            if (null != vector) {
                                vector.add(string);
                            }
                        } else if (null != vector) {
                            vector.add("valueAddress:0x" + Long.toHexString(l3) + "  sigAddress:0x" + Long.toHexString(l4));
                            vector.add(DvUtils.stringFromAddress(l4, dvAddressSpace));
                            vector.add(" !!! Value unobtainable for this field");
                        }
                        if (null != vector) {
                            vector.add("      Access flags:" + DvConstants.interpretAccess(s));
                        }
                        if (bl4) {
                            fieldInfo.addField(DvUtils.stringFromAddress(l5, dvAddressSpace), DvUtils.stringFromAddress(l4, dvAddressSpace), l3, s);
                        }
                    }
                } else if (null != vector) {
                    vector.add("   *** Field block #" + n2 + " address (" + Long.toHexString(l) + ") not valid***");
                }
                ++n2;
                l += (long)fieldBlockSize;
            }
        } else if (null != vector) {
            vector.add("   *** Class has NO FIELDS ***");
        }
        if (bl4) {
            DvClassCommands.fieldsHashByName.put(classDetails.name, fieldInfo);
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.showFields");
        return fieldInfo;
    }

    public static void showClass(ClassDetails classDetails, Vector vector, Boolean bl, DvDump dvDump) {
        if (!bl.booleanValue()) {
            vector.add("\n " + classDetails.name + "\n ========================================\n");
            if (0L != classDetails.mirror_obj) {
                vector.add("  *** Warning: this is a shared class *** \n  MirroredClassData is at 0x" + Long.toHexString(classDetails.mirror_obj));
            }
            vector.add(DvBaseFmtCmds.doFormatEx("as Hjava_lang_Class", dvDump, Long.toHexString(classDetails.address)));
            if (0L != classDetails.mirror_obj) {
                vector.add("\n  *** As this is a shared class MirroredClassdata will effectively\n      overlay the MirroredClass data shown above ***** \n");
                vector.add(DvBaseFmtCmds.doFormatEx("as MirroredClassData", dvDump, Long.toHexString(classDetails.mirror_obj)));
            }
        } else {
            vector.add(classDetails);
        }
    }

    public static String getInstanceValues(Long l, String string, DvDump dvDump, Vector vector) {
        Object object;
        long l2 = l;
        DvUtils.writetoTrace(" Entry: getInstanceValues  - addr=" + Long.toHexString(l2) + "  className=" + string);
        Vector vector2 = new Vector();
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        String string3 = "";
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        Vector vector3 = DvClassCommands.getTheClassesVector();
        if (0 == vector3.size()) {
            object = new DvClassCommands();
            ((DvClassCommands)object).verb = "dis";
            ((DvClassCommands)object).verbModifier = "cls";
            ((DvClassCommands)object).displayCS();
        }
        if (0 != vector3.size()) {
            if (null == DvClassCommands.classHashByName) {
                System.out.println("classHashByName is null");
            }
            object = (Integer)DvClassCommands.classHashByName.get(string.toUpperCase());
            Integer n = (Integer)DvClassCommands.classHashByAddr.get(new Long(l2));
            if (n == null) {
                ClassDetails classDetails;
                boolean bl3 = false;
                bl = true;
                if (string.equals("java/Lang/String")) {
                    classDetails = javaLangString;
                    bl3 = true;
                } else if (null != object) {
                    classDetails = (ClassDetails)vector3.get((Integer)object);
                    if (0L != classDetails.superAddress && !classDetails.superName.equals("java/lang/Object")) {
                        bl2 = true;
                        string3 = classDetails.superName;
                    }
                } else {
                    bl = false;
                }
                if (bl) {
                    Integer n2;
                    DvClassCommands.FieldInfo fieldInfo = (DvClassCommands.FieldInfo)DvClassCommands.fieldsHashByName.get(string);
                    if (null == fieldInfo && null != (n2 = (Integer)DvClassCommands.classHashByName.get(string.toUpperCase()))) {
                        Vector vector4 = new Vector();
                        ClassDetails classDetails2 = (ClassDetails)vector3.get(n2);
                        DvClassSupportSov.showFields(classDetails2, vector4, new Boolean(true), dvDump);
                        fieldInfo = (DvClassCommands.FieldInfo)DvClassCommands.fieldsHashByName.get(string);
                    }
                    if (null == fieldInfo) {
                        bl = false;
                    } else {
                        int n3 = dvDump.getArchitecture();
                        int n4 = fieldInfo.name.size();
                        try {
                            String string4;
                            long l3 = DvUtils.getFieldAddress(l2, new String[]{"Hjava_lang_Object", "obj"}, dvAddressSpace);
                            for (int i = 0; i < n4; ++i) {
                                String string5 = (String)fieldInfo.signature.get(i);
                                long l4 = (Long)fieldInfo.offset.get(i);
                                String string6 = (String)fieldInfo.name.get(i);
                                string2 = string2 + "\n(" + l4 + ") " + string6 + "\t";
                                long l5 = l3 + l4;
                                string2 = string2 + DvClassCommands.fieldValue(l5, string5, dvAddressSpace, false);
                            }
                            if (bl2 && (string4 = DvClassSupportSov.getInstanceValues(new Long(l2), string3, dvDump, vector)) != null && !string4.equals("")) {
                                string2 = string2 + "\n    ===== Super Class expansion for: " + string3 + string4;
                            }
                        }
                        catch (DvAddressException dvAddressException) {
                            string2 = " DvAddressException in DvClassCommands:getInstanceValues";
                        }
                    }
                } else {
                    String string7 = null;
                    if (string.startsWith("array ")) {
                        long l6 = 0L;
                        int n5 = -1;
                        if (string.equals("array char")) {
                            string7 = "[C";
                        } else if (string.equals("array int")) {
                            string7 = "[I";
                        } else if (string.equals("array boolean")) {
                            string7 = "[Z";
                        } else if (string.equals("array long")) {
                            string7 = "[J";
                        } else if (string.equals("array objects")) {
                            string7 = "[L";
                        } else if (string.equals("array byte")) {
                            string7 = "[B";
                        } else if (string.equals("array short")) {
                            string7 = "[S";
                        } else if (string.equals("array double")) {
                            string7 = "[D";
                        } else if (string.equals("array float")) {
                            string7 = "[F";
                        }
                        try {
                            n5 = DvClassSupportSov.getArrayElementCount(l2, dvAddressSpace);
                            if (null != string7) {
                                string2 = string2 + "\n\t <<" + DvClassCommands.interpretValue(string7, l2, dvAddressSpace, true) + ">>";
                            } else {
                                string2 = " No array expansion available";
                                string2 = string2 + "\nArray Size:" + n5 + "\n";
                            }
                        }
                        catch (DvAddressException dvAddressException) {
                            string2 = "  exception in array processing in getInstanceValues";
                        }
                    }
                    bl = true;
                }
            } else {
                string2 = " No instance values: ClassClass rather than instance of class";
                bl = true;
            }
        } else if (vector != null) {
            vector.add("\n After displayCS there are still no classes available\n");
        }
        DvUtils.writetoTrace(" Exit: getInstanceValues");
        if (bl) {
            return string2;
        }
        return string2 + badString;
    }

    private int processSharedClass(long l, DvAddressSpace dvAddressSpace, DvDump dvDump, long l2, int n, Vector vector) {
        String[] stringArray;
        DvUtils.writetoTrace("Entry: DvClassCommands.processSharedClass ");
        int n2 = 0;
        int n3 = dvAddressSpace.pointerSize();
        int n4 = n;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        long l3 = DvUtils.jvmFromThreadId(dvThread.id());
        if (0L == mirrorTable && null != (stringArray = DvUtils.getJVMHint(l3, "CLASSMIRRORS"))) {
            mirrorTable = DvUtils.hexToLong((String)stringArray);
        }
        if (0L != mirrorTable) {
            stringArray = new String[]{"Hjava_lang_Class", "obj"};
            String[] stringArray2 = new String[]{"MirroredClassData", "self"};
            String[] stringArray3 = new String[]{"MirroredClassData", "memory_table"};
            String[] stringArray4 = new String[]{"Classjava_lang_Class", "shared_class_id"};
            long l4 = mirrorTable;
            long l5 = l4 + (long)(n3 * n4);
            boolean bl = false;
            while (!bl) {
                long l6 = 0L;
                long l7 = 0L;
                long l8 = 0L;
                try {
                    long l9 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l5);
                    if (0L == l9) continue;
                    l6 = 0L;
                    l7 = 0L;
                    l7 = DvUtils.getFieldAddress(l9, stringArray, dvAddressSpace);
                    l6 = DvUtils.getFieldAddress(l7, stringArray2, dvAddressSpace);
                    l8 = DvUtils.getFieldAddress(l7, stringArray3, dvAddressSpace);
                    long l10 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l6);
                    long l11 = 0L;
                    if (0L != l10) {
                        l11 = DvUtils.getFieldAddress(l10, new String[]{"Hjava_lang_Class", "obj"}, dvAddressSpace);
                    }
                    this.storeClass(l11, dvAddressSpace, dvDump, l2, vector, l7);
                    ++n2;
                    ++totalClassesCount;
                    long l12 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l8);
                    if (l12 != 0L) {
                        long l13 = DvUtils.getFieldAddress(l12, stringArray, dvAddressSpace);
                        int n5 = 0;
                        if (0L != l13) {
                            long l14 = DvUtils.getFieldAddress(l13, stringArray4, dvAddressSpace);
                            n5 = dvAddressSpace.readInt(dvAddressSpace.createAddress(l14));
                        }
                        if (0 != n5) {
                            n4 = n5;
                            l5 = l4 + (long)(n3 * n4);
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = true;
                }
                catch (DvAddressException dvAddressException) {
                    DvUtils.trace(" Shared classes addressing exception: \n  current_position=0x" + Long.toHexString(l5) + "\n  thisObj=0x" + Long.toHexString(l7) + "\n  selfAddress=0x" + Long.toHexString(l6) + "\n processSharedClass abandoned", 0, true);
                    bl = true;
                }
            }
        } else {
            DvUtils.trace(" processSharedClass: CLASSMIRRORS hint was not found", 0, true);
        }
        DvUtils.writetoTrace("Exit: DvClassCommands.processSharedClass (" + n2 + ")");
        return n2;
    }

    boolean storeClass(long l, DvAddressSpace dvAddressSpace, DvDump dvDump, long l2, Vector vector, long l3) {
        boolean bl = true;
        try {
            Vector vector2;
            Object object;
            String string;
            long l4 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "name"}, dvAddressSpace);
            long l5 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "memory_table"}, dvAddressSpace);
            long l6 = 0L;
            if (0L == l3) {
                l6 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "static_variable_values"}, dvAddressSpace);
                l6 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l6);
            } else {
                l6 = DvUtils.getFieldAddress(l3, new String[]{"MirroredClassData", "static_variable_values"}, dvAddressSpace);
                l6 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l6);
            }
            long l7 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "major_version"}, dvAddressSpace);
            long l8 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "methods"}, dvAddressSpace);
            long l9 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l8);
            long l10 = 0L;
            l10 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "fields"}, dvAddressSpace);
            long l11 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l10);
            long l12 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "methods_count"}, dvAddressSpace);
            short s = dvAddressSpace.readShort(dvAddressSpace.createAddress(l12));
            long l13 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "fields_count"}, dvAddressSpace);
            short s2 = dvAddressSpace.readShort(dvAddressSpace.createAddress(l13));
            long l14 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "instance_size"}, dvAddressSpace);
            short s3 = dvAddressSpace.readShort(dvAddressSpace.createAddress(l14));
            long l15 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "static_variable_count"}, dvAddressSpace);
            short s4 = dvAddressSpace.readShort(dvAddressSpace.createAddress(l15));
            byte[] byArray = dvAddressSpace.readBytes(dvAddressSpace.createAddress(l7), 4L);
            long l16 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l4);
            try {
                byte[] byArray2 = dvAddressSpace.readBytes(dvAddressSpace.createAddress(l16), 256L);
                string = null != byArray2 ? DvUtils.getStringFromBytes(byArray2) : " --- unknown --- @ 0x" + Long.toHexString(l16);
            }
            catch (DvAddressException dvAddressException) {
                string = " --- unknown --- @ 0x" + Long.toHexString(l16);
            }
            long l17 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "superclass"}, dvAddressSpace);
            long l18 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l17)).getAddressAsLong();
            String string2 = " --- none ---";
            if (l18 != 0L) {
                l4 = DvUtils.getFieldAddress(l, new String[]{"Classjava_lang_Class", "super_name"}, dvAddressSpace);
                l16 = DvUtils.getPtrFromPtr(dvDump, dvAddressSpace, l4);
                try {
                    string2 = DvUtils.getStringFromBytes(dvAddressSpace.readBytes(dvAddressSpace.createAddress(l16), 256L));
                }
                catch (DvAddressException dvAddressException) {
                    string2 = " --- unknown --- @ 0x" + Long.toHexString(l16);
                }
            }
            long l19 = DvUtils.getFieldAddress(l, new String[]{"MirroredClassData", "loader"}, dvAddressSpace);
            long l20 = 0L;
            boolean bl2 = false;
            try {
                l20 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(l19)).getAddressAsLong();
                if (0L == l20) {
                    bl2 = true;
                } else {
                    CType cType = CType.find("Classjava_lang_ClassLoader");
                    if (null != cType) {
                        DvAddress dvAddress = dvAddressSpace.createAddress(l20 + l2);
                        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "Classjava_lang_ClassLoader");
                        CTypeObject cTypeObject2 = cTypeObject.getField("initialized");
                        int n = dvAddressSpace.readInt(dvAddress = dvAddressSpace.createAddress(cTypeObject2.getAddr()));
                        if (0 != n) {
                            bl2 = true;
                        }
                    }
                }
            }
            catch (DvAddressException dvAddressException) {
                bl2 = true;
            }
            short s5 = DvUtils.bytesToShort(byArray, 0, dvDump.getArchitecture());
            short s6 = DvUtils.bytesToShort(byArray, 2, dvDump.getArchitecture());
            boolean bl3 = false;
            long l21 = l - l2;
            if (totalClassesCount > 0 && (object = (Integer)DvClassCommands.classHashByAddr.get(new Long(l21))) != null) {
                vector2 = DvClassCommands.getTheClassesVector();
                ClassDetails classDetails = (ClassDetails)vector2.get((Integer)object);
                if (l21 == classDetails.address) {
                    vector.add(" Circularity detected creating class table ");
                    vector.add("   Class " + classDetails.name + " #" + (Integer)object + " has matching address to proposed #" + totalClassesCount + 1);
                    bl3 = true;
                }
            }
            if (!bl3) {
                object = new ClassDetails();
                ((ClassDetails)object).name = string;
                ((ClassDetails)object).superName = string2;
                ((ClassDetails)object).superAddress = l18;
                ((ClassDetails)object).address = l21;
                ((ClassDetails)object).major_version = s5;
                ((ClassDetails)object).minor_version = s6;
                ((ClassDetails)object).methods = l9;
                ((ClassDetails)object).fields = l11;
                ((ClassDetails)object).methods_count = s;
                ((ClassDetails)object).fields_count = s2;
                ((ClassDetails)object).loaderInitd = bl2;
                ((ClassDetails)object).instance_size = s3;
                ((ClassDetails)object).static_variable_count = s4;
                ((ClassDetails)object).static_variable_values = l6;
                ((ClassDetails)object).mirror_obj = l3 == 0L ? 0L : l3;
                vector2 = DvClassCommands.getTheClassesVector();
                vector2.add(object);
                if (string.equals("java/lang/String")) {
                    javaLangString = object;
                }
                DvClassCommands.classHashByAddr.put(new Long(l21), new Integer(totalClassesCount));
                DvClassCommands.classHashByName.put(((ClassDetails)object).name.toUpperCase(), new Integer(totalClassesCount));
            }
        }
        catch (DvAddressException dvAddressException) {
            vector.add(" DvAddressException whilst accessing class");
            vector.add(" data from file:\n" + dvAddressException.getMessage());
        }
        return bl;
    }

    static int getArrayElementCount(long l, DvAddressSpace dvAddressSpace) throws DvAddressException {
        long l2 = DvUtils.getFieldAddress(l, new String[]{"Hjava_lang_Object", "methods"}, dvAddressSpace);
        return dvAddressSpace.readInt(dvAddressSpace.createAddress(l2));
    }

    private static boolean clazzCheck(int n, DvAddress dvAddress, long l, DvAddressSpace dvAddressSpace, boolean bl) {
        boolean bl2 = true;
        try {
            if (bl) {
                if (l != dvAddressSpace.readLong(dvAddress)) {
                    bl2 = false;
                }
            } else if (l != (long)dvAddressSpace.readInt(dvAddress)) {
                bl2 = false;
            }
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace("\n Method Block entry #" + (n + 1) + "\n produced DvAddressException" + Long.toHexString(l) + "\n Address: ");
            bl2 = false;
        }
        return bl2;
    }

    static {
        ptrLength = 4;
        cc1 = 0;
        cc2 = 0;
        cc3 = 0;
        totalClassesCount = 0;
        commandsSupported = new String[0];
        mySuffixes = new String[]{"sov"};
        mirrorTable = 0L;
        stringValueOffset = 0L;
        javaLangString = null;
    }
}

