/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.plugins.CommandPluginResponse;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CommandPlugin
extends Thread {
    public Method method;
    public String paramString;
    public String verb = null;
    public String verbModifier = null;
    public String verbModifierForFind = null;
    public String seperator = null;
    public Vector enhancers = null;
    public boolean forcedEnd = false;
    public boolean addReady = false;
    public CommandPluginResponse cpr = new CommandPluginResponse();
    public boolean cpInProgress = true;
    public static boolean consolidatedOutput = false;
    public boolean hasOnDumpIdentified = false;

    public void addObserverToResponse(Observer observer) {
        this.cpr.addObserver(observer);
    }

    public void setVerb(String string) {
        this.verb = string;
    }

    public void setVerbModifier(String string) {
        if (null != string) {
            if (null != this.paramString) {
                this.verbModifierForFind = string + " " + this.paramString;
            }
            this.verbModifier = string.trim();
        } else {
            this.verbModifier = null;
        }
    }

    public void setSeperator(String string) {
        this.seperator = null != string ? string : null;
    }

    public void setForcedEnd(boolean bl) {
        this.forcedEnd = bl;
    }

    public void setAddReady(boolean bl) {
        this.addReady = bl;
    }

    public boolean getInProgress() {
        return this.cpInProgress;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setParamString(String string) {
        this.paramString = null != string ? string.trim() : null;
    }

    public void setEnhancers(String string) {
        if (null != string) {
            this.enhancers = new Vector();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                this.enhancers.add(string2);
            }
        }
    }

    public abstract String pluginName();

    public abstract String[] getSyntax();

    public abstract String[] guiPopupSyntax();

    public String help() {
        return "No help: method help not overidden in " + this.pluginName();
    }

    public String help(String string) {
        return "No help: method help not overidden in " + this.pluginName();
    }

    public boolean enhancersCheck(String[] stringArray) {
        boolean bl = true;
        if (null != stringArray && 0 != this.enhancers.size()) {
            for (int i = 0; i < this.enhancers.size(); ++i) {
                String string = ((String)this.enhancers.elementAt(i)).trim().toUpperCase();
                boolean bl2 = false;
                for (int j = 0; j < stringArray.length && !bl2; ++j) {
                    String string2 = stringArray[j].trim().toUpperCase();
                    if (!string2.equals(string)) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                i = this.enhancers.size();
                bl = false;
            }
        }
        return bl;
    }

    public boolean enhancerIsPresent(String string) {
        boolean bl = false;
        if (null != string && 0 != this.enhancers.size()) {
            for (int i = 0; i < this.enhancers.size() && !bl; ++i) {
                String string2 = ((String)this.enhancers.elementAt(i)).trim().toUpperCase();
                String string3 = string.trim().toUpperCase();
                if (!string3.equals(string2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void run() {
        Object object;
        Object object2;
        this.forcedEnd = false;
        this.cpInProgress = true;
        try {
            object2 = this.method.invoke((Object)this, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = illegalAccessException.getMessage();
            if (null != object) {
                System.err.println((String)object);
                illegalAccessException.printStackTrace(System.out);
            }
            this.forcedEnd = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("InvocationTargetException!!! method = " + this.method);
            System.err.println("Target stack trace:");
            invocationTargetException.getTargetException().printStackTrace();
            object = invocationTargetException.getMessage();
            if (null != object) {
                System.out.println((String)object);
            }
            System.err.println("Our stack trace:");
            invocationTargetException.printStackTrace(System.out);
            this.forcedEnd = true;
        }
        while (!this.forcedEnd) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("\nInterruptedException");
            }
        }
        if (this.addReady) {
            this.cpr.output("Ready...");
            if (DvConsole.echoOn) {
                object2 = System.out;
                object = DvConsole.getOriginal_output();
                System.setOut((PrintStream)object);
                System.out.println("Ready...");
                System.setOut((PrintStream)object2);
            }
        }
        this.forcedEnd = false;
        this.cpInProgress = false;
    }

    public String toString() {
        String string = "\n Method:" + this.method + "\n paramString:" + this.paramString + "\n verb:" + this.verb + "\n verbModifier:" + this.verbModifier + "\n seperator:" + this.seperator;
        return string;
    }

    public String whatIs(DvAddress dvAddress, String string, DvDump dvDump) {
        return null;
    }

    public static void setOutPutMode(boolean bl) {
        consolidatedOutput = bl;
    }

    public static boolean getOutPutMode() {
        return consolidatedOutput;
    }

    public Vector guiMenus() {
        return new Vector();
    }

    public boolean onDumpIdentified(DvDump dvDump, Vector vector, Vector vector2, String string) {
        return false;
    }

    public boolean sanityCheck(Vector vector) {
        return true;
    }

    public String[] HeapsScanned() {
        return null;
    }

    public String[] getSuffixes() {
        return null;
    }
}

