/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmds;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmdsGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DvFormatAs
implements ActionListener,
KeyListener {
    Dvifm theIFM;
    JInternalFrame jif;
    DvConsole dvConsole;
    JTextField addressText;
    JComboBox cbText;
    JButton formatButton = new JButton("Format");
    JButton cancelButton = new JButton("Cancel");
    String[] cbSelectionStrings;

    public DvFormatAs(JInternalFrame jInternalFrame, DvConsole dvConsole, String string) {
        this.theIFM = DvUtils.getTheIFM();
        this.jif = jInternalFrame;
        this.dvConsole = dvConsole;
        this.constructWindow(string);
    }

    private void constructWindow(String string) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.formatButton = new JButton("Format");
        this.cancelButton = new JButton("Cancel");
        this.formatButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel3 = this.constructFormatPanel(string);
        jTabbedPane.addTab("Format", jPanel3);
        JPanel jPanel4 = this.constructOptionsPanel();
        jTabbedPane.addTab("Options", jPanel4);
        jTabbedPane.setSelectedIndex(0);
        jPanel2.add(this.formatButton);
        jPanel2.add(this.cancelButton);
        jPanel.add(jTabbedPane);
        this.theIFM.addContentToFrame(this.jif, jPanel, jPanel2);
        this.addressText.requestFocus();
    }

    private JPanel constructFormatPanel(String string) {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(50, 30, 50, 30));
        JLabel jLabel = new JLabel("Address:");
        JLabel jLabel2 = new JLabel(" ... as CB:");
        this.addressText = new JTextField(string, 10);
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < CType.listSize(); ++n) {
            String string2 = null;
            try {
                string2 = CType.find(n).getName();
                if (string2.equals("(null)") || string2.equals("__unnamed") || string2.equals(" ") || string2.equals("") || string2.equals("void")) continue;
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    String string3 = (String)vector.get(i);
                    if (!string3.equals(string2)) continue;
                    bl = true;
                }
                if (bl) continue;
                vector.add(string2);
                continue;
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        n = vector.size();
        this.cbSelectionStrings = new String[n + 1];
        this.cbSelectionStrings[0] = "  DATA  ";
        for (int i = 1; i < n + 1; ++i) {
            String string4;
            this.cbSelectionStrings[i] = string4 = (String)vector.get(i - 1);
        }
        Arrays.sort(this.cbSelectionStrings);
        this.cbText = new JComboBox<String>(this.cbSelectionStrings);
        this.cbText.setEditable(true);
        this.addressText.addKeyListener(this);
        this.cbText.addKeyListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1, 3, 3));
        jPanel2.add(jLabel);
        jPanel2.add(this.addressText);
        jPanel2.add(jLabel2);
        jPanel2.add(this.cbText);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel constructOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(25, 30, 25, 30));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1, 3, 3));
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    public boolean doFormat() {
        boolean bl = false;
        String string = (String)this.cbText.getSelectedItem();
        String string2 = DvUtils.remove0x(this.addressText.getText());
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        String string3 = "";
        if (string.toUpperCase().equals("  DATA  ")) {
            DvUtils.writetoTrace(" Its wanted as DATA");
            string3 = DvFormatAs.formatAsData(string2, dvAddressSpace);
            JInternalFrame jInternalFrame = DvBaseFmtCmdsGui.setupFormatFrame(string3, "Data for address:" + string2, "Format .. as ..");
        } else {
            boolean bl2 = false;
            for (int i = 0; i < this.cbSelectionStrings.length; ++i) {
                if (!string.equals(this.cbSelectionStrings[i])) continue;
                bl2 = true;
            }
            if (bl2) {
                long l = Long.parseLong(string2, 16);
                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                String string4 = "Format " + string + " @0x" + Long.toHexString(l);
                CTypeObject cTypeObject = DvBaseFmtCmds.formatGeneric(dvAddress, string, dvAddressSpace);
                if (null != cTypeObject) {
                    bl = true;
                    DvUtils.writetoTrace("  ... CTypeObject obtained");
                    string3 = cTypeObject.toString();
                    JInternalFrame jInternalFrame = DvBaseFmtCmdsGui.setupFormatFrame(string3, string4, "Format .. as .. " + string);
                }
            } else {
                Dumpviewer.genericInfoMessage(string + " is not a known or handled control block\n" + " Try selecting one from the list.");
            }
        }
        return bl;
    }

    public boolean checkValidFields() {
        boolean bl = true;
        String string = this.addressText.getText();
        DvUtils.writetoTrace("Format " + this.addressText.getText());
        if (string.equals("")) {
            bl = false;
            JOptionPane.showMessageDialog(null, "An address string must be entered.");
            this.addressText.requestFocus();
        } else {
            string = DvUtils.remove0x(string);
            long l = 0L;
            try {
                l = Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog(null, "Invalid address string entered.");
                this.addressText.requestFocus();
            }
            if (bl) {
                DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
                if (null != dvAddressSpace) {
                    DvAddress dvAddress = dvAddressSpace.createAddress(l);
                    if (!DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                        bl = false;
                        JOptionPane.showMessageDialog(null, "Address not available in the dump.");
                        this.addressText.requestFocus();
                    }
                } else {
                    bl = false;
                    JOptionPane.showMessageDialog(null, "Invalid address space for dump.");
                    this.addressText.requestFocus();
                }
            }
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.formatButton) {
            DvUtils.writetoTrace("Format Button action in FormatAs");
            if (this.checkValidFields()) {
                this.doFormat();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            DvUtils.writetoTrace("Cancel Button action in FormatAs");
            this.jif.setVisible(false);
            this.theIFM.removeIFrame(this.jif, true);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            DvUtils.writetoTrace("Enter Key pressed in format Text field");
            if (this.checkValidFields()) {
                this.doFormat();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public static String formatAsData(String string, DvAddressSpace dvAddressSpace) {
        String string2 = "";
        long l = Long.parseLong(string, 16);
        string2 = "Data from address 0x" + string;
        DvAddress dvAddress = new DvAddress(l);
        try {
            int n = dvAddressSpace.readByte(dvAddress);
            if (n < 0) {
                n += 256;
            }
            string2 = string2 + "\nbyte = 0x" + DvUtils.byteToHex.substring(2 * n, 2 * n + 2);
            string2 = string2 + "\nJava short = " + dvAddressSpace.readShort(dvAddress) + " (0x" + Long.toHexString(dvAddressSpace.readShort(dvAddress)) + ")";
            string2 = string2 + "\nJava int = " + dvAddressSpace.readInt(dvAddress) + " (0x" + Long.toHexString(dvAddressSpace.readInt(dvAddress)) + ")";
            string2 = string2 + "\nJava long = " + dvAddressSpace.readLong(dvAddress) + " (0x" + Long.toHexString(dvAddressSpace.readLong(dvAddress)) + ")";
            string2 = string2 + "\nPointer = " + Long.toHexString(dvAddressSpace.readPointer(dvAddress).getAddressAsLong());
        }
        catch (DvAddressException dvAddressException) {
            string2 = string2 + "\n ... Terminated unexpectedly ..";
        }
        String string3 = "";
        String string4 = "";
        String string5 = "0x";
        for (int i = 0; i < 16; ++i) {
            try {
                int n;
                int n2 = n = dvAddressSpace.readByte(new DvAddress(l + (long)i));
                if (n2 < 0) {
                    n2 += 256;
                }
                string5 = string5 + DvUtils.byteToHex.substring(2 * n2, 2 * n2 + 2);
                string3 = string3 + DvUtils.byteToAscii.substring(n2, n2 + 1);
                string4 = string4 + DvUtils.byteToEbcdic.substring(n2, n2 + 1);
                continue;
            }
            catch (DvAddressException dvAddressException) {
                i = 16;
            }
        }
        string2 = string2 + "\nHex = " + string5;
        string2 = string2 + "\nAscii = " + string3;
        string2 = string2 + "\nEbcdic = " + string4;
        return string2;
    }
}

